/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.menu.sectionimport;

import au.com.ordermate.application.GuiApp;
import au.com.ordermate.gui.actions.BasicAction;
import au.com.ordermate.guicore.task.Task;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.util.image.IconLoader;
import ca.odell.glazedlists.EventList;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import officemate.adminkit.dialogs.OfficeMateGuiHandler;
import officemate.adminkit.state.BasicOfficeMateState;
import officemate.screens.setup.menu.sectionimport.ImportTask;
import officemate.screens.setup.menu.sectionimport.SectionImportPanel;
import ordermate.database.inventory.InventoryGroup;
import ordermate.database.inventory.InventoryProfile;
import ordermate.database.users.AllPermissions;
import ordermate.gui.dialogs.ProgressDialog;

public class SectionImportState
extends BasicOfficeMateState {
    private SectionImportPanel gui;
    private RefreshAction refreshAction;
    private ImportTask importTask = new ImportTask();

    public SectionImportState() {
        super("Section Import", AllPermissions.IMPORT_MENU, "Import Sections from one profile to another");
        this.refreshAction = new RefreshAction();
        this.addAction(this.getRefreshAction());
        this.importTask.done.connect((Object)this, "refresh");
    }

    public List getGroupList(InventoryProfile profile) {
        ArrayList<String> states = new ArrayList<String>();
        states.add("INACTIVE");
        states.add("ACTIVE");
        String sql = Query.select(InventoryGroup.class).equals(InventoryGroup.Properties.PROFILE, (Object)profile.getID()).wherePropertyIn(InventoryGroup.Properties.SYSTEM_STATE, states).toString();
        return PersistenceManager.getObjectList(InventoryGroup.class, (String)sql, (Object[])new Object[0]);
    }

    @Override
    protected void init() {
        this.gui = new SectionImportPanel((Action)((Object)new ImportAction()), this.getRefreshAction());
        this.setScreenPanel(this.gui);
    }

    @Override
    protected void onStart() {
        if (this.isFirstRun()) {
            this.init();
        }
        this.gui.refresh();
        this.refresh();
    }

    @Override
    public void refresh() {
        SwingUtilities.invokeLater(this.refreshAction);
    }

    @Override
    public Action getRefreshAction() {
        return this.refreshAction;
    }

    private class RefreshAction
    extends BasicAction
    implements Runnable {
        public RefreshAction() {
            super("Refresh", (Icon)IconLoader.get((String)"/ordermate/images/refresh_icon22.png"));
        }

        public void actionPerformed(ActionEvent e) {
            this.run();
        }

        @Override
        public void run() {
            if (!SwingUtilities.isEventDispatchThread()) {
                throw new IllegalStateException("SWING Event Dispatch Thread violation, code should be run on EDT");
            }
            final InventoryProfile sourceProfile = SectionImportState.this.gui.getSourceProfile();
            final InventoryProfile targetProfile = SectionImportState.this.gui.getTargetProfile();
            final EventList source = SectionImportState.this.gui.getSourceList();
            final EventList target = SectionImportState.this.gui.getTargetList();
            new SwingWorker(){
                private List sourceGroups;
                private List targetGroups;

                protected Object doInBackground() throws Exception {
                    this.sourceGroups = SectionImportState.this.getGroupList(sourceProfile);
                    this.targetGroups = SectionImportState.this.getGroupList(targetProfile);
                    return null;
                }

                @Override
                protected void done() {
                    source.getReadWriteLock().writeLock().lock();
                    target.getReadWriteLock().writeLock().lock();
                    try {
                        source.clear();
                        source.addAll((Collection)this.sourceGroups);
                        target.clear();
                        target.addAll((Collection)this.targetGroups);
                    }
                    finally {
                        source.getReadWriteLock().writeLock().unlock();
                        target.getReadWriteLock().writeLock().unlock();
                    }
                }
            }.execute();
        }
    }

    private class ImportAction
    extends BasicAction {
        public ImportAction() {
            super("Start Import", (Icon)IconLoader.get((String)"/ordermate/images/right_arrow.png"), "Import Menu Sections");
        }

        public void actionPerformed(ActionEvent e) {
            JOptionPane errorPane;
            InventoryProfile sourceP = SectionImportState.this.gui.getSourceProfile();
            InventoryProfile targetP = SectionImportState.this.gui.getTargetProfile();
            List<InventoryGroup> groupsToImport = SectionImportState.this.gui.getSelectedSourceGroups();
            boolean doImport = false;
            if (groupsToImport.size() == 0) {
                errorPane = new JOptionPane("Please choose some sections from the source profile to import.", 0);
                JDialog dialog = errorPane.createDialog(GuiApp.getAppComplex().getApplicationFrame().getFrame(), "No Sections Selected");
                dialog.setVisible(true);
            } else if (sourceP.equals((Object)targetP)) {
                errorPane = new JOptionPane("Source and target profiles are the same. Please choose different profiles.", 0);
                JDialog dialog = errorPane.createDialog(GuiApp.getAppComplex().getApplicationFrame().getFrame(), "Source and target are the same");
                dialog.setVisible(true);
            } else {
                JOptionPane warnPane = new JOptionPane("Are you sure you want to import the selected Menu Sections from " + sourceP.getLabel() + " to " + targetP.getLabel() + "?", 2, 0, this.getSmallIcon());
                JDialog dialog = warnPane.createDialog(GuiApp.getAppComplex().getApplicationFrame().getFrame(), "Import Menu Sections");
                dialog.setVisible(true);
                if (warnPane.getValue().equals(new Integer(0))) {
                    doImport = true;
                }
            }
            if (doImport) {
                SectionImportState.this.importTask.setup(groupsToImport, SectionImportState.this.gui.getSelectedTargetGroup(), targetP, new OfficeMateGuiHandler());
                ProgressDialog dialog = new ProgressDialog((Frame)GuiApp.getAppComplex().getApplicationFrame().getFrame(), true, (Task)SectionImportState.this.importTask);
                dialog.start();
            }
        }
    }
}

