/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.menu.triggers;

import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PropertiedObject;
import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import javax.swing.AbstractAction;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import officemate.OfficeMate;
import officemate.adminkit.AbstractObjectEditorPanel;
import officemate.adminkit.ObjectTemplate;
import officemate.adminkit.fieldpanels.FieldPanel;
import officemate.adminkit.templates.ItemsOrderedTriggerTemplate;
import officemate.screens.setup.menu.triggers.ItemsOrderedTriggerEditor;
import officemate.screens.setup.menu.triggers.TriggerEmbeddedEditor;
import ordermate.database.inventory.triggers.AbstractTrigger;
import ordermate.database.inventory.triggers.AccountTypeTrigger;
import ordermate.database.inventory.triggers.CompositeTrigger;
import ordermate.database.inventory.triggers.CustomerCategoryTrigger;
import ordermate.database.inventory.triggers.DateTrigger;
import ordermate.database.inventory.triggers.DefaultTrigger;
import ordermate.database.inventory.triggers.DeliveryZoneTrigger;
import ordermate.database.inventory.triggers.ItemsOrderedTypeTrigger;
import ordermate.database.inventory.triggers.LimitedPurchaseTrigger;
import ordermate.database.inventory.triggers.PropertyTrigger;
import ordermate.database.inventory.triggers.RandomTrigger;
import ordermate.database.inventory.triggers.ShiftTrigger;
import ordermate.database.inventory.triggers.TableGroupTrigger;
import ordermate.database.inventory.triggers.TableNameTrigger;
import ordermate.database.inventory.triggers.TerminalLocationTrigger;
import ordermate.database.inventory.triggers.TimeTrigger;
import ordermate.database.misc.SystemCurrentInfo;
import ordermate.signals.Signal;
import ordermate.signals.Signals;

public class TriggerEditor
extends AbstractObjectEditorPanel {
    private final int EditorWidth = 650;
    private final int EditorHeight = 580;
    private JComboBox typeCombo;
    private Signal newTriggerSignal;
    private TriggerEmbeddedEditor<ItemsOrderedTypeTrigger> itemsOrderedEditor;

    @Override
    public void initComponents() {
        FormLayout layout = this.createFormLayout();
        this.setLayout((LayoutManager)layout);
        DefaultFormBuilder builder = new DefaultFormBuilder(layout, (JPanel)this);
        builder.setDefaultDialogBorder();
        builder.appendSeparator("Trigger settings");
        builder.append("Name", (Component)this.getFieldPanel("Name"));
        this.typeCombo = new JComboBox<AbstractTrigger.Types>(new AbstractTrigger.Types[]{AccountTypeTrigger.TYPE, CompositeTrigger.TYPE, ShiftTrigger.TYPE, TerminalLocationTrigger.TYPE, TimeTrigger.TYPE, DateTrigger.TYPE, RandomTrigger.TYPE, CustomerCategoryTrigger.TYPE, LimitedPurchaseTrigger.TYPE, PropertyTrigger.TYPE, ItemsOrderedTypeTrigger.TYPE, DeliveryZoneTrigger.TYPE, TableGroupTrigger.TYPE, TableNameTrigger.TYPE});
        this.typeCombo.setAction(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object selection;
                AbstractTrigger currentTrigger = (AbstractTrigger)TriggerEditor.this.getEditedObject();
                if (currentTrigger != null) {
                    currentTrigger.setLabel((String)TriggerEditor.this.getFieldPanel("Name").getValue());
                }
                if ((selection = TriggerEditor.this.typeCombo.getSelectedItem()).equals(AccountTypeTrigger.TYPE)) {
                    TriggerEditor.this.changeObjectTo(AccountTypeTrigger.class);
                } else if (selection.equals(CompositeTrigger.TYPE)) {
                    TriggerEditor.this.changeObjectTo(CompositeTrigger.class);
                } else if (selection.equals(DefaultTrigger.TYPE)) {
                    TriggerEditor.this.changeObjectTo(DefaultTrigger.class);
                } else if (selection.equals(ShiftTrigger.TYPE)) {
                    TriggerEditor.this.changeObjectTo(ShiftTrigger.class);
                } else if (selection.equals(TerminalLocationTrigger.TYPE)) {
                    TriggerEditor.this.changeObjectTo(TerminalLocationTrigger.class);
                } else if (selection.equals(TimeTrigger.TYPE)) {
                    TriggerEditor.this.changeObjectTo(TimeTrigger.class);
                } else if (selection.equals(DateTrigger.TYPE)) {
                    TriggerEditor.this.changeObjectTo(DateTrigger.class);
                } else if (selection.equals(RandomTrigger.TYPE)) {
                    TriggerEditor.this.changeObjectTo(RandomTrigger.class);
                } else if (selection.equals(CustomerCategoryTrigger.TYPE)) {
                    TriggerEditor.this.changeObjectTo(CustomerCategoryTrigger.class);
                } else if (selection.equals(LimitedPurchaseTrigger.TYPE)) {
                    TriggerEditor.this.changeObjectTo(LimitedPurchaseTrigger.class);
                } else if (selection.equals(PropertyTrigger.TYPE)) {
                    TriggerEditor.this.changeObjectTo(PropertyTrigger.class);
                } else if (selection.equals(ItemsOrderedTypeTrigger.TYPE)) {
                    TriggerEditor.this.changeObjectTo(ItemsOrderedTypeTrigger.class);
                } else if (selection.equals(DeliveryZoneTrigger.TYPE)) {
                    TriggerEditor.this.changeObjectTo(DeliveryZoneTrigger.class);
                } else if (selection.equals(TableGroupTrigger.TYPE)) {
                    TriggerEditor.this.changeObjectTo(TableGroupTrigger.class);
                } else if (selection.equals(TableNameTrigger.TYPE)) {
                    TriggerEditor.this.changeObjectTo(TableNameTrigger.class);
                }
            }
        });
        builder.nextLine();
        builder.append("Type", (Component)this.typeCombo);
        builder.nextLine();
        builder.appendSeparator("Details");
        FieldPanel negateCheck = this.getFieldPanel(AbstractTrigger.Properties.NEGATE);
        builder.append("Negate", (Component)negateCheck);
        builder.nextLine();
        FieldPanel canOverrideCheck = this.getFieldPanel(AbstractTrigger.Properties.CAN_OVERRIDE);
        builder.append("Can Override?", (Component)canOverrideCheck);
        builder.nextLine();
        Dimension preferredSize = new Dimension(650, 580);
        this.newTriggerSignal = null;
        Class clazz = this.getTemplate().getObjectJavaClass();
        if (clazz.equals(DefaultTrigger.class)) {
            this.setupDefaultTrigger();
        } else if (clazz.equals(AccountTypeTrigger.class)) {
            this.setupAccoutTypeTrigger(builder);
        } else if (clazz.equals(CompositeTrigger.class)) {
            this.setupCompositeTrigger(builder);
        } else if (clazz.equals(ShiftTrigger.class)) {
            this.setupShiftTrigger(builder);
        } else if (clazz.equals(TerminalLocationTrigger.class)) {
            this.setupTerminalLocationTrigger(builder);
        } else if (clazz.equals(TimeTrigger.class)) {
            this.setupTimeTrigger(builder);
        } else if (clazz.equals(DateTrigger.class)) {
            this.setupDateTrigger(builder);
        } else if (clazz.equals(RandomTrigger.class)) {
            this.setupRandomTrigger(builder);
        } else if (clazz.equals(CustomerCategoryTrigger.class)) {
            this.setupCustomerCategoryTrigger(builder);
        } else if (clazz.equals(LimitedPurchaseTrigger.class)) {
            this.setupLimitedPurchaseTrigger(builder);
        } else if (clazz.equals(PropertyTrigger.class)) {
            this.setupPropertyTrigger(builder);
        } else if (clazz.equals(ItemsOrderedTypeTrigger.class)) {
            this.setupItemsOrderedTrigger(builder);
        } else if (clazz.equals(DeliveryZoneTrigger.class)) {
            this.setupDeliveryZoneTrigger(builder);
        } else if (clazz.equals(TableGroupTrigger.class)) {
            this.setupTableGroupTrigger(builder);
        } else if (clazz.equals(TableNameTrigger.class)) {
            this.setupTableNameTrigger(builder);
        }
        this.setPreferredSize(preferredSize);
    }

    private void changeObjectTo(Class toChangeTo) {
        if (this.getTemplate().getObjectJavaClass().equals(toChangeTo)) {
            return;
        }
        try {
            AbstractTrigger newTrigger = (AbstractTrigger)toChangeTo.newInstance();
            AbstractTrigger currentTrigger = (AbstractTrigger)this.getEditedObject();
            if (currentTrigger.isPersistent()) {
                PersistenceManager.setID((PersistentObject)newTrigger, (Long)currentTrigger.intID());
            }
            newTrigger.setLabel(currentTrigger.getLabel());
            this.init(newTrigger);
            this.revalidate();
            this.repaint();
        }
        catch (Exception e) {
            OfficeMate.LOG.warn("Error changing trigger type", (Throwable)e);
        }
    }

    public void init(Object o) {
        this.init(this.getObjectManager(), this.getObjectManager().getTemplate(o.getClass()), o);
    }

    @Override
    public void setEditedObject(Object toEdit) {
        AbstractTrigger editTrigger = (AbstractTrigger)toEdit;
        if (editTrigger == null) {
            editTrigger = new AccountTypeTrigger();
        }
        if (!this.getTemplate().getObjectJavaClass().equals(editTrigger.getClass())) {
            this.init(editTrigger);
        }
        super.setEditedObject(editTrigger);
        if (this.getTemplate().getObjectJavaClass().equals(ItemsOrderedTypeTrigger.class)) {
            this.itemsOrderedEditor.setEditedObject((ItemsOrderedTypeTrigger)editTrigger);
        }
        if (this.newTriggerSignal != null) {
            this.newTriggerSignal.emit();
        }
    }

    private void setupDefaultTrigger() {
        this.typeCombo.setSelectedItem(DefaultTrigger.TYPE);
    }

    private void setupAccoutTypeTrigger(DefaultFormBuilder builder) {
        FieldPanel typePanel = this.getFieldPanel(AccountTypeTrigger.Properties.ACCOUNT_TYPE);
        builder.append("Account type", (Component)typePanel);
        this.typeCombo.setSelectedItem(AccountTypeTrigger.TYPE);
    }

    private void setupCompositeTrigger(DefaultFormBuilder builder) {
        FieldPanel compositeTypePanel = this.getFieldPanel(CompositeTrigger.Properties.COMPOSITE_TYPE);
        builder.append("Activate on", (Component)compositeTypePanel);
        FieldPanel subObjectList = this.getFieldPanel(CompositeTrigger.Properties.TRIGGERS);
        builder.nextLine();
        builder.append("Sub-Triggers", (Component)subObjectList);
        this.typeCombo.setSelectedItem(CompositeTrigger.TYPE);
    }

    private void setupShiftTrigger(DefaultFormBuilder builder) {
        FieldPanel shiftPanel = this.getFieldPanel(ShiftTrigger.Properties.SHIFT);
        builder.append("Shift", (Component)shiftPanel);
        this.typeCombo.setSelectedItem(ShiftTrigger.TYPE);
    }

    private void setupTerminalLocationTrigger(DefaultFormBuilder builder) {
        FieldPanel locationPanel = this.getFieldPanel(TerminalLocationTrigger.Properties.LOCATION);
        builder.append("Location", (Component)locationPanel);
        this.typeCombo.setSelectedItem(TerminalLocationTrigger.TYPE);
    }

    private void setupTableGroupTrigger(DefaultFormBuilder builder) {
        FieldPanel sectionPanel = this.getFieldPanel(TableGroupTrigger.Properties.TABLE_GROUP);
        builder.append("Table Section", (Component)sectionPanel);
        this.typeCombo.setSelectedItem(TableGroupTrigger.TYPE);
    }

    private void setupTableNameTrigger(DefaultFormBuilder builder) {
        FieldPanel sectionPanel = this.getFieldPanel(TableNameTrigger.Properties.TABLE_NAME);
        builder.append("Table Name", (Component)sectionPanel);
        this.typeCombo.setSelectedItem(TableNameTrigger.TYPE);
    }

    private void setupCustomerCategoryTrigger(DefaultFormBuilder builder) {
        FieldPanel customerCategoryPanel = this.getFieldPanel(CustomerCategoryTrigger.Properties.CUSTOMER_CATEGORY);
        builder.append("Customer category", (Component)customerCategoryPanel);
        this.typeCombo.setSelectedItem(CustomerCategoryTrigger.TYPE);
    }

    private void setupRandomTrigger(DefaultFormBuilder builder) {
        FieldPanel probabilityPanel = this.getFieldPanel(RandomTrigger.Properties.PROBABILITY);
        builder.append("Probability", (Component)probabilityPanel);
        this.typeCombo.setSelectedItem(RandomTrigger.TYPE);
    }

    private void setupLimitedPurchaseTrigger(DefaultFormBuilder builder) {
        FieldPanel numPanel = this.getFieldPanel(LimitedPurchaseTrigger.Properties.NUMBER_OF_TIMES);
        FieldPanel levelPanel = this.getFieldPanel(LimitedPurchaseTrigger.Properties.PRICE_LEVEL);
        JPanel wrapper = new JPanel(new BorderLayout());
        wrapper.add((Component)numPanel, "West");
        wrapper.add((Component)new JLabel("    times per day"), "Center");
        builder.append("Limit to", (Component)wrapper);
        builder.nextRow();
        builder.append("for price level", (Component)levelPanel);
        this.typeCombo.setSelectedItem(LimitedPurchaseTrigger.TYPE);
    }

    private void setupTimeTrigger(DefaultFormBuilder builder) {
        TimeTriggerEditor editor = new TimeTriggerEditor(builder);
        editor.construct();
        this.newTriggerSignal = editor.newTimeTrigger;
    }

    private void setupDateTrigger(DefaultFormBuilder builder) {
        FieldPanel startTimePanel = this.getFieldPanel((PropertiedObject.Property)DateTrigger.Properties.START_TIME_AS_TIME);
        FieldPanel endTimePanel = this.getFieldPanel(DateTrigger.END_TIME);
        FieldPanel startDatePanel = this.getFieldPanel(DateTrigger.Properties.START_DATE);
        FieldPanel endDatePanel = this.getFieldPanel(DateTrigger.Properties.END_DATE);
        builder.append("Start Date", (Component)startDatePanel);
        builder.nextRow();
        builder.append("End Date", (Component)endDatePanel);
        builder.nextRow();
        builder.append("Start Time", (Component)startTimePanel);
        builder.nextRow();
        builder.append("End Time", (Component)endTimePanel);
        this.typeCombo.setSelectedItem(DateTrigger.TYPE);
    }

    private void setupPropertyTrigger(DefaultFormBuilder builder) {
        FieldPanel propertyOpPanel = this.getFieldPanel(PropertyTrigger.Properties.PROPERTY_OP);
        FieldPanel propertyPanel = this.getFieldPanel(PropertyTrigger.Properties.PROPERTY);
        FieldPanel comparisonPanel = this.getFieldPanel(PropertyTrigger.Properties.COMPARISON);
        FieldPanel valueOpPanel = this.getFieldPanel(PropertyTrigger.Properties.VALUE_OP);
        FieldPanel valuePanel = this.getFieldPanel(PropertyTrigger.Properties.VALUE);
        builder.append("Property Operation", (Component)propertyOpPanel);
        builder.nextLine();
        builder.append("Property", (Component)propertyPanel);
        builder.nextLine();
        builder.append("Comparison", (Component)comparisonPanel);
        builder.nextLine();
        builder.append("Value Operation", (Component)valueOpPanel);
        builder.nextLine();
        builder.append("Value", (Component)valuePanel);
        this.typeCombo.setSelectedItem(PropertyTrigger.TYPE);
    }

    private void setupItemsOrderedTrigger(DefaultFormBuilder builder) {
        this.itemsOrderedEditor = new ItemsOrderedTriggerEditor();
        this.itemsOrderedEditor.construct(builder);
        FieldPanel typePanel = this.getFieldPanel(ItemsOrderedTypeTrigger.Properties.ACTIVATION_TYPE);
        builder.append("Activation", (Component)typePanel);
        this.typeCombo.setSelectedItem(ItemsOrderedTypeTrigger.TYPE);
    }

    private void setupDeliveryZoneTrigger(DefaultFormBuilder builder) {
        FieldPanel typePanel = this.getFieldPanel(DeliveryZoneTrigger.Properties.DELIVERY_ZONE);
        builder.append("Delivery Zone", (Component)typePanel);
        this.typeCombo.setSelectedItem(DeliveryZoneTrigger.TYPE);
    }

    @Override
    public void saveObject() {
        ObjectTemplate triggerTemplate = this.getTemplate();
        if (triggerTemplate.getObjectJavaClass().equals(ItemsOrderedTypeTrigger.class)) {
            ItemsOrderedTypeTrigger editedObject = (ItemsOrderedTypeTrigger)this.getEditedObject();
            ItemsOrderedTriggerEditor itemsOrderedTriggerEditor = (ItemsOrderedTriggerEditor)this.itemsOrderedEditor;
            itemsOrderedTriggerEditor.saveProperties((ItemsOrderedTriggerTemplate)triggerTemplate, editedObject);
            this.itemsOrderedEditor.saveObject(editedObject);
        }
        super.saveObject();
        SystemCurrentInfo.setMenuUpdate((String)("Trigger " + this.getEditedObject() + " edited"));
    }

    private FormLayout createFormLayout() {
        return new FormLayout("right:pref, 3dlu, left:pref:grow, 7dlu, right:pref, 3dlu, left:pref:grow", "");
    }

    private class TimeTriggerEditor {
        final int SCROLL_WIDTH = 500;
        final int SCROLL_HEIGHT = 200;
        DefaultFormBuilder builder;
        private JCheckBox[] monthCheckBoxes;
        private JCheckBox[] dayCheckBoxes;
        private JCheckBox allMonthsCheckBox;
        private JCheckBox allWeekDaysCheckBox;
        private JCheckBox allHoursCheckBox;
        public final Signal newTimeTrigger = Signals.createSignal();

        public TimeTriggerEditor(DefaultFormBuilder newBuilder) {
            this.builder = newBuilder;
            this.newTimeTrigger.connect((Object)this, "gotNewTimeTrigger");
        }

        public void construct() {
            this.setupCheckBoxes();
            FormLayout layout = TriggerEditor.this.createFormLayout();
            JPanel timeTrigPanel = new JPanel();
            DefaultFormBuilder timeTriggerBuilder = new DefaultFormBuilder(layout, timeTrigPanel);
            JScrollPane scroll = new JScrollPane(timeTrigPanel);
            scroll.getViewport().setPreferredSize(new Dimension(500, 200));
            this.allHoursCheckBox = new JCheckBox("");
            timeTriggerBuilder.append("All day", (Component)this.allHoursCheckBox);
            timeTriggerBuilder.nextLine();
            FieldPanel startTimePanel = TriggerEditor.this.getFieldPanel(TimeTrigger.Properties.START_TIME);
            timeTriggerBuilder.append("Start time", (Component)startTimePanel);
            FieldPanel endTimePanel = TriggerEditor.this.getFieldPanel(TimeTrigger.END_TIME);
            timeTriggerBuilder.append("End time", (Component)endTimePanel);
            timeTriggerBuilder.nextLine();
            this.setupTimeActionListener();
            this.allMonthsCheckBox = new JCheckBox("");
            this.allMonthsCheckBox.setSelected(true);
            this.allWeekDaysCheckBox = new JCheckBox("");
            this.allWeekDaysCheckBox.setSelected(true);
            timeTriggerBuilder.appendSeparator("");
            timeTriggerBuilder.append("All Months", (Component)this.allMonthsCheckBox);
            timeTriggerBuilder.append("All Week", (Component)this.allWeekDaysCheckBox);
            timeTriggerBuilder.appendSeparator("");
            timeTriggerBuilder.append("January", (Component)TriggerEditor.this.getFieldPanel(TimeTrigger.Properties.JANUARY));
            timeTriggerBuilder.append("Monday", (Component)TriggerEditor.this.getFieldPanel(TimeTrigger.Properties.MONDAY));
            timeTriggerBuilder.append("Feburary", (Component)TriggerEditor.this.getFieldPanel(TimeTrigger.Properties.FEBUARY));
            timeTriggerBuilder.append("Tuesday", (Component)TriggerEditor.this.getFieldPanel(TimeTrigger.Properties.TUESDAY));
            timeTriggerBuilder.append("March", (Component)TriggerEditor.this.getFieldPanel(TimeTrigger.Properties.MARCH));
            timeTriggerBuilder.append("Wednesday", (Component)TriggerEditor.this.getFieldPanel(TimeTrigger.Properties.WEDNESDAY));
            timeTriggerBuilder.append("April", (Component)TriggerEditor.this.getFieldPanel(TimeTrigger.Properties.APRIL));
            timeTriggerBuilder.append("Thursday", (Component)TriggerEditor.this.getFieldPanel(TimeTrigger.Properties.THURSDAY));
            timeTriggerBuilder.append("May", (Component)TriggerEditor.this.getFieldPanel(TimeTrigger.Properties.MAY));
            timeTriggerBuilder.append("Friday", (Component)TriggerEditor.this.getFieldPanel(TimeTrigger.Properties.FRIDAY));
            timeTriggerBuilder.append("June", (Component)TriggerEditor.this.getFieldPanel(TimeTrigger.Properties.JUNE));
            timeTriggerBuilder.append("Saturday", (Component)TriggerEditor.this.getFieldPanel(TimeTrigger.Properties.SATURDAY));
            timeTriggerBuilder.append("July", (Component)TriggerEditor.this.getFieldPanel(TimeTrigger.Properties.JULY));
            timeTriggerBuilder.append("Sunday", (Component)TriggerEditor.this.getFieldPanel(TimeTrigger.Properties.SUNDAY));
            timeTriggerBuilder.append("August", (Component)TriggerEditor.this.getFieldPanel(TimeTrigger.Properties.AUGUST));
            timeTriggerBuilder.nextLine();
            timeTriggerBuilder.append("September", (Component)TriggerEditor.this.getFieldPanel(TimeTrigger.Properties.SEPTEMBER));
            timeTriggerBuilder.nextLine();
            timeTriggerBuilder.append("October", (Component)TriggerEditor.this.getFieldPanel(TimeTrigger.Properties.OCTOBER));
            timeTriggerBuilder.nextLine();
            timeTriggerBuilder.append("November", (Component)TriggerEditor.this.getFieldPanel(TimeTrigger.Properties.NOVEMBER));
            timeTriggerBuilder.nextLine();
            timeTriggerBuilder.append("December", (Component)TriggerEditor.this.getFieldPanel(TimeTrigger.Properties.DECEMBER));
            this.setupDateActionListeners();
            TriggerEditor.this.typeCombo.setSelectedItem(TimeTrigger.TYPE);
            this.builder.append("", (Component)scroll);
        }

        protected void gotNewTimeTrigger() {
            this.doAllDayCheckState();
            this.doAllMonthCheckState();
        }

        protected void doAllDayCheckState() {
            for (int i = 0; i < this.dayCheckBoxes.length; ++i) {
                if (this.dayCheckBoxes[i].isSelected()) continue;
                this.allWeekDaysCheckBox.setSelected(false);
                return;
            }
            this.allWeekDaysCheckBox.setSelected(true);
        }

        protected void doAllMonthCheckState() {
            for (int i = 0; i < this.monthCheckBoxes.length; ++i) {
                if (this.monthCheckBoxes[i].isSelected()) continue;
                this.allMonthsCheckBox.setSelected(false);
                return;
            }
            this.allMonthsCheckBox.setSelected(true);
        }

        public DefaultFormBuilder getBuilder() {
            return this.builder;
        }

        private void setAllMonthsSelected(boolean isSelected) {
            if (!TriggerEditor.this.getTemplate().getObjectJavaClass().equals(TimeTrigger.class)) {
                throw new IllegalStateException("Attempt to set time trigger variables by non-time trigger template.");
            }
            for (int i = 0; i < this.monthCheckBoxes.length; ++i) {
                this.monthCheckBoxes[i].setSelected(isSelected);
            }
        }

        private void setAllWeekSelected(boolean isSelected) {
            if (!TriggerEditor.this.getTemplate().getObjectJavaClass().equals(TimeTrigger.class)) {
                throw new IllegalStateException("attempt to set time trigger variables by non-time trigger template.");
            }
            for (int i = 0; i < this.dayCheckBoxes.length; ++i) {
                this.dayCheckBoxes[i].setSelected(isSelected);
            }
        }

        private void setupCheckBoxes() {
            this.dayCheckBoxes = new JCheckBox[]{(JCheckBox)TriggerEditor.this.getFieldPanel(TimeTrigger.Properties.MONDAY).getComponent(0), (JCheckBox)TriggerEditor.this.getFieldPanel(TimeTrigger.Properties.TUESDAY).getComponent(0), (JCheckBox)TriggerEditor.this.getFieldPanel(TimeTrigger.Properties.WEDNESDAY).getComponent(0), (JCheckBox)TriggerEditor.this.getFieldPanel(TimeTrigger.Properties.THURSDAY).getComponent(0), (JCheckBox)TriggerEditor.this.getFieldPanel(TimeTrigger.Properties.FRIDAY).getComponent(0), (JCheckBox)TriggerEditor.this.getFieldPanel(TimeTrigger.Properties.SATURDAY).getComponent(0), (JCheckBox)TriggerEditor.this.getFieldPanel(TimeTrigger.Properties.SUNDAY).getComponent(0)};
            this.monthCheckBoxes = new JCheckBox[]{(JCheckBox)TriggerEditor.this.getFieldPanel(TimeTrigger.Properties.JANUARY).getComponent(0), (JCheckBox)TriggerEditor.this.getFieldPanel(TimeTrigger.Properties.FEBUARY).getComponent(0), (JCheckBox)TriggerEditor.this.getFieldPanel(TimeTrigger.Properties.MARCH).getComponent(0), (JCheckBox)TriggerEditor.this.getFieldPanel(TimeTrigger.Properties.APRIL).getComponent(0), (JCheckBox)TriggerEditor.this.getFieldPanel(TimeTrigger.Properties.MAY).getComponent(0), (JCheckBox)TriggerEditor.this.getFieldPanel(TimeTrigger.Properties.JUNE).getComponent(0), (JCheckBox)TriggerEditor.this.getFieldPanel(TimeTrigger.Properties.JULY).getComponent(0), (JCheckBox)TriggerEditor.this.getFieldPanel(TimeTrigger.Properties.AUGUST).getComponent(0), (JCheckBox)TriggerEditor.this.getFieldPanel(TimeTrigger.Properties.SEPTEMBER).getComponent(0), (JCheckBox)TriggerEditor.this.getFieldPanel(TimeTrigger.Properties.OCTOBER).getComponent(0), (JCheckBox)TriggerEditor.this.getFieldPanel(TimeTrigger.Properties.NOVEMBER).getComponent(0), (JCheckBox)TriggerEditor.this.getFieldPanel(TimeTrigger.Properties.DECEMBER).getComponent(0)};
        }

        private void setupDateActionListeners() {
            if (!TriggerEditor.this.getTemplate().getObjectJavaClass().equals(TimeTrigger.class)) {
                throw new IllegalStateException("Attempt to set time trigger variables by non-time trigger template.");
            }
            ActionListener dayActionListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (!((JCheckBox)e.getSource()).isSelected()) {
                        TimeTriggerEditor.this.allWeekDaysCheckBox.setSelected(false);
                        return;
                    }
                    TimeTriggerEditor.this.doAllDayCheckState();
                }
            };
            for (int i = 0; i < this.dayCheckBoxes.length; ++i) {
                this.dayCheckBoxes[i].addActionListener(dayActionListener);
            }
            ActionListener monthActionListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (!((JCheckBox)e.getSource()).isSelected()) {
                        TimeTriggerEditor.this.allMonthsCheckBox.setSelected(false);
                        return;
                    }
                    TimeTriggerEditor.this.doAllMonthCheckState();
                }
            };
            for (int i = 0; i < this.monthCheckBoxes.length; ++i) {
                this.monthCheckBoxes[i].addActionListener(monthActionListener);
            }
            this.allMonthsCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TimeTriggerEditor.this.setAllMonthsSelected(((JCheckBox)e.getSource()).isSelected());
                }
            });
            this.allWeekDaysCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TimeTriggerEditor.this.setAllWeekSelected(((JCheckBox)e.getSource()).isSelected());
                }
            });
        }

        private void setupTimeActionListener() {
            TimeTriggerTimeEventListener eventListener = new TimeTriggerTimeEventListener();
            this.allHoursCheckBox.addActionListener(eventListener);
            ((JSpinner)TriggerEditor.this.getFieldPanel(TimeTrigger.Properties.START_TIME).getComponent(0)).addChangeListener(eventListener);
            ((JSpinner)TriggerEditor.this.getFieldPanel(TimeTrigger.END_TIME).getComponent(0)).addChangeListener(eventListener);
        }

        private class TimeTriggerTimeEventListener
        implements ChangeListener,
        ActionListener {
            private final JSpinner startSpinner;
            private final JSpinner endSpinner;
            private Date startTime;
            private Date endTime;

            TimeTriggerTimeEventListener() {
                this.startSpinner = (JSpinner)TriggerEditor.this.getFieldPanel(TimeTrigger.Properties.START_TIME).getComponent(0);
                this.endSpinner = (JSpinner)TriggerEditor.this.getFieldPanel(TimeTrigger.END_TIME).getComponent(0);
                this.startTime = new Date();
                this.startTime.setHours(0);
                this.startTime.setMinutes(0);
                this.startTime.setSeconds(0);
                this.endTime = new Date();
                this.endTime.setHours(23);
                this.endTime.setMinutes(59);
                this.endTime.setSeconds(59);
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getSource() == TimeTriggerEditor.this.allHoursCheckBox) {
                    if (TimeTriggerEditor.this.allHoursCheckBox.isSelected()) {
                        this.startSpinner.getModel().setValue(this.startTime);
                        this.endSpinner.getModel().setValue(this.endTime);
                    }
                } else {
                    throw new IllegalArgumentException("Action listener listening on object with no handler.");
                }
            }

            @Override
            public void stateChanged(ChangeEvent e) {
                Date currentStartDate = ((JSpinner.DateEditor)this.startSpinner.getEditor()).getModel().getDate();
                Date currentEndDate = ((JSpinner.DateEditor)this.endSpinner.getEditor()).getModel().getDate();
                if (e.getSource() == this.startSpinner) {
                    if (!this.equalTimeComponents(currentStartDate, this.startTime)) {
                        TimeTriggerEditor.this.allHoursCheckBox.setSelected(false);
                    } else if (this.equalTimeComponents(currentEndDate, this.endTime)) {
                        TimeTriggerEditor.this.allHoursCheckBox.setSelected(true);
                    }
                } else if (e.getSource() == this.endSpinner) {
                    if (!this.equalTimeComponents(currentEndDate, this.endTime)) {
                        TimeTriggerEditor.this.allHoursCheckBox.setSelected(false);
                    } else if (this.equalTimeComponents(currentStartDate, this.startTime)) {
                        TimeTriggerEditor.this.allHoursCheckBox.setSelected(true);
                    }
                } else {
                    throw new IllegalArgumentException("change listener listening on object with no event handler");
                }
            }

            private boolean equalTimeComponents(Date firstDate, Date secondDate) {
                return firstDate.getHours() == secondDate.getHours() && firstDate.getMinutes() == secondDate.getMinutes() && firstDate.getSeconds() == secondDate.getSeconds();
            }
        }
    }
}

