/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.menu.upsell;

import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import java.awt.Component;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import officemate.components.AbstractObjectEditor;
import officemate.screens.setup.devices.customerdisplay.ConfigResourceEditingPanel;
import officemate.screens.setup.menu.upsell.UpsellItemEditor;
import officemate.screens.setup.menu.upsell.UpsellTriggerLinkEditor;
import ordermate.database.dbconstants.SystemState;
import ordermate.database.inventory.InventoryGroup;
import ordermate.database.inventory.InventoryItem;
import ordermate.database.inventory.triggers.AbstractTrigger;
import ordermate.database.inventory.triggers.activation.TriggerActivationStrategy;
import ordermate.database.upsell.UpsellSuggestion;
import ordermate.gui.FieldPanelBuilder;

public class UpsellSuggestionEditor
extends AbstractObjectEditor<UpsellSuggestion> {
    private ConfigResourceEditingPanel configResourcePanel;
    private UpsellTriggerLinkEditor triggerLinkEditor;
    private UpsellItemEditor itemEditor;
    private EventList<AbstractTrigger> triggersList;
    private EventList<InventoryItem> itemsList;
    private JTabbedPane tabs;

    @Override
    protected void init() {
        super.init();
        this.tabs = new JTabbedPane();
        FieldPanelBuilder builder = new FieldPanelBuilder();
        JComponent component = this.setupTextField(UpsellSuggestion.Properties.LABEL, 20);
        builder.addRow("Label", (Component)component, "Name of upsell or promotion");
        component = this.setupTextArea(UpsellSuggestion.Properties.DESCRIPTION, 20, 3, null);
        builder.addRow("Description", (Component)component, "Text facing the customer");
        component = this.setupIntSpinner(UpsellSuggestion.Properties.SEQUENCE, 1, 0, Integer.MAX_VALUE, 1, 3);
        builder.addRow("Sequence", (Component)component);
        component = this.setupComboBox(UpsellSuggestion.Properties.SYSTEM_STATE, GlazedLists.eventListOf((Object[])new SystemState[]{SystemState.ACTIVE_STATE, SystemState.INACTIVE_STATE}));
        builder.addRow("System State", (Component)component);
        this.triggersList = GlazedLists.eventList((Collection)PersistenceManager.getObjectList(AbstractTrigger.class, (String)Query.select(AbstractTrigger.class).orderBy(AbstractTrigger.Properties.LABEL).active(AbstractTrigger.class).toString()));
        this.triggerLinkEditor = new UpsellTriggerLinkEditor(this.triggersList);
        builder.addRow("Triggers", (Component)this.triggerLinkEditor);
        component = this.setupComboBox(UpsellSuggestion.Properties.TRIGGER_ACTIVATION_STRATEGY, GlazedLists.eventListOf((Object[])new TriggerActivationStrategy[]{TriggerActivationStrategy.ANY_TRIGGERS, TriggerActivationStrategy.ALL_TRIGGERS}));
        builder.addRow("Trigger Activation", (Component)component);
        this.tabs.add("General", builder.getPanel());
        List activeItems = PersistenceManager.getObjectList(InventoryItem.class, (String)Query.select(InventoryItem.class).active(InventoryItem.class).orderBy(InventoryItem.Properties.LABEL).toString());
        this.itemsList = GlazedLists.eventList((Collection)activeItems);
        this.itemEditor = new UpsellItemEditor(this.itemsList);
        builder = new FieldPanelBuilder();
        builder.addRow("Upsells", (Component)this.itemEditor);
        this.tabs.add("Upsells", builder.getPanel());
        builder = new FieldPanelBuilder();
        component = this.setupCheckBox(UpsellSuggestion.Properties.UPGRADE);
        builder.addRow("Suggest Upgrade", (Component)component);
        component = this.setupNullableComboBox(UpsellSuggestion.Properties.SUGGESTED_ITEM, GlazedLists.eventList((Collection)activeItems), "<none>");
        builder.addRow("Suggest Item", (Component)component);
        List activeGroups = PersistenceManager.getObjectList(InventoryGroup.class, (String)Query.select(InventoryGroup.class).active(InventoryGroup.class).orderBy(InventoryGroup.Properties.LABEL).toString());
        component = this.setupNullableComboBox(UpsellSuggestion.Properties.SUGGESTED_GROUP, GlazedLists.eventList((Collection)activeGroups), "<none>");
        builder.addRow("Suggest Section", (Component)component);
        component = this.setupCheckBox(UpsellSuggestion.Properties.REPEATED);
        builder.addRow("Is Repeated?", (Component)component);
        this.tabs.add("Suggestions", builder.getPanel());
        this.configResourcePanel = new ConfigResourceEditingPanel();
        this.tabs.add("Advertise", this.configResourcePanel);
        this.add(this.tabs);
    }

    @Override
    public void setObject(UpsellSuggestion suggestion) {
        super.setObject(suggestion);
        this.configResourcePanel.setObject(suggestion.getResourceSet());
        this.itemEditor.setObject(suggestion);
        this.triggerLinkEditor.setObject(suggestion);
    }

    @Override
    public void saveObject() {
        this.configResourcePanel.saveObject();
        this.itemEditor.saveObject();
        this.triggerLinkEditor.saveObject();
        super.saveObject();
    }
}

