/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.stock.ingredients;

import au.com.ordermate.application.ApplicationSecurity;
import au.com.ordermate.application.GuiApp;
import ca.odell.glazedlists.BasicEventList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import officemate.adminkit.state.login.LoginState;
import officemate.components.controls.toolbar.CrudToolBar;
import officemate.components.strategy.SaveStrategy;
import officemate.components.table.PersistentObjectTable;
import officemate.components.table.TableListObjectEditor;
import officemate.components.table.TableStateCentralArea;
import officemate.components.tableformat.ColumnTableFormat;
import officemate.screens.setup.stock.ingredients.StockLinkEditor;
import ordermate.OrderMate;
import ordermate.database.config.Quantity;
import ordermate.database.queries.stock.StockItemQueries;
import ordermate.database.stock.StockItem;
import ordermate.database.stock.StockLink;
import ordermate.database.stock.StockLinkable;
import ordermate.database.stock.usagelink.StockInventoryUsageLink;
import ordermate.database.stock.usagelink.StockUsageLink;
import ordermate.database.users.AllPermissions;
import ordermate.reports.table.ColumnFormat;
import ordermate.reports.table.PropertyColumnFormat;
import ordermate.signals.Signal;
import ordermate.signals.Signals;

public class IngredientEditor<T extends StockLinkable<L>, L extends StockLink>
extends TableListObjectEditor<T, L> {
    private final Class<L> linkClass;
    private final SaveStrategy<T> saveStrategy;
    private StockLinkEditor editor;
    public static final String TEST_PANEL_NAME = "IngredientsEditor";
    public static final String ING_EDITOR_TABLE_NAME = "IngredientsEditorTable";
    private ApplicationSecurity security = GuiApp.getAppComplex().getApplicationSecurity();
    public final Signal ingredientAdded = Signals.createSignal(StockItem.class, (String)"stockItem", Quantity.class, (String)"quantity");
    public final Signal ingredientEdited = Signals.createSignal(StockItem.class, (String)"stockItem", Quantity.class, (String)"quantity");
    public final Signal ingredientRemoved = Signals.createSignal(StockItem.class, (String)"stockItem", Quantity.class, (String)"quantity");

    protected IngredientEditor(SaveStrategy<T> parentSaveStrategy, TableStateCentralArea<T> parentTable, Class<L> linkClass, CrudToolBar toolBar, List<ColumnFormat> colFormat, boolean allowEditFixedQty) {
        super(new PersistentObjectTable(new BasicEventList(), new ColumnTableFormat(colFormat.toArray(new ColumnFormat[colFormat.size()]))), toolBar);
        this.saveStrategy = parentSaveStrategy;
        this.editor = new StockLinkEditor(linkClass, allowEditFixedQty);
        this.setElementEditor(this.editor);
        this.getPersistentObjectTable().getTable().setName("ingredientsTable");
        this.linkClass = linkClass;
        if (parentTable != null) {
            parentTable.addSelectionDependentAction(toolBar.getAddAction());
        }
        this.setName(TEST_PANEL_NAME);
        toolBar.setPermission(AllPermissions.EDIT_ITEM_INGREDIENTS);
        this.getObjectTable().setName(ING_EDITOR_TABLE_NAME);
    }

    public static <T extends StockLinkable<L>, L extends StockLink> IngredientEditor<T, L> create(SaveStrategy<T> saveStrategy, TableStateCentralArea<T> masterTable, Class<L> linkClass) {
        return IngredientEditor.create(saveStrategy, masterTable, linkClass, IngredientEditor.getColumnFormat(linkClass, true), true);
    }

    public static <T extends StockLinkable<L>, L extends StockLink> IngredientEditor<T, L> create(SaveStrategy<T> saveStrategy, TableStateCentralArea<T> masterTable, Class<L> linkClass, boolean allowEditFixedQty) {
        return IngredientEditor.create(saveStrategy, masterTable, linkClass, IngredientEditor.getColumnFormat(linkClass, allowEditFixedQty), allowEditFixedQty);
    }

    public static <T extends StockLinkable<L>, L extends StockLink> IngredientEditor<T, L> create(SaveStrategy<T> saveStrategy, TableStateCentralArea<T> masterTable, Class<L> linkClass, List<ColumnFormat> columnFormat, boolean allowEditFixedQty) {
        CrudToolBar toolBar = new CrudToolBar();
        return new IngredientEditor<T, L>(saveStrategy, masterTable, linkClass, toolBar, columnFormat, allowEditFixedQty);
    }

    public static List<ColumnFormat> getColumnFormat(final Class<? extends StockLink> linkClass, final boolean showFixedQtyCol) {
        return new ArrayList<ColumnFormat>(){
            {
                this.add(new PropertyColumnFormat(StockUsageLink.Properties.STOCK_ITEM));
                this.add(new PropertyColumnFormat(StockUsageLink.Properties.QUANTITY));
                if (showFixedQtyCol) {
                    this.add(new PropertyColumnFormat(StockUsageLink.Properties.FIXED_QUANTITY));
                }
                if (StockInventoryUsageLink.class.isAssignableFrom(linkClass)) {
                    this.add(new PropertyColumnFormat(StockInventoryUsageLink.Properties.REMOVABLE));
                    this.add(new PropertyColumnFormat("Minus Price", StockInventoryUsageLink.Properties.REMOVE_PRICE));
                }
            }
        };
    }

    @Override
    public void gotParentDoubleClicked(Object selObj) {
        if (this.getPersistentObjectTable().getTable().isEditable()) {
            this.editSelectedElement();
        }
    }

    @Override
    public L createNewObject() {
        try {
            StockLink instance = (StockLink)this.linkClass.newInstance();
            if (!StockItemQueries.getStockItems().isEmpty()) {
                instance.setStockItem((StockItem)StockItemQueries.getStockItems().get(0));
            }
            if (this.editElement((L)instance)) {
                this.ingredientAdded.emit((Object)instance.getStockItem(), (Object)instance.getQuantity());
                return (L)instance;
            }
            return null;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public void addObjectToParent(L toAdd) {
        StockLinkable obj = (StockLinkable)this.getObject();
        if (obj != null) {
            obj.setStockUsage(toAdd.getStockItem(), toAdd.getQuantity(), toAdd.isFixedQuantity(), false);
        } else {
            OrderMate.LOG.warn("Editor has null object, cannot add " + toAdd);
        }
    }

    @Override
    public void removeObjectFromParent(L toRemove) {
        StockLinkable obj = (StockLinkable)this.getObject();
        if (obj != null) {
            obj.setStockUsage(toRemove.getStockItem(), null);
        } else {
            OrderMate.LOG.warn("Editor has null object cannot remove " + toRemove);
        }
    }

    @Override
    public Collection<L> getParentList() {
        StockLinkable obj = (StockLinkable)this.getObject();
        if (obj != null) {
            try {
                return obj.getStockLinks();
            }
            catch (Exception ex) {
                OrderMate.LOG.warn("Problem getting stock links. No unit?", (Throwable)ex);
            }
        }
        return new ArrayList(0);
    }

    @Override
    public void setObject(T toEdit) {
        super.setObject(toEdit);
        boolean allowed = LoginState.getInstance().getUser().hasPermission(AllPermissions.EDIT_ITEM_INGREDIENTS);
        super.getPersistentObjectTable().getTable().setEditable(allowed);
    }

    @Override
    public boolean editElement(L e) {
        this.editor.updateStockItems();
        if (super.editElement(e)) {
            this.ingredientEdited.emit((Object)e.getStockItem(), (Object)e.getQuantity());
            return true;
        }
        return false;
    }

    @Override
    public void gotObjectEdited(L edited) {
        this.saveObject();
        this.setGuiList(this.getParentList());
        if (this.saveStrategy != null) {
            this.saveStrategy.objectNeedsSaving(this.getObject());
        }
        super.gotObjectEdited(edited);
    }

    @Override
    public void removeSelectedElement() {
        StockLinkable unit = (StockLinkable)this.getObject();
        List toBeDeletedList = this.getObjectTable().getAllSelectedObjects();
        if (toBeDeletedList.size() > 0) {
            StockLink toBeDeleted = (StockLink)toBeDeletedList.get(0);
            this.ingredientRemoved.emit((Object)toBeDeleted.getStockItem(), (Object)toBeDeleted.getQuantity());
        }
        super.removeSelectedElement();
    }

    @Override
    public void removeAllElements() {
        List toBeDeletedList = this.getObjectTable().getAllSelectedObjects();
        for (StockLink toBeDeleted : toBeDeletedList) {
            this.ingredientRemoved.emit((Object)toBeDeleted.getStockItem(), (Object)toBeDeleted.getQuantity());
        }
        super.removeAllElements();
    }

    @Override
    public void revertObject() {
        if (this.getObject() != null) {
            ((StockLinkable)this.getObject()).collapseStockLinks();
        }
    }

    public Signal getIngredientAdded() {
        return this.ingredientAdded;
    }

    public Signal getIngredientEdited() {
        return this.ingredientEdited;
    }

    public Signal getIngredientRemoved() {
        return this.ingredientRemoved;
    }
}

