/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.stock.ingredients;

import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.util.Price;
import au.com.ordermate.util.image.IconLoader;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.swing.EventComboBoxModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeSupport;
import java.util.Collection;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import officemate.adminkit.fieldpanels.QuantityFieldPanel;
import officemate.adminkit.types.QuantityFieldType;
import officemate.components.AbstractObjectEditor;
import officemate.components.search.SingleSearchDialog;
import officemate.components.search.objectsearch.StockItemSearchState;
import officemate.screens.setup.stock.options.StockItemSelectorPanel;
import ordermate.database.config.Quantity;
import ordermate.database.queries.stock.StockItemQueries;
import ordermate.database.stock.StockItem;
import ordermate.database.stock.StockLink;
import ordermate.database.stock.usagelink.StockInventoryUsageLink;
import ordermate.database.stock.usagelink.StockUsageLink;
import ordermate.gui.FieldPanelBuilder;
import ordermate.gui.binding.validators.NotEmptyValidator;
import ordermate.gui.binding.validators.ObjectValidator;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.Validator;

public class StockLinkEditor<T extends StockLink>
extends AbstractObjectEditor<T> {
    private T stockLink;
    private final StockItemSelectorPanel stockPanel;
    private final QuantityFieldPanel qtyPanel;
    private final StockItemSearchState stockItemSearch = new StockItemSearchState();
    private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private boolean allowSetQtyPanelValue = true;
    private String lastMeasureScale = "";

    public StockLinkEditor(Class stockLinkClass) {
        this(stockLinkClass, true);
    }

    public StockLinkEditor(Class stockLinkClass, boolean allowEditFixedQty) {
        EventList stockItemModel = GlazedLists.eventList((Collection)StockItemQueries.getStockItems());
        JComboBox box = this.setupComboBox(new PropertiedObject.Property(stockLinkClass, StockUsageLink.Properties.STOCK_ITEM), (ComboBoxModel)new EventComboBoxModel(stockItemModel), (Validator)new ObjectValidator(StockItem.class, false));
        this.stockPanel = new StockItemSelectorPanel(box, (EventList<StockItem>)stockItemModel);
        if (stockItemModel.size() > 0) {
            box.setSelectedIndex(0);
        }
        box.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        StockLinkEditor.this.gotStockItem(StockLinkEditor.this.stockPanel.getSelectedObject());
                    }
                });
            }
        });
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)this.stockPanel, "Center");
        JButton searchButton = new JButton(IconLoader.get((String)"/ordermate/images/search16.png"));
        searchButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StockLinkEditor.this.searchForStockItem();
            }
        });
        panel.add((Component)searchButton, "East");
        this.qtyPanel = new QuantityFieldPanel();
        QuantityFieldType fieldType = new QuantityFieldType(new Quantity(1.0));
        this.qtyPanel.setFieldType(fieldType);
        Binding binding = this.getBindings().createBinding("quantity", (Object)this.qtyPanel, "value");
        binding.setValidator((Validator)new NotEmptyValidator());
        FieldPanelBuilder builder = new FieldPanelBuilder((JPanel)this);
        builder.addRow("Stock Used", (Component)panel);
        builder.addRow("Quantity Used", (Component)this.qtyPanel);
        if (allowEditFixedQty) {
            JCheckBox fixedQty = this.setupCheckBox(StockUsageLink.Properties.FIXED_QUANTITY);
            builder.addRow("Quantity Fixed", (Component)fixedQty);
        }
        if (StockInventoryUsageLink.class.isAssignableFrom(stockLinkClass)) {
            JCheckBox removeCheck = this.setupCheckBox(StockInventoryUsageLink.Properties.REMOVABLE);
            builder.addRow("Removable", (Component)removeCheck);
            builder.addRow("Minus Price", (Component)this.setupPriceField((PropertiedObject.Property<Price>)StockInventoryUsageLink.Properties.REMOVE_PRICE, 5));
        }
        builder.getPanel();
    }

    @Override
    public void saveObject() {
        super.saveObject();
        ((StockLink)this.getObject()).setQuantity(new Quantity(this.qtyPanel.getValue()));
    }

    @Override
    public void setObject(T toEdit) {
        super.setObject(toEdit);
        if (toEdit != null && toEdit.isPersistent()) {
            this.allowSetQtyPanelValue = false;
            this.qtyPanel.setValue(toEdit.getQuantity());
            this.lastMeasureScale = toEdit.getQuantity().getMeasureUnit().getScale();
        }
    }

    protected void gotStockItem(StockItem selectedItem) {
        if (selectedItem != null) {
            if (this.allowSetQtyPanelValue && !this.lastMeasureScale.equals(selectedItem.getPurchaseQty().getMeasureUnit().getScale())) {
                this.qtyPanel.setValue(selectedItem.getPurchaseQty().getAsMeasure(selectedItem.getIngredientMeasureUnit()));
                this.lastMeasureScale = selectedItem.getPurchaseQty().getMeasureUnit().getScale();
            }
        } else {
            this.qtyPanel.setValue(null);
            this.lastMeasureScale = "";
        }
        this.allowSetQtyPanelValue = true;
    }

    @Override
    public JComponent getComponent() {
        return this;
    }

    @Override
    public void revertObject() {
        this.stockLink = (StockLink)PersistenceManager.reacquire(this.stockLink);
    }

    private void searchForStockItem() {
        SingleSearchDialog<StockItem> dlg = new SingleSearchDialog<StockItem>(this.stockItemSearch, this.stockItemSearch.getTableColumnFormat(), "Stock Item", IconLoader.get((String)"/ordermate/images/search22.png"));
        this.stockItemSearch.getNameSearch().getGuiComponent().setFocusable(true);
        this.stockItemSearch.getNameSearch().getGuiComponent().requestFocus();
        StockItem item = (StockItem)dlg.doDialog(this.getComponent().getRootPane().getParent());
        if (item != null) {
            this.stockPanel.setSelectedObject(item);
        }
    }

    public void updateStockItems() {
        this.stockPanel.updateView();
    }
}

