/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.stock.items;

import au.com.ordermate.gui.adminkit.ComponentUtils;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import officemate.adminkit.fieldpanels.FieldPanel;
import officemate.adminkit.types.BusinessObjectType;
import ordermate.database.config.MeasureContainer;
import ordermate.database.config.MeasureUnit;
import ordermate.database.config.MeasureUnitContainer;
import ordermate.database.config.MeasureUnitHelper;
import ordermate.signals.Signal;
import ordermate.signals.Signals;

public class MeasureUnitContainerPanel
extends FieldPanel<BusinessObjectType>
implements ActionListener,
ChangeListener {
    private boolean changing = false;
    public Signal<MeasureUnit, ?, ?, ?, ?> measureUnitSelected = Signals.createSignal(MeasureUnit.class, (String)"measureUnit");
    private MeasureUnitContainer unitContainer;
    private BusinessObjectType type;
    private JPanel editingPanel;
    private JSpinner qtyPerContainerSpinner;
    private JComboBox unitCombo;
    private JComboBox containerCombo;
    private DefaultComboBoxModel unitModel;
    private DefaultComboBoxModel containerModel;

    public MeasureUnitContainerPanel() {
        this.setupComponents();
    }

    private void setupComponents() {
        this.unitModel = new DefaultComboBoxModel();
        this.containerModel = new DefaultComboBoxModel();
        this.editingPanel = new JPanel(new FlowLayout(0, 5, 5));
        this.qtyPerContainerSpinner = new JSpinner(new SpinnerNumberModel(1.0, 0.001, 1.0E9, 1.0));
        this.qtyPerContainerSpinner.setName("qtyPer Spinner");
        this.qtyPerContainerSpinner.addChangeListener(this);
        ((JSpinner.NumberEditor)this.qtyPerContainerSpinner.getEditor()).getTextField().setColumns(6);
        this.unitCombo = new JComboBox(this.unitModel);
        this.unitCombo.setName("Measure Unit");
        this.unitCombo.addActionListener(this);
        ComponentUtils.setupComboBox((JComboBox)this.unitCombo);
        this.containerCombo = new JComboBox(this.containerModel);
        this.containerCombo.setName("Container Combo");
        this.containerCombo.addActionListener(this);
        ComponentUtils.setupComboBox((JComboBox)this.containerCombo);
        this.editingPanel.add(this.qtyPerContainerSpinner);
        this.editingPanel.add(this.unitCombo);
        this.editingPanel.add(this.containerCombo);
        this.add(this.editingPanel);
    }

    @Override
    public Object getValue() {
        if (this.unitCombo.getSelectedItem() != null) {
            this.unitContainer.setMeasureUnit((MeasureUnit)this.unitCombo.getSelectedItem());
            this.unitContainer.setMeasureContainer((MeasureContainer)this.containerCombo.getSelectedItem());
            this.unitContainer.setQuantityPerContainer(((Double)this.qtyPerContainerSpinner.getValue()).doubleValue());
        }
        return this.unitContainer;
    }

    @Override
    public void setFieldType(BusinessObjectType fType) {
        this.type = fType;
    }

    @Override
    public BusinessObjectType getFieldType() {
        return this.type;
    }

    @Override
    public void setValue(Object o) {
        this.unitContainer = (MeasureUnitContainer)o;
        this.qtyPerContainerSpinner.setValue(this.unitContainer.getQuantityPerContainer());
        this.updateFields();
    }

    @Override
    public JComponent getPrimaryComponent() {
        return this.editingPanel;
    }

    @Override
    public void setEnabled(boolean value) {
        super.setEnabled(value);
        this.containerCombo.setEnabled(value);
        this.unitCombo.setEnabled(value);
        this.qtyPerContainerSpinner.setEnabled(value);
    }

    private void updateFields() {
        this.changing = true;
        this.unitModel.removeAllElements();
        this.containerModel.removeAllElements();
        for (MeasureUnit unit : MeasureUnitHelper.getOrderedRegisteredMeasureUnits()) {
            this.unitModel.addElement(unit);
        }
        for (MeasureContainer container : MeasureUnitHelper.getOrderedContainers()) {
            this.containerModel.addElement(container);
        }
        this.unitCombo.setModel(this.unitModel);
        this.containerCombo.setModel(this.containerModel);
        this.unitCombo.setSelectedItem(this.unitContainer.getMeasureUnit());
        this.containerCombo.setSelectedItem(this.unitContainer.getMeasureContainer());
        this.changing = false;
    }

    public void setMeasureUnit(MeasureUnit dispUnit) {
        this.unitCombo.setSelectedItem(dispUnit);
    }

    public MeasureUnit getMeasureUnit() {
        return (MeasureUnit)this.unitCombo.getSelectedItem();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (!(this.changing || e.getSource() != this.unitCombo && e.getSource() != this.containerCombo)) {
            this.changing = true;
            this.measureUnitSelected.emit((Object)this.getMeasureUnit());
            this.changing = false;
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (!this.changing && e.getSource() == this.qtyPerContainerSpinner) {
            this.changing = true;
            this.measureUnitSelected.emit((Object)this.getMeasureUnit());
            this.changing = false;
        }
    }
}

