/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.stock.items;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import java.util.List;
import ordermate.database.stock.StockItem;
import ordermate.database.stock.StockOnHand;
import ordermate.database.stock.StockTakeEntry;
import ordermate.database.stock.usage.PersistentStockUsage;

class StockItemUsageChecker {
    StockItemUsageChecker() {
    }

    public static boolean isStockItemUsed(StockItem stockItem) {
        if (!stockItem.isPersistent()) {
            return false;
        }
        return StockItemUsageChecker.stockItemInStockTake(stockItem) || StockItemUsageChecker.stockItemHasStockUsage(stockItem) || StockItemUsageChecker.stockItemAssignedStockOnHand(stockItem);
    }

    private static boolean stockItemInStockTake(StockItem stockItem) {
        ObjectQuery stockTakeQuery = Query.select(StockTakeEntry.class).equals(StockTakeEntry.Properties.STOCK_ITEM, (Object)stockItem).not().equals(StockTakeEntry.Properties.RAW_EXPECTED_QTY, 0.0).group().not().equals(StockTakeEntry.Properties.RAW_ACTUAL_QTY, 0.0).or().isNull(StockTakeEntry.Properties.RAW_ACTUAL_QTY).endGroup().limit(1);
        List results = PersistenceManager.getObjectList(StockTakeEntry.class, (String)stockTakeQuery.toString());
        return !results.isEmpty();
    }

    private static boolean stockItemHasStockUsage(StockItem stockItem) {
        ObjectQuery stockUsageQuery = Query.select(PersistentStockUsage.class).equals(PersistentStockUsage.Properties.STOCK_ITEM, (Object)stockItem).limit(1);
        List results = PersistenceManager.getObjectList(PersistentStockUsage.class, (String)stockUsageQuery.toString());
        return !results.isEmpty();
    }

    private static boolean stockItemAssignedStockOnHand(StockItem stockItem) {
        ObjectQuery stockUsageQuery = Query.select(StockOnHand.class).equals(StockOnHand.Properties.STOCK_ITEM, (Object)stockItem).greaterThan(StockOnHand.Properties.QUANTITY, 0.0).limit(1);
        List results = PersistenceManager.getObjectList(StockOnHand.class, (String)stockUsageQuery.toString());
        return !results.isEmpty();
    }
}

