/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.stock.items.replace;

import au.com.ordermate.guicore.task.AbstractTask;
import au.com.ordermate.guicore.task.Task;
import java.awt.Frame;
import java.util.ArrayList;
import java.util.List;
import officemate.OfficeMate;
import officemate.adminkit.dialogs.Dialogs;
import officemate.screens.setup.stock.items.replace.StockItemReplacementPanel;
import officemate.screens.setup.stock.items.replace.StockItemReplacer;
import ordermate.OrderMate;
import ordermate.database.EventContext;
import ordermate.database.misc.StockControlEventLog;
import ordermate.database.stock.StockItem;
import ordermate.gui.dialogs.ProgressDialog;

public class StockItemReplacementManager {
    private static final String HEADER_HTML = "This screen allows you to replace an existing Stock Item with another or a new Stock Item.";

    void replaceAllStockItems(List<StockItemReplacer> replaceList) {
        final ArrayList<StockItemReplacer> replacementList = new ArrayList<StockItemReplacer>(replaceList);
        ProgressDialog progressDialog = new ProgressDialog((Frame)OfficeMate.getApplicationFrame(), true, (Task)new AbstractTask(){

            public String getName() {
                return "Replacing Stock Items ..";
            }

            protected void performTask() throws Exception {
                for (StockItemReplacer replacer : replacementList) {
                    if (replacer.isShouldDoReplace()) {
                        try {
                            String origDesc = replacer.getDisplayLabel();
                            replacer.doReplace();
                            StockControlEventLog.logStockItemReplaced((EventContext)OfficeMate.getInstance().getEventContext(), (String)origDesc, (StockItem)replacer.getExistingStockItem(), (StockItem)replacer.getReplacementStockItem());
                        }
                        catch (Exception ex) {
                            OrderMate.LOG.error("Problem replacing Stock Item: " + replacer.getExistingStockItem() + " with replacement StockItem: " + replacer.getReplacementStockItem(), (Throwable)ex);
                        }
                    } else {
                        OrderMate.LOG.error("Replacing Stock Item: " + replacer.getExistingStockItem() + " with replacement StockItem: " + replacer.getReplacementStockItem() + " failed. Make sure there is no cyclic dependency!");
                    }
                    this.emitProgress();
                }
            }

            protected int getTotalSubTasks() {
                return replacementList.size();
            }
        });
        if (progressDialog.start()) {
            Dialogs.showInfoDialog("Replace Stock Item", "Stock Item(s) were successfully replaced.");
        } else {
            Dialogs.showErrorDialog("Replace Stock Item", "There was an error while replacing Stock Item(s).");
        }
    }

    public static boolean doShowReplaceDialog(StockItem stockItem) {
        StockItemReplacementManager manager = new StockItemReplacementManager();
        StockItemReplacementPanel replacementPanel = new StockItemReplacementPanel(stockItem);
        if (replacementPanel.getReplaceList().isEmpty()) {
            Dialogs.showInfoDialog("Stock Item has no usages", "The Stock Item " + stockItem.getLabel() + " is not currently used.");
        } else if (Dialogs.getOkCancelDialogBuilder(replacementPanel).setTitle("Replace Stock Item").setHtmlHeader(HEADER_HTML).setHandler(replacementPanel).doShow()) {
            manager.replaceAllStockItems(replacementPanel.getReplaceList());
            return true;
        }
        return false;
    }
}

