/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.stock.items.replace;

import java.util.List;
import javax.swing.table.AbstractTableModel;
import officemate.screens.setup.stock.items.replace.StockItemReplacer;
import ordermate.database.config.Quantity;
import ordermate.database.stock.StockItem;

class StockItemReplacementTableModel
extends AbstractTableModel {
    public final String[] COL_NAMES = new String[]{"Selected", "Type", "Menu Item", "Existing Ingredient", "New Ingredient"};
    public static final int COL_SELECTED = 0;
    public static final int COL_TYPE = 1;
    public static final int COL_ITEM = 2;
    public static final int COL_EXISTING_ITEM = 3;
    public static final int COL_REPLACEMENT_ITEM = 4;
    private List<StockItemReplacer> stockItemList;

    public StockItemReplacementTableModel(List<StockItemReplacer> replaceList) {
        this.stockItemList = replaceList;
    }

    @Override
    public int getRowCount() {
        return this.stockItemList == null ? 0 : this.stockItemList.size();
    }

    @Override
    public int getColumnCount() {
        return this.COL_NAMES.length;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (rowIndex >= this.getRowCount()) {
            throw new IndexOutOfBoundsException("Row index greater than number of rows");
        }
        StockItemReplacer stockItemRepEntry = this.stockItemList.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                return stockItemRepEntry.isShouldDoReplace();
            }
            case 1: {
                return stockItemRepEntry.getType();
            }
            case 2: {
                return stockItemRepEntry.getDisplayLabel();
            }
            case 3: {
                return this.getStockItemDisplayText(stockItemRepEntry.getExistingStockItem(), stockItemRepEntry.getItem().getQuantity().getRawValue());
            }
            case 4: {
                return this.getStockItemDisplayText(stockItemRepEntry.getReplacementStockItem(), stockItemRepEntry.getNewQty());
            }
        }
        throw new IndexOutOfBoundsException("Column index out of bounds");
    }

    public StockItemReplacer getStockItemReplacerAt(int rowIndex) {
        return this.stockItemList.get(rowIndex);
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (rowIndex >= this.getRowCount()) {
            throw new IndexOutOfBoundsException("Row index greater than number of rows");
        }
        StockItemReplacer stockItemRepEntry = this.stockItemList.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                if (!(aValue instanceof Boolean)) break;
                stockItemRepEntry.setShouldDoReplace((Boolean)aValue);
                break;
            }
            default: {
                super.setValueAt(aValue, rowIndex, columnIndex);
            }
        }
    }

    private String getStockItemDisplayText(StockItem stockItem, double qty) {
        if (stockItem != null) {
            Quantity newQty = new Quantity(stockItem.getIngredientMeasureUnit(), qty);
            return newQty + " " + stockItem.getLabel();
        }
        return "";
    }

    @Override
    public boolean isCellEditable(int rowIndex, int colIndex) {
        return colIndex == 0 || colIndex == 4;
    }

    @Override
    public String getColumnName(int colIndex) {
        if (colIndex < 0 && colIndex >= this.getColumnCount()) {
            throw new IllegalArgumentException("colIndex out of bounds");
        }
        return this.COL_NAMES[colIndex];
    }

    @Override
    public Class<?> getColumnClass(int aColumn) {
        switch (aColumn) {
            case 0: {
                return Boolean.class;
            }
            case 1: {
                return String.class;
            }
        }
        return super.getColumnClass(aColumn);
    }
}

