/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.stock.liquorfile;

import au.com.ordermate.guicore.task.AbstractTask;
import au.com.ordermate.persistence.Executable;
import au.com.ordermate.persistence.PersistenceManager;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import officemate.adminkit.dialogs.Dialogs;
import officemate.components.AbstractObjectEditor;
import ordermate.database.integration.LiquorfileConfiguration;
import ordermate.gui.FieldPanelBuilder;
import ordermate.integration.liquorfile.LiquorFileExecutable;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.swingx.JXDatePicker;

class LiquorfileConfigurationEditor
extends AbstractObjectEditor<LiquorfileConfiguration>
implements ActionListener {
    private JButton validateExportBut;
    private JButton ImportBut;
    public Signal testExport = Signals.createSignal();

    @Override
    protected void init() {
        super.init();
        this.getBindings().setStrategy(AutoBinding.UpdateStrategy.READ_WRITE);
        FieldPanelBuilder builder = new FieldPanelBuilder();
        builder.addSeparator("General Parameters");
        builder.addRow("LMGM ID", (Component)this.setupPositiveIntegerField(LiquorfileConfiguration.Properties.LIQUORFILE_ID, 5, true, false));
        builder.addRow("LMGM Venue Name", (Component)this.setupTextField(LiquorfileConfiguration.Properties.LIQUORFILE_CUSTOMER_NAME, 20));
        builder.addSeparator("Pricebook Parameters");
        builder.addRow("Import Directory", (Component)this.setupTextField(LiquorfileConfiguration.Properties.PRICEBOOK_IMPORT_DIR, 20));
        builder.addRow("Update time", (Component)this.setupSQLTimeSpinner(LiquorfileConfiguration.Properties.PRICEBOOK_UPDATE_TIME, "HH:mm"));
        builder.addRow("Component Extension", (Component)this.setupTextField(LiquorfileConfiguration.Properties.PRICEBOOK_COMPONENT_EXTENSION, 20));
        this.ImportBut = new JButton("Import...");
        builder.addRow("", (Component)this.ImportBut);
        this.ImportBut.addActionListener(this);
        builder.addSeparator("Scandata Parameters");
        JXDatePicker picker = this.setupDatePicker(LiquorfileConfiguration.Properties.SCANDATA_START_DATE);
        picker.setFormats(new String[]{"dd/MM/yyyy"});
        builder.addRow("Start Date", (Component)picker);
        builder.addRow("Export Directory", (Component)this.setupTextField(LiquorfileConfiguration.Properties.SCANDATA_EXPORT_DIR, 20));
        this.validateExportBut = new JButton("Validate Export...");
        builder.addRow("", (Component)this.validateExportBut);
        this.validateExportBut.addActionListener(this);
        this.setLayout(new FlowLayout(0));
        this.add(builder.getPanel());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.validateExportBut) {
            this.testExport.emit();
        } else if (e.getSource() == this.ImportBut) {
            Dialogs.showProgressDialog(new PriceBookImportTask());
        }
    }

    private class PriceBookImportTask
    extends AbstractTask {
        private PriceBookImportTask() {
        }

        public String getName() {
            return "PriceBook Import";
        }

        protected void performTask() throws Exception {
            boolean successful = (Boolean)PersistenceManager.getServerConnection().runSync((Executable)new LiquorFileExecutable());
            if (successful) {
                Dialogs.showMessageDialog("Import", "PriceBook Import was successful!");
            } else {
                Dialogs.showErrorDialog("File Not Found", "Unable to load a PriceBook CSV file... See logs for details");
            }
        }

        protected int getTotalSubTasks() {
            return 1;
        }
    }
}

