/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.stock.liquorfile;

import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import ca.odell.glazedlists.EventList;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JPanel;
import officemate.adminkit.ObjectEditorPanel;
import officemate.adminkit.dialogs.Dialogs;
import officemate.adminkit.state.BasicOfficeMateState;
import officemate.components.table.PersistentObjectTable;
import officemate.screens.setup.stock.liquorfile.PriceBookImportColumnTableFormat;
import ordermate.database.inventory.InventoryGroup;
import ordermate.database.stock.ScanDataLinkSummary;
import ordermate.database.stock.StockGroup;

class PriceBookImportPanel
extends JPanel
implements ActionListener {
    ObjectEditorPanel stockItemEditorPanel;
    private JButton setMenuSection;
    private JButton setStockGroup;
    private EventList<ScanDataLinkSummary> dataList;
    private PersistentObjectTable<ScanDataLinkSummary> table;

    PriceBookImportPanel(EventList<ScanDataLinkSummary> toShow, BasicOfficeMateState state) {
        super(new BorderLayout());
        this.dataList = toShow;
        this.setupTopPanel();
        this.setupTable(state);
    }

    private void setupTopPanel() {
        JPanel topPanel = new JPanel();
        this.setMenuSection = new JButton("Set Menu Section");
        this.setStockGroup = new JButton("Set Stock Group");
        this.setMenuSection.addActionListener(this);
        this.setStockGroup.addActionListener(this);
        topPanel.add(this.setMenuSection);
        topPanel.add(this.setStockGroup);
        this.add((Component)topPanel, "North");
    }

    private void setupTable(BasicOfficeMateState state) {
        this.table = new PersistentObjectTable<ScanDataLinkSummary>(this.dataList, new PriceBookImportColumnTableFormat(state));
        this.add(this.table);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.setMenuSection == e.getSource()) {
            this.bulkSetMenuSection();
        } else if (this.setStockGroup == e.getSource()) {
            this.bulkSetStockGroup();
        }
    }

    private void bulkSetMenuSection() {
        InventoryGroup option;
        List<ScanDataLinkSummary> summaries = this.getSelectedSummaries();
        if (summaries != null && (option = (InventoryGroup)Dialogs.showOptionDialog("Menu Section", "Please select a menu section", PersistenceManager.getObjectList(InventoryGroup.class, (String)Query.select(InventoryGroup.class).active(InventoryGroup.class).toString()))) != null) {
            for (ScanDataLinkSummary summary : summaries) {
                summary.getInventoryItem().setMenuGroup(option);
            }
        }
        this.table.repaint();
    }

    private void bulkSetStockGroup() {
        StockGroup option;
        List<ScanDataLinkSummary> summaries = this.getSelectedSummaries();
        if (summaries != null && (option = (StockGroup)Dialogs.showOptionDialog("Stock Group", "Please select a stock group", PersistenceManager.getObjectList(StockGroup.class, (String)Query.select(StockGroup.class).active(StockGroup.class).toString()))) != null) {
            for (ScanDataLinkSummary summary : summaries) {
                summary.getStockItem().setStockGroup(option);
            }
        }
        this.table.repaint();
    }

    private List<ScanDataLinkSummary> getSelectedSummaries() {
        List<ScanDataLinkSummary> selections = this.table.getAllSelectedObjects();
        if (selections == null || selections.isEmpty()) {
            Dialogs.showWarningDialog("Nothing Selected", "Please select one or more items");
            selections = null;
        }
        return selections;
    }
}

