/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.stock.liquorfile;

import au.com.ordermate.gui.actions.BasicAction;
import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.search.ObjectQuerySearcher;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.search.ISingleValueSearchFilter;
import au.com.ordermate.search.control.RefreshAction;
import au.com.ordermate.search.pager.Pager;
import au.com.ordermate.search.pager.PagerModel;
import au.com.ordermate.search.searchfield.java.ComboSearchField;
import au.com.ordermate.search.searchfield.java.SearchGuiField;
import au.com.ordermate.search.searchfield.java.StringSearchField;
import au.com.ordermate.util.image.IconLoader;
import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.Action;
import javax.swing.JCheckBox;
import javax.swing.table.TableCellRenderer;
import officemate.adminkit.dialogs.Dialogs;
import officemate.adminkit.dialogs.OkCancelDialogBuilder;
import officemate.adminkit.state.SearchGuiState;
import officemate.components.OfficeMateObjectSearch;
import officemate.components.search.ObjectPropertySearch;
import officemate.components.table.AbstractTableState;
import officemate.components.table.PersistentObjectTable;
import officemate.components.table.ResolvingColumnFormat;
import officemate.components.table.SelectionColumnFormat;
import officemate.components.table.TableStateCentralArea;
import officemate.components.tableformat.ColumnTableFormat;
import officemate.components.tableformat.renderers.BooleanAliasCellRenderer;
import officemate.screens.setup.stock.liquorfile.PriceBookImportPanel;
import officemate.screens.setup.stock.liquorfile.PriceBookProductIsActive;
import ordermate.OrderMate;
import ordermate.database.hardware.PrinterGroup;
import ordermate.database.inventory.PriceLevel;
import ordermate.database.queries.inventory.InventoryGroupQueries;
import ordermate.database.searchers.stock.liquorfile.PriceBookProductSearcher;
import ordermate.database.stock.ScanDataLinkSummary;
import ordermate.database.stock.StockGroup;
import ordermate.database.stock.StockSupplier;
import ordermate.database.stock.liquorfile.PriceBookCategory;
import ordermate.database.stock.liquorfile.PriceBookDepartment;
import ordermate.database.stock.liquorfile.PriceBookGroup;
import ordermate.database.stock.liquorfile.PriceBookProduct;
import ordermate.database.stock.liquorfile.dataimporter.PriceBookDataImporter;
import ordermate.database.users.AllPermissions;
import ordermate.gui.FieldPanelBuilder;
import ordermate.reports.table.ColumnFormat;
import ordermate.reports.table.PropertyColumnFormat;

public class PriceBookState
extends AbstractTableState<PriceBookProduct>
implements SearchGuiState<PriceBookProduct> {
    private Action activateAction;
    private final PagerModel listPager = new PagerModel(1000);
    private PriceBookProductSearcher searcher;
    private EventList<PriceBookGroup> groupList;
    private EventList<PriceBookDepartment> deptList;
    private EventList<PriceBookCategory> catList;
    private JCheckBox checkStockItems;
    private PriceBookImportPanel importPanel;
    private PriceBookProductIsActive activeColumn;
    private SelectionColumnFormat<PriceBookProduct> selections;

    public PriceBookState() {
        super("PriceBook", AllPermissions.PRICEBOOK_LINKING, "Imports Items based on Liquorfile managed items");
        this.addAction((Action)new BasicAction("Check Selected", IconLoader.get((String)"/ordermate/images/linkMany.png")){

            public void actionPerformed(ActionEvent e) {
                PriceBookState.this.checkAllSelected();
            }
        });
        this.addAction((Action)new BasicAction("Check All Shown", IconLoader.get((String)"/officemate/images/selectAll.png")){

            public void actionPerformed(ActionEvent e) {
                PriceBookState.this.checkAllShown();
            }
        });
        this.addAction((Action)new BasicAction("Uncheck All", IconLoader.get((String)"/officemate/images/selectNone.png")){

            public void actionPerformed(ActionEvent e) {
                PriceBookState.this.uncheckAll();
            }
        });
        this.addAction((Action)new BasicAction("Import", IconLoader.get((String)"/ordermate/images/button_import.png")){

            public void actionPerformed(ActionEvent e) {
                PriceBookState.this.performActivate();
            }
        });
        this.searcher = new PriceBookProductSearcher(PriceBookProduct.class);
    }

    @Override
    public void init() {
        if (this.initCalled) {
            return;
        }
        super.init();
        this.addPageControl(this.listPager);
    }

    private void performActivate() {
        PriceBookDataImporter importer = new PriceBookDataImporter();
        importer.setCheckDatabase(this.checkStockItems.isSelected());
        ArrayList<PriceBookProduct> selectedToImport = new ArrayList<PriceBookProduct>(this.selections.getSelections());
        if (!selectedToImport.isEmpty()) {
            if (PrinterGroup.getPrinterGroups() == null || PrinterGroup.getPrinterGroups().isEmpty()) {
                String errorMsg = "Unable To perform Import of PriceBook data into OfficeMate - there is no PrinterGroup to assign InventoryItems to.";
                this.fireError(errorMsg);
                return;
            }
            if (InventoryGroupQueries.getAnyInventoryGroup() == null) {
                String errorMsg = "Unable To perform Import of PriceBook data into OfficeMate - No InventoryGroup to build InventoryItems on.";
                this.fireError(errorMsg);
                return;
            }
            if (StockGroup.getDefaultStockGroup() == null) {
                String errorMsg = "Unable To perform Import of PriceBook data into OfficeMate - No StockGroup to build StockItems on.";
                this.fireError(errorMsg);
                return;
            }
            if (PriceLevel.getDefaultPriceLevel() == null) {
                String errorMsg = "Unable To perform Import of PriceBook data into OfficeMate - No PriceLevel to build InventoryItemUnits on.";
                this.fireError(errorMsg);
                return;
            }
            if (StockSupplier.getDefaultSupplier() == null) {
                String errorMsg = "Unable To perform Import of PriceBook data into OfficeMate - No StockSupplier to build StockItems on.";
                Dialogs.showErrorDialog("Import Aborted", errorMsg);
                OrderMate.LOG.error(errorMsg);
                return;
            }
            try {
                importer.createSummaries(selectedToImport);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ArrayList compiledDataToConfirm = new ArrayList(importer.getAllSummaries());
            this.importPanel = new PriceBookImportPanel((EventList<ScanDataLinkSummary>)GlazedLists.eventList(compiledDataToConfirm), this);
            OkCancelDialogBuilder dialog = Dialogs.getOkCancelDialogBuilder(this.importPanel);
            dialog.setTitle("Confirm PriceBook Data to Import");
            dialog.setHtmlHeader("You can edit the Menu Item and Stock Item from this screen before they are imported.");
            if (dialog.doShow()) {
                for (ScanDataLinkSummary summary : compiledDataToConfirm) {
                    summary.doSave();
                }
            }
        }
        this.activeColumn.refreshColumnData();
        this.refresh();
    }

    private void fireError(String toFireAndLog) {
        Dialogs.showErrorDialog("Import Aborted", toFireAndLog);
        OrderMate.LOG.error(toFireAndLog);
    }

    public PriceBookProductSearcher getSearcher() {
        return this.searcher;
    }

    @Override
    protected Class<PriceBookProduct> getDisplayingType() {
        return PriceBookProduct.class;
    }

    protected PagerModel getListPager() {
        return this.listPager;
    }

    @Override
    protected TableStateCentralArea<PriceBookProduct> createCentralArea() {
        this.activeColumn = new PriceBookProductIsActive();
        this.selections = new SelectionColumnFormat("Import?");
        this.initEventLists();
        return new PersistentObjectTable<PriceBookProduct>(this.getObjectList(), new ColumnTableFormat(new ColumnFormat[]{new PropertyColumnFormat("Description", PriceBookProduct.Properties.DESCRIPTION), new PropertyColumnFormat("Group", PriceBookProduct.Properties.PRICEBOOK_GROUP), new PropertyColumnFormat("Department", PriceBookProduct.Properties.PRICEBOOK_DEPARTMENT), new PropertyColumnFormat("Category", PriceBookProduct.Properties.PRICEBOOK_CATEGORY), new ResolvingColumnFormat("Active", String.class, this.activeColumn).setName("Item Status").setCustomRenderer((TableCellRenderer)new BooleanAliasCellRenderer("Imported", "Not Imported", "?")), this.selections}));
    }

    @Override
    protected OfficeMateObjectSearch<PriceBookProduct> createSearchPanelFactory() {
        ObjectPropertySearch<PriceBookProduct> search = new ObjectPropertySearch<PriceBookProduct>(PriceBookProduct.class, (ObjectQuerySearcher<PriceBookProduct>)this.getSearcher(), (EventList<PriceBookProduct>)new BasicEventList());
        search.usePagedObjectQueryRefreshStrategy((Pager)this.getListPager());
        RefreshAction refreshAction = new RefreshAction(search);
        this.initEventLists();
        search.addSearchField((SearchGuiField)new StringSearchField("Description", (ISingleValueSearchFilter)this.searcher.getDescriptionSearchFilter(), (Action)refreshAction));
        search.addSearchField((SearchGuiField)new ComboSearchField("Group", (ISingleValueSearchFilter)this.searcher.getGroupSearchFilter(), true, (Action)refreshAction, this.groupList));
        search.addSearchField((SearchGuiField)new ComboSearchField("Department", (ISingleValueSearchFilter)this.searcher.getDeptSearchFilter(), true, (Action)refreshAction, this.deptList));
        search.addSearchField((SearchGuiField)new ComboSearchField("Category", (ISingleValueSearchFilter)this.searcher.getCatSearchFilter(), true, (Action)refreshAction, this.catList));
        FieldPanelBuilder builder = new FieldPanelBuilder();
        this.checkStockItems = new JCheckBox();
        builder.addRow("Check Stock Items", (Component)this.checkStockItems, "Checks existing stock items for similar products to the liquorfile products");
        return search;
    }

    private void initEventLists() {
        ObjectQuery oQuery;
        if (this.groupList == null) {
            oQuery = new ObjectQuery().select(PriceBookGroup.class);
            this.groupList = GlazedLists.eventList((Collection)PersistenceManager.getObjectList(PriceBookGroup.class, (String)oQuery.toString()));
        }
        if (this.deptList == null) {
            oQuery = new ObjectQuery().select(PriceBookDepartment.class);
            this.deptList = GlazedLists.eventList((Collection)PersistenceManager.getObjectList(PriceBookDepartment.class, (String)oQuery.toString()));
        }
        if (this.catList == null) {
            oQuery = new ObjectQuery().select(PriceBookCategory.class);
            this.catList = GlazedLists.eventList((Collection)PersistenceManager.getObjectList(PriceBookCategory.class, (String)oQuery.toString()));
        }
    }

    @Override
    protected void onStart() {
        super.onStart();
        this.groupList = null;
        this.deptList = null;
        this.catList = null;
        this.initEventLists();
    }

    public void checkAllSelected() {
        this.selections.addSelections(this.getCentralArea().getAllSelectedObjects());
        this.getCentralArea().getTable().repaint();
    }

    public void checkAllShown() {
        this.selections.addSelections((Collection<PriceBookProduct>)((PersistentObjectTable)this.getCentralArea()).getList());
        this.getCentralArea().getTable().repaint();
    }

    public void uncheckAll() {
        this.selections.clearSelections();
        this.getCentralArea().getTable().repaint();
    }
}

