/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.stock.liquorfile;

import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.util.Price;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.swing.EventComboBoxModel;
import java.awt.Component;
import java.util.Collection;
import javax.swing.JComboBox;
import officemate.components.AbstractObjectEditor;
import officemate.screens.setup.stock.items.MeasureUnitContainerPanel;
import ordermate.database.config.MeasureUnit;
import ordermate.database.config.MeasureUnitHelper;
import ordermate.database.stock.StockGroup;
import ordermate.database.stock.StockItem;
import ordermate.database.stock.StockItemSupplier;
import ordermate.database.stock.StockSupplier;
import ordermate.gui.FieldPanelBuilder;
import ordermate.gui.binding.BindingHelper;
import org.jdesktop.beansbinding.AutoBinding;

class PriceBookStockItemEditor
extends AbstractObjectEditor<StockItem> {
    private final EventList<StockGroup> groups = GlazedLists.eventList((Collection)StockGroup.getAllStockGroups());
    private final EventList<StockSupplier> suppliers = GlazedLists.eventList((Collection)StockSupplier.getSuppliers());
    private final EventList<MeasureUnit> measureUnits = GlazedLists.eventList((Collection)MeasureUnitHelper.getAllRegisteredMeasureUnits());
    private BindingHelper<StockItem> bindingHelper = new BindingHelper();
    private MeasureUnitContainerPanel unitLinkPanel;
    private JComboBox supplierComboBox;
    StockItemSupplier defaultItemSupplier;
    StockSupplier oldSupplier;

    PriceBookStockItemEditor() {
        this.bindingHelper.setStrategy(AutoBinding.UpdateStrategy.READ_WRITE);
        this.setBindings(this.bindingHelper);
        FieldPanelBuilder builder = new FieldPanelBuilder();
        this.supplierComboBox = this.createStockSupplierComboBox();
        JComboBox outerContainerBox = this.setupComboBox(StockItem.Properties.OUTER_CONTAINER, GlazedLists.eventList((Collection)MeasureUnitHelper.getOrderedContainers()));
        builder.addRow("Stock Item Name", (Component)this.setupTextField(StockItem.Properties.LABEL, 20));
        builder.addRow("Stock Group", (Component)this.setupComboBox(StockItem.Properties.STOCK_GROUP, this.groups));
        builder.addRow("Stock Supplier", (Component)this.supplierComboBox);
        builder.addRow("Purchase Cost", (Component)this.setupPriceField((PropertiedObject.Property<Price>)StockItem.Properties.CURRENT_COST, 6));
        this.unitLinkPanel = new MeasureUnitContainerPanel();
        builder.addRow("Measure Unit", (Component)this.unitLinkPanel);
        builder.addRow("Purchase Quantity", (Component)this.setupNumberSpinner(StockItem.Properties.PURCHASE_QTY, 1.0, 0.0, null, null, null, 5));
        builder.addRow("Outer Name", (Component)outerContainerBox);
        builder.addRow("Outer Quantity", (Component)this.setupNumberSpinner(StockItem.Properties.OUTER_QUANTITY, 1.0, 0.0, null, null, null, 5));
        this.add(builder.getPanel());
    }

    private JComboBox createStockSupplierComboBox() {
        JComboBox itemSupplierBox = new JComboBox(new EventComboBoxModel(this.suppliers));
        itemSupplierBox.setName(StockItemSupplier.Properties.STOCK_SUPPLIER.getName());
        return itemSupplierBox;
    }

    @Override
    public void setObject(StockItem toEdit) {
        super.setObject(toEdit);
        this.unitLinkPanel.setValue(toEdit.getDisplayMeasureUnitContainer());
        this.defaultItemSupplier = (StockItemSupplier)((StockItem)this.getObject()).getStockItemSuppliers().get(0);
        if (this.defaultItemSupplier != null) {
            this.oldSupplier = this.defaultItemSupplier.getStockSupplier();
        }
        this.supplierComboBox.setSelectedItem(this.oldSupplier);
    }

    @Override
    public void refresh() {
        super.refresh();
    }

    @Override
    public void saveObject() {
        this.unitLinkPanel.getValue();
        super.saveObject();
        ((StockItem)this.getObject()).clearSuppliers();
        ((StockItem)this.getObject()).addSupplier((StockSupplier)this.supplierComboBox.getSelectedItem());
    }
}

