/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.stock.liquorfile;

import au.com.ordermate.application.GuiApp;
import au.com.ordermate.gui.actions.BasicAction;
import au.com.ordermate.guicore.Refreshable;
import au.com.ordermate.guicore.task.AbstractTask;
import au.com.ordermate.guicore.task.Task;
import au.com.ordermate.oquery.search.ObjectQuerySearcher;
import au.com.ordermate.oquery.search.filter.IRangedQuerySearchFilter;
import au.com.ordermate.search.control.RefreshAction;
import au.com.ordermate.search.searchfield.java.DateRangeSearchField;
import au.com.ordermate.search.searchfield.java.SearchGuiField;
import au.com.ordermate.util.DateTimeUtils;
import au.com.ordermate.util.image.IconLoader;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.swing.Action;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import officemate.OfficeMate;
import officemate.components.OfficeMateObjectSearch;
import officemate.components.search.ObjectPropertySearch;
import officemate.components.table.AbstractTableState;
import officemate.components.table.PersistentObjectTable;
import officemate.components.table.TableStateCentralArea;
import officemate.components.tableformat.ColumnTableFormat;
import officemate.components.tableformat.PropertyAccessorColumnFormat;
import ordermate.database.integration.LiquorfileConfiguration;
import ordermate.database.misc.TradingDay;
import ordermate.database.searchers.stock.liquorfile.ScandataTradingDayExportSearcher;
import ordermate.database.users.AllPermissions;
import ordermate.gui.FieldPanelBuilder;
import ordermate.gui.dialogs.ProgressDialog;
import ordermate.integration.liquorfile.pricebook.PricebookManager;
import ordermate.integration.liquorfile.scandata.ScandataManager;
import ordermate.integration.liquorfile.scandata.ScandataTradingDayExport;
import ordermate.reports.table.ColumnFormat;
import ordermate.reports.table.PropertyColumnFormat;

public class ScandataExportState
extends AbstractTableState {
    private static final String NO_VALUE_SET = "No value";
    private static final int MAX_FILES_TO_DISPLAY = 10;
    private JLabel lastExportLabel;
    private JLabel exportDirLabel;
    private JLabel startDateLabel;
    private BasicAction manualExportAction;
    private BasicAction exportMissingAction;
    private BasicAction regenerateExportAction;
    private ScandataTradingDayExportSearcher searcher;
    private ScandataManager scandataManager = new ScandataManager();

    public ScandataExportState() {
        super("Scandata Export", AllPermissions.SCANDATA_EXPORT, "Controls for manual export of scandata and previous reports");
        this.init();
    }

    @Override
    protected void init() {
        if (this.initCalled) {
            return;
        }
        super.init();
        this.manualExportAction = new BasicAction("Export", IconLoader.get((String)"/ordermate/images/rightarrow.png"), "Manually export the selected Scandata reports."){

            public void actionPerformed(ActionEvent e) {
                ScandataExportState.this.exportPrevious();
            }
        };
        this.exportMissingAction = new BasicAction("Export Missing", IconLoader.get((String)"/ordermate/images/exportMissing.png"), "Generate and export all Scandata reports that have not already been exported."){

            public void actionPerformed(ActionEvent e) {
                ScandataExportState.this.exportMissing();
            }
        };
        this.regenerateExportAction = new BasicAction("Regenerate", IconLoader.get((String)"/ordermate/images/export_regenerate.png"), "Regenerate and export the selected Scandata reports."){

            public void actionPerformed(ActionEvent e) {
                ScandataExportState.this.regeneratePrevious();
            }
        };
        this.addSelectionDependentAction((Action)this.manualExportAction);
        this.addAction((Action)this.exportMissingAction);
        this.addSelectionDependentAction((Action)this.regenerateExportAction);
    }

    private void exportMissing() {
        if (!this.checkCanExport()) {
            return;
        }
        if (!PricebookManager.getInstance().allLinksValid()) {
            StringBuilder SB = new StringBuilder("<html>There appear to be duplicate or invalid Liquorfile ");
            SB.append("IDs.<br><br>Please navigate to Pricebook Linking and select \"Validate\" for more information.</html>");
            JOptionPane.showMessageDialog(GuiApp.getAppComplex().getApplicationFrame().getFrame(), SB.toString(), "Cannot Export", 2);
            return;
        }
        List missingDays = null;
        try {
            missingDays = this.scandataManager.determineMissingScandata();
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(GuiApp.getAppComplex().getApplicationFrame().getFrame(), "Error determining missing days:\n" + ex.getMessage(), "Error Exporting Scandata", 2);
            OfficeMate.LOG.warn("Scandata missing days could not be determined:", (Throwable)ex);
        }
        if (missingDays != null) {
            if (missingDays.size() == 0) {
                JOptionPane.showMessageDialog(GuiApp.getAppComplex().getApplicationFrame().getFrame(), "There are no missing Trading Day Scandata reports to be exported .");
            } else {
                boolean proceed;
                boolean bl = proceed = JOptionPane.showConfirmDialog(GuiApp.getAppComplex().getApplicationFrame().getFrame(), this.createProceedQuestion(missingDays), "Proceed with export?", 0) == 0;
                if (proceed) {
                    final int size = missingDays.size();
                    final ArrayList exportedFiles = new ArrayList();
                    final ArrayList nonexportedFiles = new ArrayList();
                    final Iterator days = missingDays.iterator();
                    AbstractTask exportTask = new AbstractTask(){

                        public String getName() {
                            return "Export Missing Scandata";
                        }

                        protected int getTotalSubTasks() {
                            return size;
                        }

                        protected void performTask() throws Exception {
                            while (days.hasNext()) {
                                TradingDay nextDay = (TradingDay)days.next();
                                File nextFile = ScandataExportState.this.scandataManager.exportScandata(nextDay);
                                if (nextFile != null) {
                                    exportedFiles.add(nextFile);
                                } else {
                                    nonexportedFiles.add(nextDay.getDate());
                                }
                                this.emitProgress();
                            }
                        }
                    };
                    ProgressDialog pd = new ProgressDialog((Frame)GuiApp.getAppComplex().getApplicationFrame().getFrame(), true, (Task)exportTask);
                    if (pd.start()) {
                        JOptionPane.showMessageDialog(GuiApp.getAppComplex().getApplicationFrame().getFrame(), this.createExportInformation(exportedFiles, nonexportedFiles), "Exported Missing", 1);
                    } else {
                        JOptionPane.showMessageDialog(GuiApp.getAppComplex().getApplicationFrame().getFrame(), "There was a problem while exporting the data. Some files may not have been exported.", "Error Exporting Missing Data", 2);
                    }
                }
            }
        }
        this.refresh();
    }

    private String createProceedQuestion(List missingDays) {
        StringBuilder SB = new StringBuilder("There ");
        if (missingDays.size() == 1) {
            SB.append("is 1 Scandata report ");
        } else {
            SB.append("are ");
            SB.append(missingDays.size());
            SB.append(" Scandata reports ");
        }
        SB.append("to be exported.\nDo you wish to proceed?");
        return SB.toString();
    }

    private String createExportInformation(List exportedFiles, List notExported) {
        StringBuilder SB = new StringBuilder("<html><h3>");
        if (exportedFiles.size() == 1) {
            SB.append("1 file was exported.</h3>");
        } else {
            SB.append(exportedFiles.size());
            SB.append(" files were exported.</h3>");
        }
        SB.append("<ul>");
        int count = 0;
        Iterator it = exportedFiles.iterator();
        while (it.hasNext()) {
            ++count;
            SB.append("<li>");
            SB.append(((File)it.next()).getName());
            SB.append("</li>");
            if (count <= 10) continue;
            SB.append("<li>");
            SB.append(exportedFiles.size() - count);
            SB.append(" more...</li>");
            break;
        }
        SB.append("</ul>");
        if (notExported.size() > 0) {
            SB.append("<h3>There was an problem writing the following:</h3><ul>");
            count = 0;
            it = notExported.iterator();
            while (it.hasNext()) {
                SB.append("<li>");
                SB.append(it.next().toString());
                SB.append("</li>");
                if (++count <= 10) continue;
                SB.append("<li>");
                SB.append(notExported.size() - count);
                SB.append(" more...</li>");
            }
            SB.append("</ul>Ensure that the logged in user has permissions to write files,<br>");
            SB.append("and that the target files are not opened by another application.");
        }
        SB.append("</html>");
        return SB.toString();
    }

    private void exportPrevious() {
        if (!this.checkCanExport()) {
            return;
        }
        List list = this.getCentralArea().getAllSelectedObjects();
        if (list != null && list.size() > 0) {
            ArrayList<File> exportedFiles = new ArrayList<File>();
            ArrayList<TradingDay> notExported = new ArrayList<TradingDay>();
            ScandataManager manager = this.scandataManager;
            for (ScandataTradingDayExport nextExport : list) {
                try {
                    File nextFile = manager.exportScandata(nextExport);
                    if (nextFile != null) {
                        exportedFiles.add(nextFile);
                        continue;
                    }
                    notExported.add(nextExport.getTradingDay());
                }
                catch (IOException ex) {
                    notExported.add(nextExport.getTradingDay());
                }
                catch (IllegalArgumentException ex) {
                    notExported.add(nextExport.getTradingDay());
                }
            }
            String message = this.createExportInformation(exportedFiles, notExported);
            int messageType = 1;
            if (notExported.size() > 0) {
                messageType = 2;
            }
            JOptionPane.showMessageDialog(GuiApp.getAppComplex().getApplicationFrame().getFrame(), message, "Export Results", messageType);
        } else {
            JOptionPane.showMessageDialog(GuiApp.getAppComplex().getApplicationFrame().getFrame(), "Please select a Scandata report to export first.", "Select a Report", 2);
        }
        this.refresh();
    }

    private void regeneratePrevious() {
        if (!this.checkCanExport()) {
            return;
        }
        final List list = this.getCentralArea().getAllSelectedObjects();
        if (!this.checkUserConfirmsRegenerate(list)) {
            return;
        }
        final ArrayList exportedFiles = new ArrayList();
        final ArrayList notExported = new ArrayList();
        AbstractTask exportTask = new AbstractTask(){

            public String getName() {
                return "Regenerating Scandata Exports";
            }

            protected int getTotalSubTasks() {
                return list.size();
            }

            protected void performTask() throws Exception {
                Iterator it = list.iterator();
                ScandataManager manager = ScandataExportState.this.scandataManager;
                while (it.hasNext()) {
                    ScandataTradingDayExport nextExport = (ScandataTradingDayExport)it.next();
                    try {
                        File nextFile = manager.regenerateScandata(nextExport);
                        if (nextFile != null) {
                            exportedFiles.add(nextFile);
                        } else {
                            notExported.add(nextExport.getTradingDay());
                        }
                    }
                    catch (Exception ex) {
                        notExported.add(nextExport.getTradingDay());
                    }
                    this.emitProgress();
                }
            }
        };
        ProgressDialog pd = new ProgressDialog((Frame)GuiApp.getAppComplex().getApplicationFrame().getFrame(), true, (Task)exportTask);
        if (pd.start()) {
            String message = this.createExportInformation(exportedFiles, notExported);
            int messageType = 1;
            if (notExported.size() > 0) {
                messageType = 2;
            }
            JOptionPane.showMessageDialog(GuiApp.getAppComplex().getApplicationFrame().getFrame(), message, "Export Results", messageType);
        } else {
            JOptionPane.showMessageDialog(GuiApp.getAppComplex().getApplicationFrame().getFrame(), "There was a problem while exporting the data. Some files may not have been exported.", "Error Regenerating Export Data", 2);
        }
        this.refresh();
    }

    private boolean checkUserConfirmsRegenerate(List listToRegenerate) {
        if (listToRegenerate == null || listToRegenerate.size() == 0) {
            JOptionPane.showMessageDialog(GuiApp.getAppComplex().getApplicationFrame().getFrame(), "Please select a Scandata report to export first.", "Select a Report", 2);
            return false;
        }
        StringBuilder SB = new StringBuilder("<html><h3>Regenerate ");
        if (listToRegenerate.size() != 1) {
            SB.append(listToRegenerate.size());
            SB.append(" Exports");
        } else {
            SB.append("an Export");
        }
        SB.append("</h3>Regenerating and export will remove the current export and its data,");
        SB.append("<br>and replace it with one generated from the current system state.<br>");
        SB.append("Time sensitive columns such as quantity in stock may not report correctly.<br><br>");
        SB.append("<b>Do you wish to proceed?</b></html>");
        return JOptionPane.showConfirmDialog(GuiApp.getAppComplex().getApplicationFrame().getFrame(), SB.toString(), "Confirm Regenerate", 0, 2) == 0;
    }

    @Override
    public void refresh() {
        LiquorfileConfiguration config = LiquorfileConfiguration.getInstance();
        this.exportDirLabel.setText(this.makeNice(config.getScandataExportDir()));
        this.startDateLabel.setText(this.makeNice(config.getScandataStartDate()));
        this.lastExportLabel.setText(this.makeNice(config.getScandataLastExport()));
        super.refresh();
    }

    private String makeNice(Object toMakeNice) {
        if (toMakeNice == null || toMakeNice.toString().trim().length() == 0) {
            return NO_VALUE_SET;
        }
        return toMakeNice.toString();
    }

    protected TableStateCentralArea createCentralArea() {
        ColumnTableFormat columnFormat = new ColumnTableFormat((ColumnFormat[])new PropertyColumnFormat[]{new PropertyAccessorColumnFormat("Trading Day", ScandataTradingDayExport.Properties.TRADING_DAY, TradingDay.Properties.DATE), new PropertyColumnFormat("Was Exported?", ScandataTradingDayExport.Properties.EXPORTED), new PropertyColumnFormat("Filename", ScandataTradingDayExport.Properties.FILENAME)});
        PersistentObjectTable table = new PersistentObjectTable(this.getObjectList(), columnFormat);
        return table;
    }

    protected OfficeMateObjectSearch createSearchPanelFactory() {
        return new ObjectPropertySearch(ScandataTradingDayExport.class){
            private DateRangeSearchField dateRange;
            private RefreshAction refresh;
            private ScandataTradingDayExportSearcher searcher;
            {
                this.refresh = new RefreshAction((Refreshable)this);
            }

            @Override
            public void resetSearch() {
                this.dateRange.getDateRangePanel().setDates(DateTimeUtils.getThreeMonthsAgoCal().getTime(), Calendar.getInstance().getTime());
            }

            @Override
            public JPanel createSearchPanel() {
                FieldPanelBuilder builder = new FieldPanelBuilder();
                this.searcher = (ScandataTradingDayExportSearcher)super.getPropertySearcher();
                builder.addSeparator("Export Information");
                builder.addRow("Start Date: ", (Component)(ScandataExportState.this.startDateLabel = new JLabel()));
                builder.addRow("Last Export: ", (Component)(ScandataExportState.this.lastExportLabel = new JLabel()));
                builder.addRow("Export Directory: ", (Component)(ScandataExportState.this.exportDirLabel = new JLabel()));
                builder.addSeparator("Filter");
                this.dateRange = new DateRangeSearchField("Range", (IRangedQuerySearchFilter)this.searcher.getDateFilter(), DateTimeUtils.getThreeMonthsAgoCal().getTime(), (Action)this.refresh);
                this.dateRange.addAction((Action)new RefreshAction((Refreshable)ScandataExportState.this.getSearchFactory()));
                this.dateRange.getDateRangePanel().setName("dateRange");
                builder.addRow("Date Range", (Component)this.dateRange.getDateRangePanel());
                this.addSearchField((SearchGuiField)this.dateRange);
                return builder.getPanel();
            }

            public ObjectQuerySearcher<ScandataTradingDayExport> constructPropertySearcher() {
                return new ScandataTradingDayExportSearcher();
            }
        };
    }

    private boolean checkCanExport() {
        boolean fine = false;
        LiquorfileConfiguration config = LiquorfileConfiguration.getInstance();
        String dir = config.getScandataExportDir();
        Integer ID = config.getLiquorfileId();
        String name = config.getLiquorfileCustomerName();
        Date start = config.getScandataStartDate();
        boolean bl = fine = dir != null && dir.trim().length() > 0 && ID != null && ID > 0 && name != null && name.trim().length() > 0 && start != null;
        if (!fine) {
            StringBuilder SB = new StringBuilder("<html><h3>A Scandata Export cannot be performed</h3>");
            SB.append("Exporting cannot occur because <ul>");
            if (dir == null || dir.trim().length() == 0) {
                SB.append("<li>No export directory has been set.</li>");
            }
            if (start == null) {
                SB.append("<li>No start date has been set.</li>");
            }
            if (name == null || name.trim().length() == 0) {
                SB.append("<li>No Liquorfile name has been set.</li>");
            }
            if (ID == null || ID <= 0) {
                SB.append("<li>No Liquorfile ID has been set.</li>");
            }
            SB.append("</ul>Contact Ordermate for further help.</html>");
            JOptionPane.showMessageDialog(GuiApp.getAppComplex().getApplicationFrame().getFrame(), SB.toString(), "Cannot Export", 2);
        }
        return fine;
    }

    protected Class getDisplayingType() {
        return ScandataTradingDayExport.class;
    }
}

