/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.stock.liquorfile;

import au.com.ordermate.guicore.Refreshable;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.oquery.search.ObjectQuerySearcher;
import au.com.ordermate.oquery.search.filter.IRangedQuerySearchFilter;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.search.ISingleValueSearchFilter;
import au.com.ordermate.search.control.RefreshAction;
import au.com.ordermate.search.searchfield.java.ComboSearchField;
import au.com.ordermate.search.searchfield.java.SearchGuiField;
import au.com.ordermate.search.searchfield.java.StringSearchField;
import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import javax.swing.Action;
import officemate.adminkit.OfficeMateAdminGuiUtils;
import officemate.components.search.ObjectPropertySearch;
import officemate.components.search.searchfield.IntegerRangeSearchField;
import ordermate.database.inventory.InventoryProfile;
import ordermate.database.searchers.stock.StockInventoryUsageLinkSearcher;
import ordermate.database.stock.StockArea;
import ordermate.database.stock.StockGroup;
import ordermate.database.stock.usagelink.StockInventoryUsageLink;

public class StockInventoryUsageLinkPropertySearch
extends ObjectPropertySearch {
    private StockInventoryUsageLinkSearcher searcher;
    private EventList allStockGroups = new BasicEventList();
    private EventList allStockAreas = new BasicEventList();
    private EventList allProfiles = new BasicEventList();
    private ComboSearchField profileCombo;

    public StockInventoryUsageLinkPropertySearch() {
        super(StockInventoryUsageLink.class);
        this.searcher = new StockInventoryUsageLinkSearcher();
        this.setupComponents();
    }

    private void setupComponents() {
        RefreshAction action = new RefreshAction((Refreshable)this);
        IntegerRangeSearchField quantityField = new IntegerRangeSearchField("Usage Quantity", (IRangedQuerySearchFilter<Integer>)this.searcher.getQuantityRangeSearch(), (Action)action);
        StringSearchField invItemUnitField = new StringSearchField("Inventory Item Unit", (ISingleValueSearchFilter)this.searcher.getInventoryItemUnitSearch(), (Action)action);
        StringSearchField stockItemField = new StringSearchField("Stock Item", (ISingleValueSearchFilter)this.searcher.getStockItemSearch(), (Action)action);
        StringSearchField liquorfileIdField = new StringSearchField("Liquorfile ID", (ISingleValueSearchFilter)this.searcher.getLiquorfileIdSearch(), (Action)action);
        ComboSearchField stockGroupCombo = new ComboSearchField("Stock Group", (ISingleValueSearchFilter)this.searcher.getStockGroupSearch(), true, (Action)action, this.allStockGroups);
        ComboSearchField areaCombo = new ComboSearchField("Stockable Area", (ISingleValueSearchFilter)this.searcher.getAreaSearch(), false, (Action)action, this.allStockAreas);
        this.profileCombo = new ComboSearchField("Profile", (ISingleValueSearchFilter)this.searcher.getProfileSearch(), false, (Action)action, this.allProfiles);
        this.searcher.getStockableAreaSearch().setSearchValue((Object)"1");
        this.searcher.setActiveSearchOn(true);
        this.addSearchField((SearchGuiField)this.profileCombo);
        this.addSearchField((SearchGuiField)stockGroupCombo);
        this.addSearchField((SearchGuiField)invItemUnitField);
        this.addSearchField((SearchGuiField)stockItemField);
        this.addSearchField(quantityField);
        this.addSearchField((SearchGuiField)liquorfileIdField);
        this.addSearchField((SearchGuiField)areaCombo);
    }

    protected ObjectQuerySearcher constructPropertySearcher() {
        return this.searcher;
    }

    @Override
    public void reaquireSearchOptions() {
        OfficeMateAdminGuiUtils.getInstance().refreshList(this.allStockGroups, StockGroup.getAllStockGroups());
        OfficeMateAdminGuiUtils.getInstance().refreshList(this.allProfiles, InventoryProfile.getAllProfiles());
        OfficeMateAdminGuiUtils.getInstance().refreshList(this.allStockAreas, PersistenceManager.getObjectList(StockArea.class, (String)Query.select(StockArea.class).equals(StockArea.Properties.SCANDATA_EXPORTED, (Object)"1").toString(), null));
        super.reaquireSearchOptions();
    }

    public InventoryProfile getSelectedProfile() {
        return (InventoryProfile)this.profileCombo.getSelectedObject();
    }
}

