/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.stock.options;

import au.com.ordermate.util.Assert;
import au.com.ordermate.util.Pair;
import javax.swing.JComboBox;
import officemate.adminkit.DefaultObjectEditorPanel;
import officemate.adminkit.ObjectManager;
import officemate.adminkit.ObjectSelectorPanel;
import officemate.adminkit.ObjectTemplate;
import officemate.adminkit.fieldpanels.FieldPanel;
import officemate.adminkit.fieldpanels.ObjectRefFieldPanel;
import officemate.adminkit.fieldpanels.QuantityFieldPanel;
import officemate.adminkit.templates.Templates;
import officemate.screens.setup.stock.options.StockItemSelectorPanel;
import ordermate.database.config.MeasureUnit;
import ordermate.database.config.MeasureUnitContainer;
import ordermate.database.config.MeasureUnitHelper;
import ordermate.database.config.Quantity;
import ordermate.database.stock.StockItem;
import stockmate.database.interfaces.stock.MeasureUnitI;

public class OptionsUsageEditorPanel
extends DefaultObjectEditorPanel {
    boolean alreadySetup = false;
    private ObjectRefFieldPanel stockItemPanel;
    JComboBox stockItemCombo;
    private QuantityFieldPanel qtyPanel;

    @Override
    public void init(ObjectManager manager, ObjectTemplate objectTemplate, Object obj) {
        Assert.isTrue((manager != null ? 1 : 0) != 0, (String)"Object manager should not be null in OptionsUsageEditor");
        super.init(manager, objectTemplate, obj);
        Assert.isEqual(Pair.class, (Object)objectTemplate.getObjectJavaClass(), (String)"Template must support Pairs");
        this.qtyPanel = (QuantityFieldPanel)this.getFieldPanel("Quantity Used");
        if (this.isNewObject()) {
            this.applyStockItemUnits();
        }
        this.alreadySetup = true;
    }

    @Override
    protected FieldPanel createFieldPanel(String fieldName) {
        FieldPanel panel;
        if (fieldName.equals("Stock Used")) {
            this.stockItemPanel = new ObjectRefFieldPanel(this.getTemplate().getManager());
            panel = this.stockItemPanel;
            this.stockItemCombo = new JComboBox();
            StockItemSelectorPanel selector = new StockItemSelectorPanel(this.stockItemCombo);
            ((ObjectSelectorPanel)selector).init(Templates.STOCK_ITEM, false);
            ((ObjectRefFieldPanel)panel).setObjectSelector(selector);
            panel.setFieldType(this.getTemplate().getFieldType(fieldName));
            selector.objectSelected.connect((Object)this, "gotStockItemSelected");
            ObjectTemplate objTemplate = this.getTemplate();
            String instructionsText = objTemplate.getInstructions(fieldName);
            this.getFieldLabel(fieldName).setToolTipText(instructionsText);
            this.getFieldLabel(fieldName).setLabelFor(this.stockItemCombo);
            panel.setToolTipText(instructionsText);
            panel.getPrimaryComponent().setToolTipText(instructionsText);
        } else {
            panel = super.createFieldPanel(fieldName);
        }
        return panel;
    }

    private void applyStockItemUnits() {
        MeasureUnitContainer defaultDisplayUnits;
        MeasureUnit each;
        StockItem item = (StockItem)this.stockItemPanel.getValue();
        MeasureUnit defaultIngredUnits = each = MeasureUnitHelper.getMeasureUnitForName((String)"each");
        if (item != null) {
            defaultIngredUnits = item.getIngredientMeasureUnit();
            defaultDisplayUnits = item.getDisplayMeasureUnitContainer();
        } else {
            defaultDisplayUnits = new MeasureUnitContainer(each);
        }
        double qty = defaultDisplayUnits.getMultiplier();
        if (this.qtyPanel != null) {
            this.qtyPanel.setValue(new Quantity((MeasureUnitI)defaultIngredUnits, qty, true));
        }
    }

    void gotStockItemSelected() {
        this.applyStockItemUnits();
        this.repaint();
    }
}

