/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.stock.options;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.swing.EventComboBoxModel;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Collection;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import officemate.adminkit.ObjectSelectorPanel;
import officemate.adminkit.ObjectTemplate;
import officemate.adminkit.OfficeMateAdminGuiUtils;
import ordermate.database.queries.stock.StockItemQueries;
import ordermate.database.stock.StockItem;

public class StockItemSelectorPanel
extends ObjectSelectorPanel {
    private final JComboBox stockItemCombo;
    private final EventList<StockItem> stockItems;

    public StockItemSelectorPanel(JComboBox stockItemCombo) {
        this.stockItemCombo = stockItemCombo;
        this.stockItems = new BasicEventList();
        stockItemCombo.setModel(new EventComboBoxModel(this.stockItems));
        this.init();
    }

    public StockItemSelectorPanel(JComboBox stockItemCombo, EventList<StockItem> model) {
        this.stockItemCombo = stockItemCombo;
        this.stockItems = model;
        this.init();
    }

    private void init() {
        OfficeMateAdminGuiUtils.getInstance().standardComboSetup(this.stockItemCombo);
        this.stockItemCombo.setPreferredSize(new Dimension(260, 20));
        this.setLayout(new BorderLayout());
        this.updateView();
        this.add(this.stockItemCombo);
        this.stockItemCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    StockItemSelectorPanel.this.objectSelected.emit((Object)StockItemSelectorPanel.this.getSelectedObject(), (Object)StockItemSelectorPanel.this);
                }
            }
        });
    }

    @Override
    public void init(ObjectTemplate objTemplate, boolean allowsNull) {
    }

    public StockItem getSelectedObject() {
        return (StockItem)this.stockItemCombo.getSelectedItem();
    }

    @Override
    public Class getExpectedJavaClass() {
        return StockItem.class;
    }

    @Override
    public boolean setSelectedObject(Object obj) {
        this.stockItemCombo.setSelectedItem(obj);
        return true;
    }

    @Override
    public void updateView() {
        this.stockItems.clear();
        this.stockItems.addAll((Collection)StockItemQueries.getStockItems());
    }

    @Override
    public JComponent getPrimaryComponent() {
        return (JComponent)this.stockItemCombo.getEditor().getEditorComponent();
    }
}

