/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.stock.units;

import au.com.ordermate.util.Assert;
import au.com.ordermate.util.Pair;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import officemate.adminkit.DefaultObjectEditorPanel;
import officemate.adminkit.ObjectManager;
import officemate.adminkit.ObjectSelectorPanel;
import officemate.adminkit.ObjectTemplate;
import officemate.adminkit.fieldpanels.FieldPanel;
import officemate.adminkit.fieldpanels.ObjectRefFieldPanel;
import officemate.adminkit.fieldpanels.QuantityFieldPanel;
import officemate.adminkit.templates.Templates;
import officemate.screens.setup.stock.options.StockItemSelectorPanel;
import ordermate.database.config.MeasureUnit;
import ordermate.database.config.MeasureUnitContainer;
import ordermate.database.config.MeasureUnitHelper;
import ordermate.database.config.Quantity;
import ordermate.database.stock.StockItem;
import stockmate.database.interfaces.stock.MeasureUnitI;

public class UnitsUsageEditorPanel
extends DefaultObjectEditorPanel {
    private boolean alreadySetup = false;
    private ObjectRefFieldPanel stockItemPanel;
    private JComboBox stockItemCombo;
    private QuantityFieldPanel qtyPanel;

    @Override
    public void init(ObjectManager manager, ObjectTemplate objectTemplate, Object obj) {
        super.init(manager, objectTemplate, obj);
        Assert.isEqual(Pair.class, (Object)objectTemplate.getObjectJavaClass(), (String)"Template must support Pairs");
        this.qtyPanel = (QuantityFieldPanel)this.getFieldPanel("Quantity Used");
        if (this.isNewObject()) {
            this.applyStockItemUnits();
        }
        this.alreadySetup = true;
    }

    @Override
    protected FieldPanel createFieldPanel(String fieldName) {
        if (fieldName.equals("Stock Used")) {
            return this.initializeStockItemPanel(fieldName);
        }
        return super.createFieldPanel(fieldName);
    }

    protected FieldPanel initializeStockItemPanel(String fieldName) {
        this.stockItemPanel = new ObjectRefFieldPanel(this.getObjectManager());
        this.stockItemCombo = new JComboBox();
        StockItemSelectorPanel selector = new StockItemSelectorPanel(this.stockItemCombo);
        ((ObjectSelectorPanel)selector).init(Templates.STOCK_ITEM, false);
        this.stockItemPanel.setObjectSelector(selector);
        this.stockItemPanel.setFieldType(this.getTemplate().getFieldType(fieldName));
        selector.objectSelected.connect((Object)this, "gotStockItemSelected");
        ObjectTemplate objTemplate = this.getTemplate();
        String instructionsText = objTemplate.getInstructions(fieldName);
        JLabel label = new JLabel(fieldName);
        label.setLabelFor(this.stockItemCombo);
        this.getFieldLabel(fieldName).setToolTipText(instructionsText);
        this.stockItemPanel.setToolTipText(instructionsText);
        this.stockItemPanel.getPrimaryComponent().setToolTipText(instructionsText);
        return this.stockItemPanel;
    }

    private void applyStockItemUnits() {
        MeasureUnit each;
        StockItem item = (StockItem)this.stockItemPanel.getValue();
        MeasureUnit defaultIngredUnits = each = MeasureUnitHelper.getMeasureUnitForName((String)"each");
        MeasureUnitContainer defaultDisplayUnits = new MeasureUnitContainer(each);
        if (item != null) {
            defaultIngredUnits = item.getIngredientMeasureUnit();
            defaultDisplayUnits = item.getDisplayMeasureUnitContainer();
        }
        if (this.qtyPanel != null) {
            this.qtyPanel.setValue(new Quantity((MeasureUnitI)defaultIngredUnits, defaultDisplayUnits.getMultiplier(), true));
        }
    }

    void gotStockItemSelected() {
        this.applyStockItemUnits();
        this.repaint();
    }
}

