/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.stock.units;

import java.util.ArrayList;
import java.util.List;
import javax.swing.JTable;
import officemate.adminkit.table.GroupedTable;
import officemate.adminkit.table.GroupedTableModel;
import officemate.screens.setup.stock.units.UnitsUsageTable;
import officemate.screens.setup.stock.units.UnitsUsageTableInterface;
import officemate.screens.setup.stock.units.UnitsUsageTableModel;
import ordermate.database.inventory.InventoryItemUnit;
import ordermate.signals.Signal;
import ordermate.signals.Signals;

public class UnitsUsageGroupedTable
extends GroupedTable
implements UnitsUsageTableInterface {
    public final Signal itemsAdded = Signals.createSignal();

    public UnitsUsageGroupedTable(GroupedTableModel model) {
        this(model, false);
    }

    public UnitsUsageGroupedTable(GroupedTableModel model, boolean includeStockAreaDec) {
        super(model);
        UnitsUsageTable.addPopupMenuToTable(this, includeStockAreaDec);
    }

    @Override
    public InventoryItemUnit getCurrentUnit() {
        GroupedTableModel groupedModel = this.getGroupedTableModel();
        UnitsUsageTableModel tableModel = (UnitsUsageTableModel)groupedModel.getWrappedModel();
        int selIndex = this.getSelectedRow();
        if (selIndex == -1) {
            return null;
        }
        int row = groupedModel.getOriginalRow(selIndex);
        if (row >= 0) {
            return tableModel.getItemIngredientUnitForRow(row);
        }
        return null;
    }

    @Override
    public List getCurrentlyVisibleUnits() {
        UnitsUsageTableModel tableModel = (UnitsUsageTableModel)this.getGroupedTableModel().getWrappedModel();
        int numRows = tableModel.getRowCount();
        ArrayList<InventoryItemUnit> retval = new ArrayList<InventoryItemUnit>(numRows);
        for (int i = 0; i < numRows; ++i) {
            retval.add(tableModel.getItemIngredientUnitForRow(i));
        }
        return retval;
    }

    @Override
    public JTable getJTable() {
        return this;
    }

    @Override
    public void onItemsAdded() {
        this.itemsAdded.emit();
    }
}

