/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.stock.units;

import au.com.ordermate.application.ApplicationFrame;
import au.com.ordermate.application.GuiApp;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObjectI;
import au.com.ordermate.util.Assert;
import au.com.ordermate.util.FinanceUtils;
import au.com.ordermate.util.MathsUtils;
import au.com.ordermate.util.Price;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import officemate.adminkit.table.LegacyPriceEditor;
import officemate.screens.setup.stock.ingredients.StockLinkableCostPanel;
import ordermate.database.inventory.InventoryItemUnit;
import ordermate.database.inventory.UnitPriceLevel;
import ordermate.database.misc.StockControlEventLog;
import ordermate.database.misc.SystemCurrentInfo;
import ordermate.database.misc.SystemProperty;
import ordermate.database.users.User;
import ordermate.internationalization.Internationalization;
import ordermate.signals.Signal;
import ordermate.signals.Signals;

public class UnitsUsageStockCostPanel
extends JPanel
implements StockLinkableCostPanel<InventoryItemUnit> {
    public final Signal<Price, ?, ?, ?, ?> newCustomCost = Signals.createSignal(Price.class, (String)"newCost");
    public final Signal priceChanged = Signals.createSignal();
    private static final int LAST_EVENT_NONE = 0;
    private static final int LAST_EVENT_FOCUS_GAIN = 1;
    private static final int LAST_EVENT_FOCUS_LOST = 2;
    private static final int LAST_EVENT_UPDATE = 3;
    private static final String DOLLAR_SIGN = Internationalization.getLiteralFor((String)"DOLLAR_SIGN");
    private static final String GST = Internationalization.getLiteralFor((String)"GST");
    public static final String LABEL_COST_EX_SPINNER = MessageFormat.format("{0} Ex {1}", GST, DOLLAR_SIGN);
    private static final String GST_FREE_LABEL = MessageFormat.format("{0} Free", GST);
    private JSpinner avgCostExSpinner;
    private JSpinner avgCostIncSpinner;
    private JSpinner currentCostExSpinner;
    private JSpinner currentCostIncSpinner;
    private JCheckBox manualCostCheck;
    private JCheckBox retailGstFreeCheck;
    private JTable salesPricesTable;
    private SalesPricesTableModel salesPriceModel;
    private int lastEvent = 0;
    private InventoryItemUnit currentUnit = null;
    private Price focusCustomCostInc = null;
    private InventoryItemUnit focusUnit = null;
    private boolean updatesAllowed = true;
    private static final String[] COLUMN_NAMES = new String[]{"Level", "Price", "Tax", "Cost", "G.P." + Internationalization.getLiteralFor((String)"DOLLAR_SIGN"), "G.P.%"};

    public UnitsUsageStockCostPanel() {
        this.setLayout(new BoxLayout(this, 1));
        this.manualCostCheck = new JCheckBox("Manual cost", false);
        this.retailGstFreeCheck = new JCheckBox(GST_FREE_LABEL, false);
        this.retailGstFreeCheck.setEnabled(false);
        this.avgCostExSpinner = new JSpinner(new SpinnerNumberModel(0.0, 0.0, 9999.0, 1.0));
        this.avgCostExSpinner.setName("costExSpinner");
        JSpinner.DefaultEditor spinnerEditor = (JSpinner.DefaultEditor)this.avgCostExSpinner.getEditor();
        JFormattedTextField costExTextField = spinnerEditor.getTextField();
        this.avgCostExSpinner.setEnabled(false);
        this.avgCostIncSpinner = new JSpinner(new SpinnerNumberModel(0.0, 0.0, 9999.0, 1.0));
        this.avgCostIncSpinner.setName("costIncSpinner");
        spinnerEditor = (JSpinner.DefaultEditor)this.avgCostIncSpinner.getEditor();
        JFormattedTextField costIncTextField = spinnerEditor.getTextField();
        this.avgCostIncSpinner.setEnabled(false);
        this.currentCostExSpinner = new JSpinner(new SpinnerNumberModel(0.0, 0.0, 9999.0, 1.0));
        this.currentCostExSpinner.setName("currentCostExSpinner");
        this.currentCostExSpinner.setEnabled(false);
        this.currentCostIncSpinner = new JSpinner(new SpinnerNumberModel(0.0, 0.0, 9999.0, 1.0));
        this.currentCostIncSpinner.setName("currentCostIncSpinner");
        this.currentCostIncSpinner.setEnabled(false);
        StockCostFocusListener fl = new StockCostFocusListener();
        CostChangeListener cl = new CostChangeListener();
        costExTextField.addFocusListener(fl);
        costIncTextField.addFocusListener(fl);
        this.avgCostExSpinner.addChangeListener(cl);
        this.avgCostIncSpinner.addChangeListener(cl);
        this.manualCostCheck.addFocusListener(fl);
        JPanel retailPanel = new JPanel(new BorderLayout());
        retailPanel.setName("Retail");
        retailPanel.setBorder(BorderFactory.createTitledBorder("Gross Profit"));
        this.retailGstFreeCheck.addFocusListener(fl);
        retailPanel.add((Component)this.retailGstFreeCheck, "North");
        this.salesPricesTable = new JTable();
        this.salesPricesTable.setName("salesPricesTable");
        this.updateSalesPriceModel();
        JScrollPane salesPriceScrollPane = new JScrollPane(this.salesPricesTable);
        salesPriceScrollPane.setPreferredSize(new Dimension(190, 100));
        retailPanel.add((Component)salesPriceScrollPane, "Center");
        JPanel averageCostPanel = new JPanel(new BorderLayout());
        averageCostPanel.setName("Cost");
        averageCostPanel.setBorder(BorderFactory.createTitledBorder("Average Cost"));
        JPanel costSpinnerPanel = new JPanel();
        costSpinnerPanel.setLayout(new BoxLayout(costSpinnerPanel, 0));
        JLabel costLabelEx = new JLabel(LABEL_COST_EX_SPINNER);
        JPanel costExPanel = new JPanel(new BorderLayout());
        costExPanel.setName("costExPanel");
        costLabelEx.setLabelFor(this.avgCostExSpinner);
        costExPanel.add((Component)costLabelEx, "West");
        costExPanel.add((Component)this.avgCostExSpinner, "Center");
        JLabel costLabelInc = new JLabel("Inc " + Internationalization.getLiteralFor((String)"DOLLAR_SIGN"));
        costLabelInc.setLabelFor(this.avgCostIncSpinner);
        JPanel costIncPanel = new JPanel(new BorderLayout());
        costIncPanel.setName("costIncPanel");
        costIncPanel.add((Component)costLabelInc, "West");
        costIncPanel.add((Component)this.avgCostIncSpinner, "Center");
        costSpinnerPanel.add(this.manualCostCheck);
        costSpinnerPanel.add(costExPanel);
        costSpinnerPanel.add(costIncPanel);
        averageCostPanel.add(costSpinnerPanel);
        this.add((Component)averageCostPanel, "North");
        this.add((Component)this.createCurrentCostPanel(this.currentCostExSpinner, this.currentCostIncSpinner), "Center");
        this.add((Component)retailPanel, "South");
        this.manualCostCheck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean usesManualCost = UnitsUsageStockCostPanel.this.manualCostCheck.isSelected();
                UnitsUsageStockCostPanel.this.avgCostExSpinner.setEnabled(usesManualCost);
                UnitsUsageStockCostPanel.this.avgCostIncSpinner.setEnabled(false);
                if (!usesManualCost) {
                    UnitsUsageStockCostPanel.this.avgCostExSpinner.setValue(UnitsUsageStockCostPanel.getDoubleForSpinner(UnitsUsageStockCostPanel.this.currentUnit.getIngredientCostExTax()));
                    UnitsUsageStockCostPanel.this.avgCostIncSpinner.setValue(UnitsUsageStockCostPanel.getDoubleForSpinner(UnitsUsageStockCostPanel.this.currentUnit.getIngredientCostIncTax()));
                } else {
                    UnitsUsageStockCostPanel.this.avgCostExSpinner.setValue(UnitsUsageStockCostPanel.this.avgCostIncSpinner.getValue());
                    UnitsUsageStockCostPanel.this.avgCostIncSpinner.setValue(new Double(0.0));
                }
                UnitsUsageStockCostPanel.this.avgCostExSpinner.repaint();
                UnitsUsageStockCostPanel.this.avgCostIncSpinner.repaint();
            }
        });
    }

    private JPanel createCurrentCostPanel(JSpinner costExSpinner, JSpinner costIncSpinner) {
        JLabel costLabelEx = new JLabel(LABEL_COST_EX_SPINNER);
        costLabelEx.setLabelFor(costExSpinner);
        JPanel costExPanel = new JPanel(new BorderLayout());
        costExPanel.setName("currentCostExPanel");
        costExPanel.add((Component)costLabelEx, "West");
        costExPanel.add((Component)costExSpinner, "Center");
        JLabel costLabelInc = new JLabel("Inc " + Internationalization.getLiteralFor((String)"DOLLAR_SIGN"));
        costLabelInc.setLabelFor(costIncSpinner);
        JPanel costIncPanel = new JPanel(new BorderLayout());
        costIncPanel.setName("currentCostIncPanel");
        costIncPanel.add((Component)costLabelInc, "West");
        costIncPanel.add((Component)costIncSpinner, "Center");
        JPanel spacer = new JPanel();
        spacer.setPreferredSize(this.manualCostCheck.getPreferredSize());
        JPanel costSpinnerPanel = new JPanel();
        costSpinnerPanel.setLayout(new BoxLayout(costSpinnerPanel, 0));
        costSpinnerPanel.add(spacer);
        costSpinnerPanel.add(costExPanel);
        costSpinnerPanel.add(costIncPanel);
        JPanel costPanel = new JPanel(new BorderLayout());
        costPanel.setName("CurrentCost");
        costPanel.setBorder(BorderFactory.createTitledBorder("Current Cost"));
        costPanel.add(costSpinnerPanel);
        return costPanel;
    }

    public void enableManualCostCheck(boolean enable) {
        if (!enable && this.manualCostCheck.isSelected()) {
            this.manualCostCheck.setSelected(false);
            this.avgCostIncSpinner.setEnabled(false);
            this.avgCostExSpinner.setEnabled(false);
        }
        this.manualCostCheck.setEnabled(enable);
    }

    private void updateSalesPriceModel() {
        this.updateSalesPriceModel(true);
    }

    private void updateSalesPriceModel(boolean stopEditing) {
        if (stopEditing && this.salesPricesTable != null && this.salesPricesTable.getCellEditor() != null) {
            this.salesPricesTable.getCellEditor().stopCellEditing();
        }
        this.salesPriceModel = this.currentUnit != null ? new SalesPricesTableModel(this.currentUnit.getPrices(), new Price(UnitsUsageStockCostPanel.getDoubleFromSpinner(this.avgCostExSpinner), 0.0)) : new SalesPricesTableModel(null, null);
        this.salesPricesTable.setModel(this.salesPriceModel);
        this.salesPricesTable.setDefaultRenderer(Object.class, new SalesPricesTableCellRenderer());
        this.salesPricesTable.setDefaultEditor(Object.class, new LegacyPriceEditor());
        this.updateTextColor();
        this.salesPricesTable.repaint();
    }

    private void updateTextColor() {
        boolean unprofitable = this.salesPriceModel.hasUnprofitableLevel();
        ApplicationFrame frame = GuiApp.getAppComplex().getApplicationFrame();
        if (unprofitable) {
            frame.setStatusBarText("UNPROFITABLE ITEM", Color.red);
        } else {
            frame.resetStatusBarText();
        }
    }

    private void updateForNewAvgCostIncTax() {
        if (this.updatesAllowed) {
            this.updatesAllowed = false;
            double costInc = UnitsUsageStockCostPanel.getDoubleFromSpinner(this.avgCostIncSpinner);
            double costEx = costInc - FinanceUtils.removeTax((double)costInc, (double)SystemProperty.getInstance().getBaseTaxRate());
            this.avgCostExSpinner.setValue(UnitsUsageStockCostPanel.getDoubleForSpinner(costEx));
            this.updatesAllowed = true;
        }
    }

    private void updateForNewAvgCostExTax() {
        if (this.updatesAllowed) {
            this.updatesAllowed = false;
            double costEx = UnitsUsageStockCostPanel.getDoubleFromSpinner(this.avgCostExSpinner);
            double costInc = FinanceUtils.addTax((double)costEx, (double)SystemProperty.getInstance().getBaseTaxRate());
            this.avgCostIncSpinner.setValue(new Price(costInc, 0.0));
            this.updatesAllowed = true;
        }
    }

    private static double getDoubleFromSpinner(JSpinner spinner) {
        return ((Number)spinner.getValue()).doubleValue();
    }

    public Price getCurrentCustomStockCost() {
        if (this.manualCostCheck.isSelected()) {
            try {
                this.avgCostExSpinner.commitEdit();
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            Number num = (Number)this.avgCostExSpinner.getValue();
            return new Price(num, 0.01);
        }
        return null;
    }

    private static Double getDoubleForSpinner(Price price) {
        return new Double(MathsUtils.roundDoubleToDecPlaces((double)price.doubleValue(), (int)2));
    }

    private static Double getDoubleForSpinner(double price) {
        return new Double(MathsUtils.roundDoubleToDecPlaces((double)price, (int)2));
    }

    @Override
    public void updateForStockLinkableObject(InventoryItemUnit unit) {
        if (this.lastEvent == 1 && this.currentUnit != null) {
            this.focusCustomCostInc = this.getCurrentCustomStockCost();
        }
        this.lastEvent = 3;
        this.currentUnit = unit;
        this.updatesAllowed = false;
        if (unit != null) {
            Price customCost = unit.getCustomStockCost();
            boolean hasCustomCost = customCost != null;
            this.manualCostCheck.setSelected(hasCustomCost);
            this.avgCostIncSpinner.setEnabled(false);
            if (hasCustomCost) {
                Double displayDouble = UnitsUsageStockCostPanel.getDoubleForSpinner(FinanceUtils.addTax((Price)unit.getIngredientCostExTax(), (double)SystemProperty.getInstance().getBaseTaxRate()));
                this.avgCostIncSpinner.setValue(displayDouble);
            } else {
                this.avgCostIncSpinner.setValue(UnitsUsageStockCostPanel.getDoubleForSpinner(unit.getIngredientCostIncTax()));
            }
            this.avgCostExSpinner.setEnabled(hasCustomCost);
            this.avgCostExSpinner.setValue(UnitsUsageStockCostPanel.getDoubleForSpinner(unit.getIngredientCostExTax()));
            this.currentCostIncSpinner.setValue(unit.getCurrentIngredientCost(true));
            this.currentCostExSpinner.setValue(unit.getCurrentIngredientCost(false));
            this.enableManualCostCheck(!unit.isStockUsed());
            this.retailGstFreeCheck.setSelected(unit.isTaxFree());
        } else {
            this.manualCostCheck.setEnabled(false);
            this.manualCostCheck.setSelected(false);
            this.avgCostIncSpinner.setEnabled(false);
            this.avgCostIncSpinner.setValue(new Double(0.0));
            this.avgCostExSpinner.setEnabled(false);
            this.avgCostExSpinner.setValue(new Double(0.0));
            this.currentCostIncSpinner.setValue(new Double(0.0));
            this.currentCostExSpinner.setValue(new Double(0.0));
            this.retailGstFreeCheck.setSelected(false);
        }
        this.updatesAllowed = true;
        this.updateSalesPriceModel();
        this.repaint();
    }

    @Override
    public void setEnabled(boolean b) {
        this.avgCostIncSpinner.setEnabled(b);
        this.avgCostExSpinner.setEnabled(b);
        this.manualCostCheck.setEnabled(b);
    }

    @Override
    public JComponent getGuiComponent() {
        return this;
    }

    protected class SalesPricesTableModel
    extends AbstractTableModel {
        private static final int NAME_COL = 0;
        private static final int PRICE_COL = 1;
        private static final int TAX_COL = 2;
        private static final int COST_COL = 3;
        private static final int GP_VALUE_COL = 4;
        private static final int GP_MARGIN_COL = 5;
        private static final int NUM_COLUMNS = 6;
        private Price cost;
        List unitPriceLevels;

        protected Price getCost() {
            return this.cost;
        }

        public SalesPricesTableModel(List newUnitPriceLevels, Price newCost) {
            this.unitPriceLevels = newUnitPriceLevels;
            this.cost = newCost;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int colIndex) {
            return colIndex == 1;
        }

        @Override
        public int getColumnCount() {
            return 6;
        }

        @Override
        public String getColumnName(int colIndex) {
            if (colIndex < 0 && colIndex >= 6) {
                throw new IllegalArgumentException("colIndex out of bounds");
            }
            return COLUMN_NAMES[colIndex];
        }

        @Override
        public int getRowCount() {
            if (this.unitPriceLevels == null) {
                return 0;
            }
            return this.unitPriceLevels.size();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            Assert.isEqual((int)5, (int)(this.getColumnCount() - 1), (String)"GP Margin Column should be last column");
            if (rowIndex >= this.getRowCount()) {
                throw new IndexOutOfBoundsException("Row index greater than number of rows");
            }
            UnitPriceLevel currentPriceLevel = (UnitPriceLevel)this.unitPriceLevels.get(rowIndex);
            Price taxAmount = currentPriceLevel.getTaxAmount();
            switch (columnIndex) {
                case 0: {
                    return currentPriceLevel.getPriceLevel().getLabel();
                }
                case 1: {
                    return currentPriceLevel.getPrice();
                }
                case 2: {
                    return taxAmount;
                }
                case 3: {
                    return this.getCost();
                }
                case 4: {
                    return FinanceUtils.calcGrossProfit((Price)currentPriceLevel.getPrice(), (Price)taxAmount, (Price)this.getCost());
                }
                case 5: {
                    return FinanceUtils.formatAsPercentage((double)FinanceUtils.calcGrossProfitMargin((Price)currentPriceLevel.getPrice(), (Price)taxAmount, (Price)this.getCost()));
                }
            }
            throw new IndexOutOfBoundsException("Column index out of bounds");
        }

        @Override
        public void setValueAt(Object value, int rowIndex, int columnIndex) {
            if (!this.isCellEditable(rowIndex, columnIndex)) {
                throw new IllegalStateException("Attempt to edit un-editable cell");
            }
            String str = (String)value;
            if (str.startsWith(Internationalization.getLiteralFor((String)"DOLLAR_SIGN"))) {
                str = str.substring(1);
            }
            Price newPrice = null;
            try {
                newPrice = new Price(Double.parseDouble(str));
            }
            catch (NumberFormatException ex) {
                return;
            }
            UnitPriceLevel currentPrice = (UnitPriceLevel)this.unitPriceLevels.get(rowIndex);
            currentPrice.setPrice(newPrice);
            currentPrice.save();
            UnitsUsageStockCostPanel.this.updateSalesPriceModel(false);
            UnitsUsageStockCostPanel.this.priceChanged.emit();
        }

        public boolean isProfitable(int rowIndex) {
            if (rowIndex < 0 || rowIndex >= this.getRowCount()) {
                throw new IllegalArgumentException("Row index out of bounds " + rowIndex);
            }
            UnitPriceLevel currentPrice = (UnitPriceLevel)this.unitPriceLevels.get(rowIndex);
            Price grossProfit = FinanceUtils.calcGrossProfit((Price)currentPrice.getPrice(), (Price)currentPrice.getTaxAmount(), (Price)this.getCost());
            return grossProfit != null && grossProfit.doubleValue() >= 0.0;
        }

        public boolean hasUnprofitableLevel() {
            for (int i = 0; i < this.getRowCount(); ++i) {
                if (this.isProfitable(i)) continue;
                return true;
            }
            return false;
        }
    }

    protected static class SalesPricesTableCellRenderer
    extends DefaultTableCellRenderer {
        protected SalesPricesTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean selected, boolean focused, int row, int column) {
            if (((SalesPricesTableModel)table.getModel()).isProfitable(row)) {
                this.setForeground(Color.BLACK);
            } else {
                this.setForeground(Color.RED);
            }
            super.getTableCellRendererComponent(table, value, selected, focused, row, column);
            return this;
        }
    }

    private class StockCostFocusListener
    implements FocusListener {
        private StockCostFocusListener() {
        }

        @Override
        public void focusGained(FocusEvent e) {
            UnitsUsageStockCostPanel.this.lastEvent = 1;
            UnitsUsageStockCostPanel.this.focusUnit = UnitsUsageStockCostPanel.this.currentUnit;
        }

        @Override
        public void focusLost(FocusEvent e) {
            if (UnitsUsageStockCostPanel.this.focusUnit != null) {
                if (UnitsUsageStockCostPanel.this.lastEvent == 1) {
                    UnitsUsageStockCostPanel.this.focusCustomCostInc = UnitsUsageStockCostPanel.this.getCurrentCustomStockCost();
                }
                UnitsUsageStockCostPanel.this.focusUnit.setCustomStockCost(UnitsUsageStockCostPanel.this.focusCustomCostInc);
                UnitsUsageStockCostPanel.this.focusUnit.saveChild();
                SystemCurrentInfo.setUpdate((String)"Inventory Item Custom Cost Changed");
                StockControlEventLog.logSetMenuItemCustomCost((User)GuiApp.getAppComplex().getApplicationSecurity().getUser(), (InventoryItemUnit)UnitsUsageStockCostPanel.this.focusUnit, (Price)UnitsUsageStockCostPanel.this.focusCustomCostInc);
                UnitsUsageStockCostPanel.this.newCustomCost.emit((Object)UnitsUsageStockCostPanel.this.focusCustomCostInc);
                UnitsUsageStockCostPanel.this.focusUnit = (InventoryItemUnit)PersistenceManager.reacquire((PersistentObjectI)UnitsUsageStockCostPanel.this.focusUnit);
            }
            UnitsUsageStockCostPanel.this.lastEvent = 2;
        }
    }

    private class CostChangeListener
    implements ChangeListener {
        private CostChangeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            if (e.getSource() == UnitsUsageStockCostPanel.this.avgCostExSpinner) {
                UnitsUsageStockCostPanel.this.updateForNewAvgCostExTax();
            } else if (e.getSource() == UnitsUsageStockCostPanel.this.avgCostIncSpinner) {
                UnitsUsageStockCostPanel.this.updateForNewAvgCostIncTax();
            } else {
                return;
            }
            UnitsUsageStockCostPanel.this.updateSalesPriceModel();
        }
    }
}

