/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.stock.units;

import au.com.ordermate.guicore.task.AbstractTask;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import officemate.adminkit.dialogs.Dialogs;
import officemate.screens.setup.stock.units.StockLinkableQueryTableCellRenderer;
import officemate.screens.setup.stock.units.UnitsUsageTableInterface;
import officemate.screens.setup.stock.units.UnitsUsageTableModel;
import ordermate.database.hardware.Terminal;
import ordermate.database.inventory.InventoryItemUnit;
import ordermate.database.reports.ItemIngredients;
import ordermate.database.stock.StockArea;
import ordermate.signals.Signal;
import ordermate.signals.Signals;

public class UnitsUsageTable
extends JTable
implements UnitsUsageTableInterface {
    public final Signal itemsAdded = Signals.createSignal();
    public final Signal objectChosen = Signals.createSignal();
    private JScrollPane scroller;

    public UnitsUsageTable() {
        super(null);
    }

    public UnitsUsageTable(UnitsUsageTableModel model) {
        this(model, false);
    }

    public UnitsUsageTable(UnitsUsageTableModel model, boolean includeStockAreaDec) {
        super(model);
        UnitsUsageTable.addPopupMenuToTable(this, includeStockAreaDec);
        this.setDefaultRenderer(String.class, new StockLinkableQueryTableCellRenderer());
        this.scroller = new JScrollPane(this, 20, 30);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getButton() == 1 && e.getClickCount() == 2) {
                    UnitsUsageTable.this.onObjectChosen();
                }
            }
        });
    }

    public static void addPopupMenuToTable(UnitsUsageTableInterface tableInterface, boolean includeStockAreaDec) {
        JTable table = tableInterface.getJTable();
        JPopupMenu autoCreateStockMenu = new JPopupMenu();
        JMenuItem autoCreateItem = new JMenuItem("Auto-link stock");
        JMenuItem autoCreateAllItem = new JMenuItem("Auto-link all visible");
        if (includeStockAreaDec) {
            JMenu decrementStockAreaItem = new JMenu("Decrement from");
            autoCreateStockMenu.add(decrementStockAreaItem);
            table.addMouseListener(new TableRightClickListener(tableInterface, autoCreateStockMenu, decrementStockAreaItem));
        }
        InnerMenuListener menuListener = new InnerMenuListener(tableInterface, autoCreateItem, autoCreateAllItem);
        autoCreateItem.addActionListener(menuListener);
        autoCreateAllItem.addActionListener(menuListener);
        autoCreateStockMenu.add(autoCreateItem);
        autoCreateStockMenu.add(autoCreateAllItem);
    }

    public JScrollPane getScroller() {
        return this.scroller;
    }

    @Override
    public JTable getJTable() {
        return this;
    }

    public UnitsUsageTableModel getUnitsUsageModel() {
        return (UnitsUsageTableModel)this.getModel();
    }

    @Override
    public void onItemsAdded() {
        this.itemsAdded.emit();
    }

    public void onObjectChosen() {
        this.objectChosen.emit();
    }

    public boolean isRowCostConfigured(int row) {
        return this.getUnitsUsageModel().isRowCostConfigured(row);
    }

    public boolean isRowProfitable(int row) {
        return this.getUnitsUsageModel().isRowProfitable(row);
    }

    @Override
    public InventoryItemUnit getCurrentUnit() {
        if (this.getSelectedRow() != -1) {
            return this.getUnitsUsageModel().getItemIngredientUnitForRow(this.getSelectedRow());
        }
        return null;
    }

    @Override
    public List getCurrentlyVisibleUnits() {
        ArrayList<InventoryItemUnit> retVal = new ArrayList<InventoryItemUnit>();
        List itemIngredients = this.getUnitsUsageModel().getData();
        if (itemIngredients == null) {
            return null;
        }
        for (ItemIngredients currentItem : itemIngredients) {
            retVal.add(currentItem.getInventoryItemUnit());
        }
        return retVal;
    }

    private static class PopupMenuActionListener
    implements ActionListener {
        private Terminal terminal;
        private StockArea area;
        private InventoryItemUnit item;
        private boolean isTicked;

        public PopupMenuActionListener(Terminal theTerminal, StockArea stockArea, InventoryItemUnit itemUnit, boolean isCheckTicked) {
            this.terminal = theTerminal;
            this.isTicked = isCheckTicked;
            this.area = stockArea;
            this.item = itemUnit;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.terminal != null) {
                if (!this.isTicked) {
                    this.item.getItem().setDefaultDecrementStockArea(this.terminal, this.area);
                } else {
                    this.item.getItem().setDefaultDecrementStockArea(this.terminal, null);
                }
            } else {
                this.item.getItem().setDecrementStockAreaForAllTerminals(this.area);
            }
            this.item.getItem().save();
        }
    }

    private static class PopupMenuListener
    implements MenuListener {
        private Terminal terminal;
        private InventoryItemUnit menuItem;

        public PopupMenuListener(Terminal theTerminal, InventoryItemUnit group) {
            this.terminal = theTerminal;
            this.menuItem = group;
        }

        @Override
        public void menuSelected(MenuEvent e) {
            JMenu menu = (JMenu)e.getSource();
            if (menu.getItemCount() == 0) {
                List stockAreas = StockArea.getStockAreas();
                ArrayList<Object> currentDecAreas = null;
                if (this.terminal != null) {
                    currentDecAreas = new ArrayList<Object>();
                    currentDecAreas.add(this.menuItem.getItem().getDecrementStockArea(this.terminal));
                } else {
                    HashSet<StockArea> uniqueStockAreas = new HashSet<StockArea>();
                    for (Terminal eachTerminal : Terminal.getAllTerminalsExceptServer()) {
                        uniqueStockAreas.add(this.menuItem.getItem().getDecrementStockArea(eachTerminal));
                    }
                    if (uniqueStockAreas.size() == 1 && Terminal.getAllTerminalsExceptServer().size() == this.menuItem.getItem().getDecrementStock().size()) {
                        currentDecAreas = new ArrayList();
                        currentDecAreas.add(uniqueStockAreas.iterator().next());
                    }
                }
                ButtonGroup group = new ButtonGroup();
                for (int i = 0; i < stockAreas.size(); ++i) {
                    StockArea area = (StockArea)stockAreas.get(i);
                    JCheckBoxMenuItem check = new JCheckBoxMenuItem(area.getLabel());
                    group.add(check);
                    menu.add(check);
                    boolean areaTicked = false;
                    if (currentDecAreas != null) {
                        areaTicked = currentDecAreas.contains(area);
                        check.setSelected(areaTicked);
                    }
                    PopupMenuActionListener listener = new PopupMenuActionListener(this.terminal, area, this.menuItem, areaTicked);
                    check.addActionListener(listener);
                }
            }
        }

        @Override
        public void menuCanceled(MenuEvent e) {
        }

        @Override
        public void menuDeselected(MenuEvent e) {
        }
    }

    private static class TableRightClickListener
    extends MouseAdapter {
        private JPopupMenu menu;
        private JMenu decrementStockAreaMenu;
        private UnitsUsageTableInterface tableInterface;

        TableRightClickListener(UnitsUsageTableInterface theTable, JPopupMenu theMenu, JMenu decrementStockAreaMenuItem) {
            this.menu = theMenu;
            this.decrementStockAreaMenu = decrementStockAreaMenuItem;
            this.tableInterface = theTable;
        }

        private void onRightClick(MouseEvent e) {
            int row = this.tableInterface.getJTable().rowAtPoint(new Point(e.getX(), e.getY()));
            if (row >= 0 && row < this.tableInterface.getJTable().getRowCount()) {
                this.tableInterface.getJTable().setRowSelectionInterval(row, row);
            }
            if (e.isPopupTrigger()) {
                if (this.tableInterface.getCurrentUnit() != null) {
                    this.decrementStockAreaMenu.setVisible(true);
                    this.buildDecrementStockAreaMenu();
                } else {
                    this.decrementStockAreaMenu.setVisible(false);
                }
                this.menu.show(e.getComponent(), e.getX(), e.getY());
            }
        }

        private void buildDecrementStockAreaMenu() {
            this.decrementStockAreaMenu.removeAll();
            List allTerminals = Terminal.getAllTerminalsExceptServer();
            InventoryItemUnit currentUnit = this.tableInterface.getCurrentUnit();
            JMenu menuItem = new JMenu("(All)");
            this.setupStockAreaPopupMenu(menuItem, null, currentUnit);
            this.decrementStockAreaMenu.add(menuItem);
            for (Terminal terminal : allTerminals) {
                menuItem = new JMenu(terminal.getName());
                this.setupStockAreaPopupMenu(menuItem, terminal, currentUnit);
                this.decrementStockAreaMenu.add(menuItem);
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.onRightClick(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.onRightClick(e);
        }

        private void setupStockAreaPopupMenu(JMenu menu, Terminal terminal, InventoryItemUnit menuItem) {
            PopupMenuListener listener = new PopupMenuListener(terminal, menuItem);
            menu.addMenuListener(listener);
        }
    }

    private static class InnerMenuListener
    implements ActionListener {
        private JMenuItem autoCreateItem;
        private JMenuItem autoCreateAllItem;
        private UnitsUsageTableInterface table;

        public InnerMenuListener(UnitsUsageTableInterface theTable, JMenuItem autoCreateMenuItem, JMenuItem autoCreateAllMenuItem) {
            this.autoCreateItem = autoCreateMenuItem;
            this.autoCreateAllItem = autoCreateAllMenuItem;
            this.table = theTable;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == this.autoCreateItem) {
                InventoryItemUnit currentUnit = this.table.getCurrentUnit();
                if (!currentUnit.isStockUsed() && currentUnit.linkStockItemForUnit() != null) {
                    currentUnit.saveChild();
                    this.table.onItemsAdded();
                }
            } else if (e.getSource() == this.autoCreateAllItem) {
                Dialogs.showProgressDialog(new AutoCreateTask());
            }
        }

        private class AutoCreateTask
        extends AbstractTask {
            List objects;

            private AutoCreateTask() {
                this.objects = InnerMenuListener.this.table.getCurrentlyVisibleUnits();
            }

            public String getName() {
                return "Auto-creating stock items...";
            }

            public void performTask() throws Exception {
                for (int i = 0; i < this.objects.size(); ++i) {
                    InventoryItemUnit unit = (InventoryItemUnit)this.objects.get(i);
                    if (unit.isStockUsed()) continue;
                    unit.linkStockItemForUnit();
                    unit.saveChild();
                    this.emitProgress();
                }
                InnerMenuListener.this.table.onItemsAdded();
            }

            public int getTotalSubTasks() {
                return this.objects.size();
            }
        }
    }
}

