/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.stock.units;

import au.com.ordermate.persistence.PropertiedObject;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import ordermate.database.inventory.InventoryGroup;
import ordermate.database.inventory.InventoryItemUnit;
import ordermate.database.inventory.InventoryProfile;
import ordermate.database.reports.ItemIngredients;

public class UnitsUsageTableModel
extends AbstractTableModel {
    private static final int COL_GROUP_NAME = 0;
    private static final int COL_ITEM_NAME = 1;
    private static final int COL_SIZE = 2;
    private static final int COL_PORTION = 3;
    private static final int COL_USAGE = 4;
    private static final int COLUMN_COUNT = 5;
    private List itemIngredients = null;

    public UnitsUsageTableModel(InventoryGroup group, InventoryProfile profile) {
        this.update(group, profile, false);
    }

    public UnitsUsageTableModel(List itemIngredientsData) {
        if (itemIngredientsData != null && itemIngredientsData.size() > 0) {
            if (!(itemIngredientsData.get(0) instanceof ItemIngredients)) {
                throw new IllegalArgumentException("List items should be instance of ItemIngredients");
            }
            this.itemIngredients = itemIngredientsData;
        }
    }

    public List getData() {
        return this.itemIngredients;
    }

    public void update(InventoryGroup newGroup, InventoryProfile newProfile, boolean hideProfitable) {
        this.itemIngredients = ItemIngredients.getItemIngredientsReport((InventoryGroup)newGroup, (InventoryProfile)newProfile);
        if (hideProfitable) {
            this.filterProfitable();
        }
        this.fireTableDataChanged();
    }

    private void filterProfitable() {
        for (int index = this.itemIngredients.size() - 1; index >= 0; --index) {
            ItemIngredients currentItem = (ItemIngredients)this.itemIngredients.get(index);
            if (!currentItem.isItemProfitable()) continue;
            this.itemIngredients.remove(index);
        }
    }

    public boolean isRowCostConfigured(int row) {
        ItemIngredients currentItem = this.getItemIngredientForRow(row);
        return currentItem.getIngredientCount() > 0 || currentItem.getCost().doubleValue() > 0.0;
    }

    public boolean isRowProfitable(int row) {
        return this.getItemIngredientForRow(row).isItemProfitable();
    }

    @Override
    public int getColumnCount() {
        return 5;
    }

    @Override
    public int getRowCount() {
        if (this.itemIngredients != null) {
            return this.itemIngredients.size();
        }
        return 0;
    }

    public int getRowFromObject(InventoryItemUnit itemToFind) {
        int itemID = itemToFind.getID().intValue();
        for (int index = 0; index < this.getRowCount(); ++index) {
            ItemIngredients currentItem = (ItemIngredients)this.itemIngredients.get(index);
            if (currentItem.getID().intValue() != itemID) continue;
            return index;
        }
        return -1;
    }

    protected ItemIngredients getItemIngredientForRow(int rowIndex) throws IndexOutOfBoundsException {
        if (rowIndex < 0 || rowIndex >= this.itemIngredients.size()) {
            throw new IndexOutOfBoundsException("rowIndex out of bounds :" + rowIndex);
        }
        return (ItemIngredients)this.itemIngredients.get(rowIndex);
    }

    public InventoryItemUnit getItemIngredientUnitForRow(int rowIndex) {
        return this.getItemIngredientForRow(rowIndex).getInventoryItemUnit();
    }

    public PropertiedObject.Property getPropertyForColumn(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return ItemIngredients.Properties.GROUP_NAME;
            }
            case 1: {
                return ItemIngredients.Properties.ITEM_NAME;
            }
            case 3: {
                return ItemIngredients.Properties.ITEM_PORTION;
            }
            case 2: {
                return ItemIngredients.Properties.ITEM_SIZE;
            }
            case 4: {
                return ItemIngredients.Properties.USAGE_QUANTITY;
            }
        }
        throw new IndexOutOfBoundsException("Unknown column index : " + columnIndex);
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        ItemIngredients currentItem = this.getItemIngredientForRow(rowIndex);
        switch (columnIndex) {
            case 0: {
                return currentItem.getGroupName();
            }
            case 1: {
                return currentItem.getItemName();
            }
            case 3: {
                return currentItem.getItemPortion();
            }
            case 2: {
                return currentItem.getItemSize();
            }
            case 4: {
                return currentItem.getLinkedStockUsage();
            }
        }
        throw new IndexOutOfBoundsException("Unknown column index : " + columnIndex);
    }

    @Override
    public String getColumnName(int column) {
        return ItemIngredients.Properties.getFieldLabel(this.getPropertyForColumn(column));
    }
}

