/*
 * Decompiled with CFR 0.152.
 */
package officemate.startup;

import au.com.ordermate.guicore.task.AbstractTask;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import ordermate.database.config.report.DefaultReportConfig;
import ordermate.database.config.report.ReportConfig;
import ordermate.database.config.report.ReportConfigFilter;
import ordermate.database.config.report.ReportConfigSchedule;
import org.apache.commons.collections.map.HashedMap;

public class LoadOfficemateDefaultsTask
extends AbstractTask {
    private Map<String, DefaultReportConfig> map = new HashedMap();

    public LoadOfficemateDefaultsTask() {
        this.map.put("Daily Item Deleted Report", new DefaultReportConfig("Items Deleted", "0 0 9 1/1 * ? * ", "-1d", "Date Range"));
        this.map.put("Daily Item Sold Report", new DefaultReportConfig("Item Sold", "0 0 9 1/1 * ? * ", "-1d", "Date Range"));
        this.map.put("Daily Summary By Category", new DefaultReportConfig("Daily Summary By Category", "0 0 9 1/1 * ? * ", "-1d", "Date"));
        this.map.put("Daily Summary By Account Type", new DefaultReportConfig("Daily Summary By Account Type", "0 0 9 1/1 * ? * ", "-1d", "Date"));
        this.map.put("Reconciliation Report", new DefaultReportConfig("Reconciliation", "0 0 9 1/1 * ? * ", "-1d", "Date"));
        this.map.put("Takings Summary", new DefaultReportConfig("Takings Summary", "0 0 9 1/1 * ? * ", "-1d", "Date Range"));
        this.map.put("Weekly Item Deleted Report", new DefaultReportConfig("Items Deleted", "0 0 9 ? * MON * ", "-7d: Now", "Date Range"));
        this.map.put("Weekly Item Sold Report", new DefaultReportConfig("Item Sold", "0 0 9 ? * MON * ", "-7d: Now", "Date Range"));
        this.map.put("Weekly Summary By Category", new DefaultReportConfig("Daily Summary By Category", "0 0 9 ? * MON * ", "-7d: Now", "Date"));
        this.map.put("Weekly Summary By Account Type", new DefaultReportConfig("Daily Summary By Account Type", "0 0 9 ? * MON * ", "-7d: Now", "Date"));
        this.map.put("SATA Weekly", new DefaultReportConfig("Sales And Takings Analysis", "0 0 9 ? * MON * ", "-7d: Now", "Date Range"));
        this.map.put("Account Sales Weekly", new DefaultReportConfig("Account Sales", "0 0 9 ? * MON * ", "-7d: Now", "Date Range"));
        this.map.put("Discounts By User", new DefaultReportConfig("Discounts By User", "0 0 9 ? * MON * ", "-7d: Now", "Time"));
        this.map.put("Monthly Item Deleted Report", new DefaultReportConfig("Items Deleted", "0 0 9 1 1/1 ? * ", "-1m: Now", "Date Range"));
        this.map.put("Monthly Item Sold Report", new DefaultReportConfig("Item Sold", "0 0 9 1 1/1 ? * ", "-1m: Now", "Date Range"));
    }

    public Map<String, DefaultReportConfig> getMap() {
        return this.map;
    }

    protected int getTotalSubTasks() {
        return 0;
    }

    public boolean hasMoreThanOneTask() {
        return false;
    }

    public int getProgressMaximum() {
        return 0;
    }

    public String getName() {
        return "Load Officemate Default Reports Task";
    }

    public Icon getIcon() {
        return null;
    }

    void createNewConfigAndSchedule(String value) {
        DefaultReportConfig defaultCfg = this.map.get(value);
        if (defaultCfg != null) {
            ReportConfig config = new ReportConfig(defaultCfg.getName(), value);
            ReportConfigFilter filter = new ReportConfigFilter(config, defaultCfg.getFilterName());
            filter.setSearchValue(defaultCfg.getPeriod());
            config.getFilters().add(filter);
            config.save();
            ReportConfigSchedule cfgSchedule = new ReportConfigSchedule(config);
            cfgSchedule.setCronSchedule(defaultCfg.getCron());
            cfgSchedule.setEmail("");
            cfgSchedule.save();
        }
    }

    protected void performTask() throws Exception {
        HashSet<String> knownNames = new HashSet<String>(this.map.keySet());
        List currentConfigs = PersistenceManager.getObjectList(ReportConfig.class, (String)Query.select(ReportConfig.class).toString());
        for (ReportConfig config : currentConfigs) {
            knownNames.remove(config.getLabel());
        }
        for (String name : knownNames) {
            this.createNewConfigAndSchedule(name);
        }
    }
}

