/*
 * Decompiled with CFR 0.152.
 */
package servermate;

import au.com.ordermate.OMLogUtil;
import au.com.ordermate.OrderMateLog;
import au.com.ordermate.configuration.Config;
import au.com.ordermate.guicore.task.AbstractTask;
import au.com.ordermate.guicore.task.CompositeTask;
import au.com.ordermate.guicore.task.Task;
import au.com.ordermate.guicore.task.TaskInterrupter;
import au.com.ordermate.networkio.ports.GuiPortFactory;
import au.com.ordermate.networkio.ports.GuiPortType;
import au.com.ordermate.persistence.PersistenceManager;
import java.net.InetAddress;
import java.security.Security;
import ordermate.OrderMate;
import ordermate.database.hardware.Terminal;
import ordermate.dbconnection.AbstractDatabaseConnection;
import ordermate.remotemonitor.RemoteMonitorTask;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import ordermate.signals.ThreadLocalSignal;
import ordermate.startup.ActionManagerTask;
import ordermate.startup.CallerIDSetupTask;
import ordermate.startup.CameraSetupTask;
import ordermate.startup.CashdrawerSetupTask;
import ordermate.startup.ConfigurationTask;
import ordermate.startup.CopyLibrariesTask;
import ordermate.startup.DeadlockLog;
import ordermate.startup.DeviceFailureStartupTask;
import ordermate.startup.DeviceNotFoundException;
import ordermate.startup.InitExecuteTaskLocalService;
import ordermate.startup.LogStartupTask;
import ordermate.startup.ManagerStartupTask;
import ordermate.startup.MemoryLog;
import ordermate.startup.OrderMateSetupException;
import ordermate.startup.PermissionsStartupTask;
import ordermate.startup.PoleDisplaySetupTask;
import ordermate.startup.PriceInternationalizationTask;
import ordermate.startup.PrinterSetupTask;
import ordermate.startup.RMIStartupTask;
import ordermate.startup.SetupMeasureUnitTask;
import ordermate.startup.StartupErrorManager;
import ordermate.startup.StartupManagerImpl;
import ordermate.startup.TerminalNotFoundException;
import ordermate.startup.TimeServerSetupTask;
import ordermate.startup.UniqueTask;
import org.apache.logging.log4j.core.Logger;
import servermate.ServerMateCacheManager;
import servermate.events.ServerMateEndPointInitTask;
import servermate.events.ServerMateEvent;
import servermate.events.ServerMateEventPublisher;
import servermate.events.ServerMateEventType;
import servermate.events.ServermateStartupEventDelegate;
import servermate.security.ServermateSecurityManager;
import servermate.servlets.jersey.WebResourceStartupTask;
import servermate.startup.AutoMenuImporterTask;
import servermate.startup.BarTabsIntegrationSetupTask;
import servermate.startup.BevConExportTask;
import servermate.startup.ChangeDaySetupTask;
import servermate.startup.CheckDatabaseTask;
import servermate.startup.CheckEftposFinanceUnitsTask;
import servermate.startup.ConnectionCheckServerSetupTask;
import servermate.startup.ConstructDatabaseMaintenanceServiceTask;
import servermate.startup.ConstructDatabaseServiceTask;
import servermate.startup.CouponSetupTask;
import servermate.startup.CustomReportManagerStartupTask;
import servermate.startup.DatabaseVersionCheckTask;
import servermate.startup.DocketProcessorStartupTask;
import servermate.startup.EmailReportStartupTask;
import servermate.startup.FailoverCompositeTask;
import servermate.startup.FutureDocketInterceptorStartupTask;
import servermate.startup.HOCommandQueueStartupTask;
import servermate.startup.HOTimeDifferenceTask;
import servermate.startup.IntegrationSetupTask;
import servermate.startup.LabourIntegrationStartupTask;
import servermate.startup.MessageReceiverStartupTask;
import servermate.startup.NaggerCheckTask;
import servermate.startup.OmOStartupTask;
import servermate.startup.OnlinePaymentSetupTask;
import servermate.startup.PersistenceServerSetupTask;
import servermate.startup.PiggyNonRoomSalesPushStartupTask;
import servermate.startup.PropertiesServerSetupTask;
import servermate.startup.RedBackSetupTask;
import servermate.startup.SalesExportIntegrationStartupTask;
import servermate.startup.ScheduleDBIntegrityCheckStartupTask;
import servermate.startup.SecuritySetupTask;
import servermate.startup.ServerMateUpdateTask;
import servermate.startup.ServerRemoteShutdownTask;
import servermate.startup.ServermateHeartbeatTask;
import servermate.startup.ServermateRegistryCheckTask;
import servermate.startup.ServletStartupTask;
import servermate.startup.SetupServerMateTerminalTask;
import servermate.startup.SystemVersionHistoryUpdateTask;
import servermate.startup.TopicSubscriptionStartupTask;
import servermate.startup.TosCheckTask;
import servermate.startup.UpdateMateScriptWatcherStartupTask;
import servermate.startup.VersionControlDiffStartupTask;
import servermate.startup.VoucherSetupTask;
import servermate.startup.WorkflowManagerStartupTask;
import servermate.startup.scheduledtasks.RegisterScheduledTask;
import servermate.startup.scheduledtasks.ServerMateSchedulerSetupTask;

public class ServerMate {
    public static final String PRODUCT_NAME = "ServerMate";
    public static final Logger LOG = OMLogUtil.createRootLogger((String)"ServerMate");
    private static ServerMate instance;
    private static final int MAX_NUM_RETRIES = 30;
    private static final long RETRY_INTERVAL = 10000L;
    private static ServermateStartupEventDelegate eventDelegate;
    private static boolean started;

    public static final ServerMate getInstance() {
        if (!ServerMate.hasInstance()) {
            throw new IllegalStateException("Servermate instance has not yet been initialized.");
        }
        return instance;
    }

    public static final synchronized boolean hasInstance() {
        return instance != null;
    }

    private ServerMate() {
        if (!ServermateSecurityManager.isLicenseCheckThreadRunning()) {
            if (Config.isDebuging()) {
                throw new IllegalStateException("ServerMate Security has not been started.");
            }
            ServerMateEventPublisher.shutdown();
            OrderMate.LOG.error("ServerMate Security has not been started, exiting.");
            System.exit(0);
        }
    }

    public static void main(String[] args) {
        Signals.setSignalType((Signal)new ThreadLocalSignal(new Class[0]));
        System.setProperty("Driver", "com.sun.comm.Win32Driver");
        Security.setProperty("networkaddress.cache.ttl", "60");
        System.setProperty("https.protocols", "TLSv1,TLSv1.1,TLSv1.2");
        LOG.info("Starting ServerMate " + OrderMate.VERSION);
        OrderMate.LOG = LOG;
        OrderMateLog.LOG = LOG;
        eventDelegate = new ServermateStartupEventDelegate();
        GuiPortFactory.setGuiPortType((GuiPortType)GuiPortType.SERVER);
        ConfigurationTask config = new ConfigurationTask("ServermateConfig.ini");
        TaskInterrupter interrupter = new TaskInterrupter("Skip database check");
        PersistenceManager.getInstance().clearLocalCaches();
        config.run();
        CompositeTask startup = new CompositeTask("Starting ServerMate");
        startup.setRunOnce(false);
        ServerMate.addCoreTasks(startup, interrupter);
        FailoverCompositeTask masterStartup = new FailoverCompositeTask();
        ServerMate.addServerMateTasks(masterStartup, interrupter);
        startup.addTask((Task)masterStartup);
        ServerMate.startUpScreen(startup);
        instance = new ServerMate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void startUpScreen(CompositeTask startup) {
        int retryCount = 1;
        String serverStatus = "";
        while (!startup.hasRun() || !"ServerMate ready".equals(serverStatus) && retryCount <= 30) {
            try {
                startup.runLocal();
                StartupManagerImpl.setStatus((String)"ServerMate ready");
            }
            catch (TerminalNotFoundException e) {
                StartupManagerImpl.setStatus((String)"An error occurred starting ServerMate");
                LOG.error(e.getMessage());
                try {
                    LOG.info("Creating a ServerMate terminal in the database for this host.");
                    Terminal newServermate = new Terminal(InetAddress.getLocalHost(), PRODUCT_NAME);
                    newServermate.save();
                }
                catch (Exception err) {
                    LOG.error("Error creating terminal.", (Throwable)err);
                }
            }
            catch (DeviceNotFoundException e) {
                StartupManagerImpl.setStatus((String)"An error occurred starting ServerMate");
                LOG.error(e.getMessage(), (Throwable)e);
                startup.removeTask(e.getFailedTask());
            }
            catch (OrderMateSetupException e) {
                LOG.error(e.getMessage(), (Throwable)e);
                String messageToDisplay = e.getHTMLMessage();
                if (e.isFatal()) {
                    LOG.error(messageToDisplay);
                    ServerMate.repairAndExit();
                    continue;
                }
                startup.removeTask(e.getFailedTask());
            }
            catch (Exception e) {
                LOG.error("Error occurred during startup", (Throwable)e);
                StartupManagerImpl.setStatus((String)"An error occurred starting ServerMate");
                if (retryCount <= 30) {
                    LOG.warn("Attempt " + retryCount + " of " + 30 + ". Error: " + e.getMessage());
                    continue;
                }
                LOG.warn("An error occurred during startup: Error message is: '" + e.getMessage());
                ServerMate.repairAndExit();
            }
            finally {
                try {
                    serverStatus = StartupManagerImpl.getInstance().getStatus();
                    Thread.sleep(10000L);
                }
                catch (InterruptedException e) {
                    LOG.error("Failed to execute Thread.sleep().", (Throwable)e);
                }
                catch (Exception e) {
                    LOG.error("Could not fetch server status.", (Throwable)e);
                }
                LOG.info("Attempt " + retryCount + " of " + 30 + " to startup ServerMate. Current status is " + serverStatus);
                ++retryCount;
            }
        }
        started = true;
        LOG.info("Startup complete");
        ServerMateEventPublisher.publishEvent(new ServerMateEvent(ServerMateEventType.STARTUP, "Startup Complete", 100));
        ServerMateEventPublisher.publishLocalEvent(new ServerMateEvent(ServerMateEventType.STARTUP_COMPLETE, "Startup Complete", 100));
    }

    private static void repairAndExit() {
        try {
            TaskInterrupter interrupt = new TaskInterrupter("Cancel repair");
            new ConstructDatabaseServiceTask(false).runLocal();
            CheckDatabaseTask task = new CheckDatabaseTask(interrupt);
            task.setForcedRepair(true);
            OrderMate.LOG.info("Performing repair of database.");
            task.runLocal();
        }
        catch (Exception ex) {
            LOG.error("An error occurred attempting to repair the database, will exit.", (Throwable)ex);
        }
        finally {
            ServerMate.exit(-1);
        }
    }

    private static void addTask(CompositeTask starup, AbstractTask newTask) {
        newTask.clientProgress.connect((Object)eventDelegate, "emitStartupProgressToClient");
        starup.addTask((Task)newTask);
    }

    private static void addCoreTasks(CompositeTask startup, TaskInterrupter interrupter) {
        ServerMate.addTask(startup, (AbstractTask)new RMIStartupTask(new int[]{11100}));
        ServerMate.addTask(startup, (AbstractTask)new UniqueTask(PRODUCT_NAME, 11100));
        ServerMate.addTask(startup, (AbstractTask)new ManagerStartupTask(PRODUCT_NAME));
        ServerMate.addTask(startup, new ServerMateEndPointInitTask(interrupter));
        ServerMate.addTask(startup, new AbstractTask(){

            public String getName() {
                return "Initilize ServerMate Cache";
            }

            protected int getTotalSubTasks() {
                return 1;
            }

            protected void performTask() throws Exception {
                if (!Config.getBooleanValue((String)"disableCache")) {
                    ServerMateCacheManager.initialize();
                }
            }
        });
        ServerMate.addTask(startup, new ConstructDatabaseMaintenanceServiceTask(true));
        ServerMate.addTask(startup, new ServermateRegistryCheckTask());
        ServerMate.addTask(startup, new DatabaseVersionCheckTask(interrupter));
        ServerMate.addTask(startup, new PersistenceServerSetupTask(true));
        ServerMate.addTask(startup, new ConstructDatabaseServiceTask(true));
        ServerMate.addTask(startup, new CheckDatabaseTask(interrupter));
        ServerMate.addTask(startup, new VersionControlDiffStartupTask());
        ServerMate.addTask(startup, (AbstractTask)new SetupMeasureUnitTask());
        ServerMate.addTask(startup, (AbstractTask)new SetupServerMateTerminalTask());
        ServerMate.addTask(startup, new SecuritySetupTask());
        ServerMate.addTask(startup, new SystemVersionHistoryUpdateTask());
    }

    private static void addServerMateTasks(CompositeTask startup, TaskInterrupter interrupter) {
        ServerMate.addTask(startup, (AbstractTask)new PermissionsStartupTask());
        ServerMate.addTask(startup, (AbstractTask)new PrinterSetupTask(StartupErrorManager.getInstance()));
        ServerMate.addTask(startup, new DocketProcessorStartupTask());
        ServerMate.addTask(startup, new FutureDocketInterceptorStartupTask());
        ServerMate.addTask(startup, new WorkflowManagerStartupTask());
        ServerMate.addTask(startup, new ServermateHeartbeatTask());
        ServerMate.addTask(startup, (AbstractTask)new CashdrawerSetupTask(StartupErrorManager.getInstance()));
        ServerMate.addTask(startup, new IntegrationSetupTask());
        ServerMate.addTask(startup, new CouponSetupTask());
        ServerMate.addTask(startup, new VoucherSetupTask());
        ServerMate.addTask(startup, new OnlinePaymentSetupTask());
        ServerMate.addTask(startup, new BarTabsIntegrationSetupTask());
        ServerMate.addTask(startup, new RedBackSetupTask());
        ServerMate.addTask(startup, new NaggerCheckTask());
        ServerMate.addTask(startup, new TosCheckTask());
        ServerMate.addTask(startup, new CustomReportManagerStartupTask());
        RegisterScheduledTask registerScheduledTask = new RegisterScheduledTask();
        ServerMate.addTask(startup, registerScheduledTask);
        ServerMate.addTask(startup, (AbstractTask)new PriceInternationalizationTask());
        ServerMate.addTask(startup, new ChangeDaySetupTask());
        ServerMate.addTask(startup, (AbstractTask)new ActionManagerTask(true, null));
        ServerMate.addTask(startup, (AbstractTask)new PoleDisplaySetupTask());
        ServerMate.addTask(startup, (AbstractTask)new CameraSetupTask());
        ServerMate.addTask(startup, (AbstractTask)new CallerIDSetupTask());
        ServerMate.addTask(startup, new MessageReceiverStartupTask());
        ServerMate.addTask(startup, new PropertiesServerSetupTask());
        ServerMate.addTask(startup, new ConnectionCheckServerSetupTask());
        ServerMate.addTask(startup, (AbstractTask)new LogStartupTask());
        ServerMate.addTask(startup, (AbstractTask)new MemoryLog(PRODUCT_NAME));
        ServerMate.addTask(startup, (AbstractTask)new DeadlockLog(PRODUCT_NAME));
        ServerMate.addTask(startup, (AbstractTask)new TimeServerSetupTask());
        ServerMate.addTask(startup, new ServerRemoteShutdownTask());
        ServerMate.addTask(startup, (AbstractTask)new RemoteMonitorTask());
        ServerMate.addTask(startup, new AutoMenuImporterTask());
        ServerMateUpdateTask updateTask = new ServerMateUpdateTask();
        ServerMate.addTask(startup, updateTask);
        ServerMate.addTask(startup, new UpdateMateScriptWatcherStartupTask(updateTask.getClientUpdateWS()));
        ServerMate.addTask(startup, new LabourIntegrationStartupTask());
        ServerMate.addTask(startup, new SalesExportIntegrationStartupTask());
        ServerMate.addTask(startup, new PiggyNonRoomSalesPushStartupTask());
        ServerMate.addTask(startup, new EmailReportStartupTask());
        ServerMate.addTask(startup, new ScheduleDBIntegrityCheckStartupTask(interrupter));
        ServerMate.addTask(startup, new OmOStartupTask());
        ServerMate.addTask(startup, new ServletStartupTask());
        ServerMate.addTask(startup, new WebResourceStartupTask());
        ServerMate.addTask(startup, new CheckEftposFinanceUnitsTask());
        ServerMate.addTask(startup, new HOTimeDifferenceTask());
        ServerMate.addTask(startup, new TopicSubscriptionStartupTask());
        ServerMate.addTask(startup, new HOCommandQueueStartupTask());
        ServerMate.addTask(startup, (AbstractTask)new DeviceFailureStartupTask());
        ServerMate.addTask(startup, new ServerMateSchedulerSetupTask(registerScheduledTask));
        ServerMate.addTask(startup, (AbstractTask)new InitExecuteTaskLocalService());
        ServerMate.addTask(startup, (AbstractTask)new CopyLibrariesTask());
        ServerMate.addTask(startup, new BevConExportTask());
    }

    public final void startupServermateProper() {
        final CompositeTask theRest = new CompositeTask("Servermate Proper");
        TaskInterrupter interrupter = new TaskInterrupter("Skip database check");
        ServerMate.addServerMateTasks(theRest, interrupter);
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                ServerMate.startUpScreen(theRest);
                started = true;
            }
        });
        thread.start();
    }

    public static void exit(int exitCode) {
        AbstractDatabaseConnection.closeAllConnectionsOnExit();
        OrderMate.LOG.info("Exiting ServerMate : " + OrderMate.VERSION);
        System.exit(exitCode);
    }

    public static boolean isStarted() {
        return started;
    }

    static {
        started = false;
    }
}

