/*
 * Decompiled with CFR 0.152.
 */
package servermate;

import au.com.ordermate.persistence.PersistenceService;
import au.com.ordermate.persistence.UnsafePersistence;
import au.com.ordermate.persistence.cache.remote.RemoteCachePublisher;
import au.com.ordermate.persistence.database.ModCountPrePersistenceListener;
import au.com.ordermate.persistence.synchronisation.PersistenceListener;
import au.com.ordermate.persistence.synchronisation.PersistenceSyncInterceptor;
import au.com.ordermate.persistence.synchronisation.PrePersistenceListener;
import au.com.ordermate.simplermi.SimpleRMI;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Map;
import ordermate.OrderMate;
import ordermate.database.misc.HOConfig;
import ordermate.database.misc.license.LicenseType;
import ordermate.database.misc.license.PersistentLicenseManager;
import ordermate.database.sales.customer.CustomerInterceptor;
import ordermate.database.stock.usage.PreProdManager;
import ordermate.database.stock.usage.PreProdManagerImpl;
import ordermate.database.users.StoreSyncInterceptor;
import ordermate.database.workflow.WorkflowManager;
import ordermate.hom.synchronisation.SyncQueueVendor;
import ordermate.hom.synchronisation.SynchronisationListener;
import ordermate.hom.synchronisation.SynchronisationQueue;
import ordermate.hom.synchronisation.status.SynchronisationStatusManager;
import ordermate.integration.onlinesales.notifier.OnlineUpdateInterceptor;
import ordermate.persistence.remote.RemotePersistence;
import ordermate.services.sales.RemoteSalesComponentUsageService;
import ordermate.services.sales.SalesComponentUsageService;
import servermate.ServerMate;
import servermate.failover.FailoverManager;

public class ServermatePersistenceSharer {
    private static ServermatePersistenceSharer instance;
    private PersistenceSyncInterceptor interceptor;
    private RemoteCachePublisher publisher;
    final Map<Class<? extends PersistenceService>, PersistenceService> interfaceToServiceMap;
    private boolean share;

    public static final ServermatePersistenceSharer getInstance() {
        return instance;
    }

    public static final void init(PersistenceSyncInterceptor persistence, RemoteCachePublisher publisher, boolean share) throws RemoteException {
        instance = new ServermatePersistenceSharer(persistence, publisher, share);
    }

    private ServermatePersistenceSharer(PersistenceSyncInterceptor theInterceptor, RemoteCachePublisher thePublisher, boolean shouldShare) throws RemoteException {
        boolean isSlave;
        this.interceptor = theInterceptor;
        this.publisher = thePublisher;
        this.share = shouldShare;
        this.interfaceToServiceMap = new HashMap<Class<? extends PersistenceService>, PersistenceService>();
        FailoverManager.init();
        boolean bl = isSlave = FailoverManager.getInstance().getSetup().isSlave() && !FailoverManager.getInstance().getSetup().isActingMaster();
        if (!isSlave) {
            this.startSynchronisation(this.interceptor);
            this.doShare();
        }
        if (!isSlave) {
            this.publishServicesOverRMI();
        }
    }

    public void startSharing() throws RemoteException {
        this.doShare();
        this.publishServicesOverRMI();
    }

    public void stopSharing() {
        this.doUnshare();
    }

    void doShare() throws RemoteException {
        if (this.share) {
            OrderMate.LOG.info("Sharing my persistence over RMI.");
            RemotePersistence.sharePersistence((UnsafePersistence)this.interceptor);
            SimpleRMI.shareObject((Remote)this.publisher.getSubscriptionService(), (String)"RemoteCacheSubscriptionService");
        } else {
            OrderMate.LOG.info("Not sharing my persistence.");
        }
    }

    private void doUnshare() {
        SimpleRMI.unshareObject((String)"RMIStore");
        SimpleRMI.unshareObject((String)"RemoteCacheSubscriptionService");
    }

    private void startSynchronisation(PersistenceSyncInterceptor dbSync) {
        if (HOConfig.getInstance().isConfigured()) {
            ServerMate.LOG.info("Lauching the SynchronisationQueue.");
            SynchronisationQueue.startExecutor((SynchronisationQueue)SyncQueueVendor.getQueue((SyncQueueVendor.SyncQueueType)SyncQueueVendor.SyncQueueType.HeadOfficeUpdate));
            SynchronisationQueue.startExecutor((SynchronisationQueue)SyncQueueVendor.getQueue((SyncQueueVendor.SyncQueueType)SyncQueueVendor.SyncQueueType.HeadOfficeVerification));
            dbSync.addPersistenceListener(SynchronisationListener.getInstance());
            SynchronisationStatusManager.getInstance().startJMSPinger();
        } else if (HOConfig.getInstance().isEnabled()) {
            ServerMate.LOG.info("Synchronisation is set to disabled, store group is null");
        } else {
            ServerMate.LOG.info("Synchronisation is set to disabled in HOConfig.");
        }
        if (PersistentLicenseManager.getInstance().getBoolean(LicenseType.CouponsIntegrationEnabled)) {
            dbSync.addPersistenceListener((PersistenceListener)new CustomerInterceptor());
        }
        dbSync.addPersistenceListener((PersistenceListener)WorkflowManager.getInstance());
        dbSync.addPersistenceListener((PersistenceListener)OnlineUpdateInterceptor.getInstance());
        dbSync.addPersistenceListener((PersistenceListener)StoreSyncInterceptor.getInstance());
        dbSync.addPrePersistListener((PrePersistenceListener)ModCountPrePersistenceListener.getInstance());
    }

    private void publishServicesOverRMI() throws RemoteException {
        if (SimpleRMI.isInitialized()) {
            this.interfaceToServiceMap.put(RemoteSalesComponentUsageService.class, (PersistenceService)new SalesComponentUsageService());
            this.interfaceToServiceMap.put(PreProdManager.class, (PersistenceService)new PreProdManagerImpl());
            for (Class<? extends PersistenceService> key : this.interfaceToServiceMap.keySet()) {
                SimpleRMI.shareObject((Remote)((Remote)this.interfaceToServiceMap.get(key)), (String)key.getName());
            }
        }
    }
}

