/*
 * Decompiled with CFR 0.152.
 */
package servermate.client.rmi;

import java.rmi.RemoteException;
import java.util.Date;
import servermate.client.ServerMateClient;
import servermate.client.rmi.ServerMateEndPoint;
import servermate.client.startup.ConnectToServerMateTask;

public class ServerMateEndPointRef {
    private static ServerMateEndPoint endPoint;

    public ServerMateEndPointRef(ServerMateEndPoint theEndPoint) {
        endPoint = theEndPoint;
    }

    public static void reConnect() {
        endPoint = null;
        ConnectToServerMateTask connectToServerMateTask = new ConnectToServerMateTask();
        try {
            connectToServerMateTask.runLocal();
        }
        catch (Exception ex) {
            ServerMateClient.LOG.error("Cannot reconnnct to ServerMate", (Throwable)ex);
        }
    }

    public static String getOrderMateInfo() {
        String orderMateInfo = null;
        try {
            orderMateInfo = ServerMateEndPointRef.isEndPointValid() ? endPoint.getOrderMateInfo() : "ServerConnection is unavailable";
        }
        catch (RemoteException re) {
            re.printStackTrace();
        }
        return orderMateInfo;
    }

    private static boolean isEndPointValid() {
        if (endPoint == null) {
            ServerMateEndPointRef.reConnect();
        }
        return endPoint != null;
    }

    public static String getIPAddress() {
        String ipAddress = null;
        try {
            if (ServerMateEndPointRef.isEndPointValid()) {
                ipAddress = endPoint.getIPAddress();
            }
        }
        catch (RemoteException re) {
            ServerMateClient.LOG.error(re.getMessage(), (Throwable)re);
        }
        return ipAddress;
    }

    public static void doClearDocketCache() {
        try {
            if (ServerMateEndPointRef.isEndPointValid()) {
                endPoint.doClearDocketCache();
            }
        }
        catch (RemoteException re) {
            ServerMateClient.LOG.error(re.getMessage(), (Throwable)re);
        }
    }

    public static boolean checkDatabase() {
        try {
            if (ServerMateEndPointRef.isEndPointValid()) {
                return endPoint.checkDatabase();
            }
        }
        catch (RemoteException re) {
            ServerMateClient.LOG.error(re.getMessage(), (Throwable)re);
        }
        return false;
    }

    public static void repair() {
        try {
            if (ServerMateEndPointRef.isEndPointValid()) {
                endPoint.repair();
            }
        }
        catch (RemoteException re) {
            ServerMateClient.LOG.error(re.getMessage(), (Throwable)re);
        }
    }

    public static void optimize() {
        try {
            if (ServerMateEndPointRef.isEndPointValid()) {
                endPoint.optimize();
            }
        }
        catch (RemoteException re) {
            ServerMateClient.LOG.error(re.getMessage(), (Throwable)re);
        }
    }

    public static void shutdownServerMate() {
        try {
            if (ServerMateEndPointRef.isEndPointValid()) {
                endPoint.shutdownServerMate();
            }
        }
        catch (RemoteException re) {
            ServerMateClient.LOG.error(re.getMessage(), (Throwable)re);
        }
    }

    public static String getRecordedMacAddress() {
        String recordedMacAddress = null;
        try {
            if (ServerMateEndPointRef.isEndPointValid()) {
                recordedMacAddress = endPoint.getRecordedMacAddress();
            }
        }
        catch (RemoteException re) {
            ServerMateClient.LOG.error(re.getMessage(), (Throwable)re);
        }
        return recordedMacAddress;
    }

    public static void setRecordedMacAddress(String macAddress) {
        try {
            if (ServerMateEndPointRef.isEndPointValid()) {
                endPoint.setRecordedMacAddreses(macAddress);
            }
        }
        catch (RemoteException re) {
            ServerMateClient.LOG.error(re.getMessage(), (Throwable)re);
        }
    }

    public static void setNumWaiterMateTerminals(int waiterMateTerminals) {
        try {
            if (ServerMateEndPointRef.isEndPointValid()) {
                endPoint.setNumWaitermateTerminals(waiterMateTerminals);
            }
        }
        catch (RemoteException re) {
            ServerMateClient.LOG.error(re.getMessage(), (Throwable)re);
        }
    }

    public static int getNumWaitermateTerminals() {
        int numWaitermateTerminals = 0;
        try {
            if (ServerMateEndPointRef.isEndPointValid()) {
                numWaitermateTerminals = endPoint.getNumWaitermateTerminals();
            }
        }
        catch (RemoteException re) {
            re.printStackTrace();
        }
        return numWaitermateTerminals;
    }

    public static String getLicenseHash() {
        String licenseHash = null;
        try {
            if (ServerMateEndPointRef.isEndPointValid()) {
                licenseHash = endPoint.getLicenseHash();
            }
        }
        catch (RemoteException re) {
            re.printStackTrace();
        }
        return licenseHash;
    }

    public static void setLicenseHash(String licenseHash) {
        try {
            if (ServerMateEndPointRef.isEndPointValid()) {
                endPoint.setLicenseHash(licenseHash);
            }
        }
        catch (RemoteException re) {
            re.printStackTrace();
        }
    }

    public static Date getExpiryDate() {
        Date expiryDate = null;
        try {
            if (ServerMateEndPointRef.isEndPointValid()) {
                expiryDate = endPoint.getExpiryDate();
            }
        }
        catch (RemoteException re) {
            re.printStackTrace();
        }
        return expiryDate;
    }

    public static void setExpiryDate(Date expiryDate) {
        try {
            if (ServerMateEndPointRef.isEndPointValid()) {
                endPoint.setExpiryDate(expiryDate);
            }
        }
        catch (RemoteException re) {
            re.printStackTrace();
        }
    }

    public static Date getLastRunDate() {
        Date lastRunDate = null;
        try {
            if (ServerMateEndPointRef.isEndPointValid()) {
                lastRunDate = endPoint.getLastRunDate();
            }
        }
        catch (RemoteException re) {
            re.printStackTrace();
        }
        return lastRunDate;
    }

    public static void setLastRunDate(Date lastRunDate) {
        try {
            if (ServerMateEndPointRef.isEndPointValid()) {
                endPoint.setLastRunDate(lastRunDate);
            }
        }
        catch (RemoteException re) {
            re.printStackTrace();
        }
    }

    public static void setDBUserName(String dbUserName) {
        try {
            if (ServerMateEndPointRef.isEndPointValid()) {
                endPoint.setDBUserName(dbUserName);
            }
        }
        catch (RemoteException re) {
            re.printStackTrace();
        }
    }

    public static void setTaskInterrupt() {
        try {
            if (ServerMateEndPointRef.isEndPointValid()) {
                endPoint.setTaskInterrupter();
            }
        }
        catch (RemoteException re) {
            re.printStackTrace();
        }
    }

    public static boolean isStarted() {
        try {
            if (ServerMateEndPointRef.isEndPointValid()) {
                return endPoint.isStarted();
            }
        }
        catch (RemoteException re) {
            re.printStackTrace();
        }
        return false;
    }

    public static boolean isAlive() {
        try {
            if (ServerMateEndPointRef.isEndPointValid()) {
                return endPoint.isAlive();
            }
        }
        catch (RemoteException re) {
            ServerMateClient.LOG.warn("Cannot check is SM endpoint is alive", (Throwable)re);
            endPoint = null;
        }
        return false;
    }
}

