/*
 * Decompiled with CFR 0.152.
 */
package servermate.client.standalone;

import au.com.ordermate.configuration.Config;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.concurrent.atomic.AtomicBoolean;
import servermate.client.ServerMateClient;
import servermate.client.standalone.StandaloneClientRequestHandler;
import servermate.client.standalone.StandaloneClientRequestHandlerFactory;

public class ServermateClientStandaloneEndPoint
implements Runnable {
    private ServerSocket socket;
    private int portNumber = 59851;
    private volatile AtomicBoolean shutdownServer = new AtomicBoolean(false);
    private final String SERVERMATE_CLIENT_PORT = "servermate.client.port";

    protected void init() {
        this.portNumber = Config.getIntValue((String)"servermate.client.port");
        if (this.portNumber == 0) {
            this.portNumber = 59851;
        }
    }

    protected void createEndPoint() {
        this.init();
        try {
            this.socket = new ServerSocket(this.portNumber);
            this.socket.setReuseAddress(true);
            ServerMateClient.LOG.info("Created ServermateClient Socket on port " + this.portNumber);
        }
        catch (IOException e) {
            ServerMateClient.LOG.warn("Cannot create socket, looks like someone else is already on port " + this.portNumber, (Throwable)e);
            System.exit(0);
        }
    }

    protected ServerSocket getServerSocket() {
        return this.socket;
    }

    protected Socket acceptConnection() {
        try {
            ServerSocket runningSocket = this.getServerSocket();
            if (runningSocket != null) {
                ServerMateClient.LOG.info("Accepting incoming connection");
                Socket clientSocket = runningSocket.accept();
                ServerMateClient.LOG.info("Socket has been created for servermate messages");
                return clientSocket;
            }
            ServerMateClient.LOG.warn("Server socket not running, cannot receive events");
        }
        catch (IOException e) {
            ServerMateClient.LOG.error("Cannot accept socket", (Throwable)e);
        }
        return null;
    }

    private void startService() {
        Socket clientSocket = this.acceptConnection();
        do {
            try {
                if (clientSocket == null) {
                    ServerMateClient.LOG.error("Socket is null: Could not process local messages - will reconnect");
                    clientSocket = this.acceptConnection();
                    continue;
                }
                clientSocket.setSoTimeout(2000);
                StandaloneClientRequestHandler clientRequestHandler = StandaloneClientRequestHandlerFactory.getServermateClientRequestHandler(clientSocket);
                clientRequestHandler.handleRequest();
            }
            catch (Exception e) {
                ServerMateClient.LOG.error("Error handling servermate client socket", (Throwable)e);
                if (clientSocket == null) continue;
                try {
                    ServerMateClient.LOG.warn("Closing SM Client Standalone socket");
                    clientSocket.close();
                }
                catch (IOException ex) {
                    ServerMateClient.LOG.warn("Cannot close off stale connection", (Throwable)ex);
                }
                clientSocket = null;
            }
        } while (this.shouldContinue());
    }

    protected boolean shouldContinue() {
        return !this.shutdownServer.get();
    }

    public void shutdown() {
        this.shutdownServer.set(true);
        try {
            if (this.socket != null) {
                this.socket.close();
            }
        }
        catch (IOException e) {
            ServerMateClient.LOG.error((Object)e);
        }
    }

    @Override
    public void run() {
        try {
            this.createEndPoint();
            this.startService();
        }
        catch (Throwable th) {
            ServerMateClient.LOG.error((Object)th);
        }
    }
}

