/*
 * Decompiled with CFR 0.152.
 */
package servermate.client.standalone;

import java.io.ObjectInputStream;
import java.net.Socket;
import ordermate.OrderMate;
import servermate.client.ServerMateClient;
import servermate.client.events.StartupCompleteEventHandler;
import servermate.events.LicenseExpiredEventHandler;
import servermate.events.LicenseSuccessHandler;
import servermate.events.ServerMateEvent;
import servermate.events.ServerMateEventType;
import servermate.events.TerminalNotSetupEventHandler;

public class StandaloneClientRequestHandler {
    private Socket clientSocket;
    private ServerMateEvent currentRequest;

    StandaloneClientRequestHandler() {
    }

    public StandaloneClientRequestHandler(Socket socket) {
        this.clientSocket = socket;
    }

    protected Object readRequest() throws Exception {
        ObjectInputStream input = new ObjectInputStream(this.clientSocket.getInputStream());
        Object readObject = input.readObject();
        return readObject;
    }

    public void handleRequest() throws Exception {
        this.currentRequest = (ServerMateEvent)this.readRequest();
        OrderMate.LOG.info("Incoming Request:" + this.currentRequest);
        if (this.currentRequest != null) {
            this.processRequest(this.currentRequest);
        }
    }

    private void processRequest(ServerMateEvent request) {
        if (ServerMateEventType.TERMINAL_NOT_SETUP.equals((Object)request.getEventType())) {
            new TerminalNotSetupEventHandler();
        } else if (ServerMateEventType.LICENSE_EXPIRED.equals((Object)request.getEventType())) {
            new LicenseExpiredEventHandler(request);
        } else if (ServerMateEventType.LICENSE_SUCCESSFUL.equals((Object)request.getEventType())) {
            new LicenseSuccessHandler();
        } else if (ServerMateEventType.BAD_MAC.equals((Object)request.getEventType())) {
            new LicenseExpiredEventHandler(request);
        } else if (ServerMateEventType.STARTUP_COMPLETE.equals((Object)request.getEventType())) {
            new StartupCompleteEventHandler();
        } else {
            ServerMateClient.LOG.warn("Unable to process request: Handler not present : " + request.getTaskName());
        }
    }

    public ServerMateEvent getCurrentRequest() {
        return this.currentRequest;
    }
}

