/*
 * Decompiled with CFR 0.152.
 */
package servermate.client.startup;

import au.com.ordermate.configuration.Config;
import au.com.ordermate.guicore.task.AbstractTask;
import au.com.ordermate.simplermi.SimpleRMI;
import java.net.InetAddress;
import java.util.Iterator;
import java.util.List;
import servermate.client.ServerMateClient;
import servermate.client.ServerMateClientEndPoint;
import servermate.client.gui.ServerMateClientGUI;
import servermate.client.rmi.ServerMateEndPoint;
import servermate.client.rmi.ServerMateEndPointRef;
import servermate.client.rmi.ServerMateRMIClient;
import servermate.client.rmi.ServerMateRMIClientImpl;
import servermate.events.ServerMateEventProcessor;

public class ConnectToServerMateTask
extends AbstractTask {
    private final ServerMateRMIClient eventListener;
    private static ConnectToServerMateTask instance;
    private boolean offThread = true;
    private static final int NOTIFY_COUNT = 10;
    private static final int SLEEP = 1000;

    public ConnectToServerMateTask() {
        this(true);
    }

    public ConnectToServerMateTask(boolean runInNewThread) {
        this.offThread = runInNewThread;
        this.eventListener = ServerMateClientEndPoint.getClient();
    }

    protected int getTotalSubTasks() {
        return 0;
    }

    public String getName() {
        return "Connect To ServerMate";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void performTask() throws Exception {
        Class<ConnectToServerMateTask> clazz = ConnectToServerMateTask.class;
        synchronized (ConnectToServerMateTask.class) {
            if (instance != null) {
                ServerMateClient.LOG.warn("Already an instance of ConnectToServerMate, will not run");
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            instance = this;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            if (this.offThread) {
                ServerMateClient.LOG.info("Running Connection to Server off thread");
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        ConnectToServerMateTask.this.startConnectionThread();
                    }
                };
                new Thread(runnable, "Connect To ServerMate").start();
            } else {
                ServerMateClient.LOG.info("Running Connection to Server on thread");
                this.startConnectionThread();
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startConnectionThread() {
        try {
            List app_servers = Config.getStringListValue((String)"app_server");
            ServerMateClient.LOG.info("The ipAddress list of server is : " + app_servers);
            int attemptCount = 1;
            ServerMateRMIClientImpl serverMateRMIClient = new ServerMateRMIClientImpl(new ServerMateEventProcessor());
            ServerMateEndPoint serverMateEndPoint = null;
            while (serverMateEndPoint == null) {
                Thread.sleep(1000L);
                Iterator iterator = app_servers.iterator();
                while (iterator.hasNext()) {
                    String app_server = (String)iterator.next();
                    try {
                        InetAddress serverMateAddress = InetAddress.getByName(app_server);
                        ServerMateClient.LOG.info("Attempting connection to Servermate IPAddress : " + serverMateAddress.getHostAddress());
                        serverMateEndPoint = (ServerMateEndPoint)SimpleRMI.getObject((InetAddress)serverMateAddress, (String)"SERVERMATE_ENDPOINT", (int)11100);
                        serverMateEndPoint.addServerMateClient(serverMateRMIClient);
                        new ServerMateEndPointRef(serverMateEndPoint);
                        ServerMateClient.LOG.info("Successfully connected to Servermate IPAddress : " + serverMateAddress.getHostAddress());
                        break;
                    }
                    catch (Exception ex) {
                        ServerMateClient.LOG.info("Failed to connect to server for " + attemptCount + " time(s)");
                    }
                }
                if (++attemptCount % 10 != 0) continue;
                ServerMateClientGUI.getInstance().showMessageDialog("Please check whether Servermate is running", "Check Servermate");
            }
            ServerMateClientGUI.getInstance().hideConnectionInterface();
        }
        catch (Exception ex) {
            ServerMateClient.LOG.error("Unable to connect to ServerMate", (Throwable)ex);
        }
        finally {
            Class<ConnectToServerMateTask> clazz = ConnectToServerMateTask.class;
            synchronized (ConnectToServerMateTask.class) {
                instance = null;
                // ** MonitorExit[var1_3] (shouldn't be in output)
            }
        }
    }
}

