/*
 * Decompiled with CFR 0.152.
 */
package servermate.events;

import au.com.ordermate.persistence.PersistenceManager;
import javax.swing.SwingUtilities;
import servermate.client.ServerMateClient;
import servermate.client.gui.ServerMateClientGUI;
import servermate.client.security.RMISecurityDetails;
import servermate.client.standalone.TaskBarMessage;
import servermate.events.ServerMateEvent;
import servermate.events.ServerMateEventType;
import servermate.gui.ServerMateFrame;
import servermate.gui.license.ServermateLicenseDialog;

public class LicenseExpiredEventHandler
implements Runnable {
    private final ServerMateEvent event;

    public LicenseExpiredEventHandler(ServerMateEvent event) {
        this.event = event;
        this.handleEvent();
    }

    private void handleEvent() {
        SwingUtilities.invokeLater(this);
    }

    @Override
    public void run() {
        try {
            String toShow;
            if (ServerMateEventType.BAD_MAC.equals((Object)this.event.getEventType())) {
                toShow = "MAC Address is Invalid.";
                toShow = toShow + "\r\nPlease fix it within " + this.event.getProgress() + " minutes using DongleMate & LicenseDialog";
            } else {
                toShow = "Licensing is invalid in Servermate.";
                toShow = this.event != null ? (this.event.getProgress() == 0 ? toShow + "\r\nServerMate is shutting down!" : toShow + "\r\nServerMate will shut down in " + this.event.getProgress() + " minutes") : toShow + "\r\nPlease fix it using DongleMate & LicenseDialog";
            }
            TaskBarMessage.showError(toShow);
            if (PersistenceManager.isPersistenceSetup()) {
                RMISecurityDetails securityDetails = new RMISecurityDetails();
                ServermateLicenseDialog servermateLicenseDialog = ServermateLicenseDialog.getLicenseDialog(securityDetails);
                ServerMateClient.LOG.info("ServermateLicenseDialog :: " + servermateLicenseDialog.isVisible());
                if (!servermateLicenseDialog.isVisible()) {
                    ServerMateFrame.softwareLicense(null, null);
                }
            }
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            ServerMateClient.LOG.error(noClassDefFoundError.getMessage(), (Throwable)noClassDefFoundError);
            ServerMateClientGUI.getInstance().showMessageDialog("License is invalid. Set up a valid license.", "Invalid License");
        }
        catch (ExceptionInInitializerError initializerError) {
            ServerMateClient.LOG.error(initializerError.getMessage(), (Throwable)initializerError);
            ServerMateClientGUI.getInstance().showMessageDialog("License is invalid. Set up a valid license.", "Invalid License");
        }
    }
}

