/*
 * Decompiled with CFR 0.152.
 */
package servermate.events;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.net.Socket;
import java.net.UnknownHostException;
import servermate.client.ServerMateClient;
import servermate.events.ServerMateEvent;

public class LocalEventSender
implements Runnable {
    private final ServerMateEvent event;
    private Socket socket;

    public LocalEventSender(ServerMateEvent event) {
        this.event = event;
    }

    public ServerMateEvent getEvent() {
        return this.event;
    }

    @Override
    public void run() {
        this.sendEvent();
    }

    protected Socket getSocket() {
        try {
            this.socket = new Socket("localhost", 59851);
        }
        catch (UnknownHostException uhe) {
            ServerMateClient.LOG.error("Cannot resolve local host for event", (Throwable)uhe);
        }
        catch (IOException e) {
            ServerMateClient.LOG.error("Problem sending local event", (Throwable)e);
        }
        return this.socket;
    }

    private void sendEvent() {
        this.socket = this.getSocket();
        if (this.socket != null) {
            this.sendMessage();
            this.closeSocket();
        }
    }

    private void closeSocket() {
        try {
            this.socket.close();
        }
        catch (IOException e) {
            ServerMateClient.LOG.error((Object)e);
        }
    }

    private void sendMessage() {
        try {
            ObjectOutputStream output = new ObjectOutputStream(this.socket.getOutputStream());
            output.writeObject(this.event);
            output.flush();
            output.close();
        }
        catch (IOException e) {
            ServerMateClient.LOG.error((Object)e);
        }
    }
}

