/*
 * Decompiled with CFR 0.152.
 */
package servermate.events;

import java.rmi.RemoteException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import ordermate.OrderMate;
import servermate.client.rmi.ServerMateRMIClient;
import servermate.client.rmi.ServerMateRMIClientHandler;
import servermate.events.ServerMateEvent;
import servermate.events.ServerMateEventPublish;

public class ServerMateEventPublishImpl
implements ServerMateEventPublish {
    private ServerMateRMIClientHandler handler;
    private ExecutorService executorService;

    public ServerMateEventPublishImpl(ServerMateRMIClientHandler handler) {
        this.handler = handler;
        this.executorService = Executors.newSingleThreadExecutor();
    }

    @Override
    public void publishEvent(final ServerMateEvent event) {
        Runnable job = new Runnable(){

            @Override
            public void run() {
                for (ServerMateRMIClient listener : ServerMateEventPublishImpl.this.handler.getServerMateRMIClients()) {
                    try {
                        listener.eventReceived(event);
                    }
                    catch (RemoteException re) {
                        OrderMate.LOG.error(re.getMessage(), (Throwable)re);
                    }
                }
            }
        };
        this.executorService.submit(job);
    }

    public void shutdown() {
        if (this.executorService != null) {
            this.executorService.shutdown();
        }
    }
}

