/*
 * Decompiled with CFR 0.152.
 */
package servermate.events;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import ordermate.OrderMate;
import servermate.events.LocalEventPublisher;
import servermate.events.ServerMateEvent;
import servermate.events.ServerMateEventPublish;
import servermate.events.ServerMateEventPublishImpl;

public class ServerMateEventPublisher {
    private static ServerMateEventPublish publish;
    private static LocalEventPublisher localEventPublisher;
    private static ExecutorService singleThreadPoolExecutor;

    static void setServerMateEventPublish(ServerMateEventPublish thePublish) {
        publish = thePublish;
    }

    static void setLocalEventPublisher(LocalEventPublisher localPublisher) {
        localEventPublisher = localPublisher;
    }

    public static void publishEvent(final ServerMateEvent event) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    if (publish != null) {
                        OrderMate.LOG.info("Publishing event " + event);
                        publish.publishEvent(event);
                    } else {
                        OrderMate.LOG.warn("Publisher for event not set, cannot publish " + event);
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        };
        singleThreadPoolExecutor.submit(runnable);
    }

    public static void shutdown() {
        if (publish instanceof ServerMateEventPublishImpl) {
            ((ServerMateEventPublishImpl)publish).shutdown();
        }
    }

    public static void publishLocalEvent(ServerMateEvent event) {
        if (localEventPublisher != null) {
            OrderMate.LOG.info("Publishing LOCAL event " + event);
            localEventPublisher.publishLocalEvent(event);
        }
    }

    static {
        singleThreadPoolExecutor = Executors.newSingleThreadExecutor();
    }
}

