/*
 * Decompiled with CFR 0.152.
 */
package servermate.failover;

import au.com.ordermate.guicore.task.Task;
import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.util.IPAddressUtils;
import java.awt.Color;
import java.awt.Frame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Semaphore;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import ordermate.OrderMate;
import ordermate.database.UpdateConfigExecutable;
import ordermate.database.UpdateJnlpExecutable;
import ordermate.database.failover.FailoverSetup;
import ordermate.database.hardware.Terminal;
import ordermate.database.misc.application.Application;
import ordermate.database.users.AllPermissions;
import ordermate.database.users.User;
import ordermate.gui.dialogs.LoginDialog;
import ordermate.gui.dialogs.ProgressDialog;
import servermate.events.ServerMateEvent;
import servermate.events.ServerMateEventPublisher;
import servermate.events.ServerMateEventType;
import servermate.failover.FailoverFrame;
import servermate.failover.FailoverServerSocket;
import servermate.failover.FailoverStatusChecker;
import servermate.failover.FailoverWorker;
import servermate.failover.SocketHelper;
import servermate.failover.UpdateAddressTask;
import servermate.failover.UpdateFailoverDate;
import servermate.failover.configure.ConfigureFailoverMaster;
import servermate.failover.configure.ConfigureFailoverSlave;
import servermate.failover.handback.FailoverHandback;
import servermate.failover.handover.FailoverHandoverProcess;
import servermate.failover.pushpull.PullWebstartTask;
import servermate.failover.pushpull.RelaunchServermateTask;

public class FailoverManager {
    static final int POKE_TIMEOUT = 2000;
    static final String SLAVE_ID = "SLAVE:";
    static final String TERMINAL_SETUP = "Terminal Setup";
    private static FailoverManager instance;
    private String currentServer;
    private Semaphore talkingStick = new Semaphore(1);
    private Map<Terminal, Date> pokeMap = new LinkedHashMap<Terminal, Date>();
    private FailoverSetup setup;
    private FailoverWorker worker;
    private FailoverServerSocket serverSocket;
    private FailoverFrame setupFrame;

    public static synchronized FailoverManager getInstance() {
        return instance;
    }

    public static FailoverSetup getInstanceSetup() {
        FailoverManager.init();
        return FailoverManager.getInstance().getSetup();
    }

    public static synchronized void init() {
        if (instance == null) {
            instance = new FailoverManager();
        }
    }

    private FailoverManager() {
        Terminal terminal = Terminal.getMatchingTerminal((List)IPAddressUtils.getLocalAddresses(), (String)"ServerMate");
        OrderMate.LOG.info("Terminal: " + terminal);
        ObjectQuery query = Query.select(FailoverSetup.class).active(FailoverSetup.class).equals(FailoverSetup.Properties.TERMINAL, (Object)terminal);
        try {
            this.setup = (FailoverSetup)PersistenceManager.getObject(FailoverSetup.class, (String)query.toString(), null);
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Cannot retrieve FailoverSetup:", (Throwable)ex);
        }
        if (this.setup == null) {
            OrderMate.LOG.error("Cannot setup failover, this terminal is not set up.");
            ServerMateEventPublisher.publishLocalEvent(new ServerMateEvent(ServerMateEventType.TERMINAL_NOT_SETUP, TERMINAL_SETUP, 0));
            throw new IllegalStateException("Cannot setup failover, this terminal is not set up.");
        }
        if (this.setup.isSlave() && this.setup.isActingMaster()) {
            OrderMate.LOG.info("Starting up Failover: Slave acting as Master");
        } else if (this.setup.isSlave()) {
            this.currentServer = this.setup.getMasterHost();
            OrderMate.LOG.info("Starting up Failover as Slave");
            if (this.setup.isSlave()) {
                TimerTask task = new TimerTask(){

                    @Override
                    public void run() {
                        FailoverStatusChecker checker = new FailoverStatusChecker();
                        String status = checker.checkStatus();
                        if (status != null) {
                            FailoverManager.getInstance().pushText(status, true, Color.RED);
                        }
                    }
                };
                Timer timer = new Timer();
                timer.schedule(task, 30000L, 600000L);
            }
        } else {
            OrderMate.LOG.info("Starting up Failover as Master");
        }
        this.startCommunication();
    }

    public void stopCommunication() {
        if (this.worker != null) {
            this.worker.stop();
            this.worker = null;
        }
        if (this.serverSocket != null) {
            this.serverSocket.stop();
            this.serverSocket = null;
        }
    }

    public void startCommunication() {
        this.stopCommunication();
        if (this.setup.isSlave() && this.setup.isActingMaster()) {
            this.serverSocket = new FailoverServerSocket(this);
            this.serverSocket.start();
        } else if (this.setup.isSlave()) {
            this.worker = new FailoverWorker();
            this.worker.start();
            ConfigureFailoverSlave config = new ConfigureFailoverSlave(this, this.setupFrame);
            config.updateSlave();
        } else {
            this.serverSocket = new FailoverServerSocket(this);
            this.serverSocket.start();
        }
    }

    public FailoverSetup getSetup() {
        return this.setup;
    }

    void pokeMaster() {
        int port = this.setup.getMasterPort();
        if (port >= 64556 || port < 255) {
            OrderMate.LOG.warn("Cannot access port:" + port + ", using default of " + 11107);
            port = 11107;
        }
        boolean fail = false;
        try {
            InetAddress address = Inet4Address.getByName(this.currentServer);
            fail = !address.isReachable(2000);
        }
        catch (Exception e) {
            OrderMate.LOG.warn("Cannot find Master's terminal.", (Throwable)e);
            fail = true;
        }
        if (!fail) {
            SocketHelper helper = new SocketHelper(this.currentServer, port);
            helper.reconnect();
            if (!helper.isValid()) {
                OrderMate.LOG.warn("Cannot contact Server on :" + this.currentServer + " asking for Failover.");
                helper.closeOff();
                fail = true;
            } else {
                if (this.setupFrame != null && this.setupFrame.isShowing()) {
                    this.setupFrame.doCanConnect();
                }
                helper.sendMessage(SLAVE_ID + this.setup.getTerminal().getID());
                String response = helper.receiveMessage();
                if (!this.isConnectedToRealMaster() && response.contains("Version:")) {
                    String masterVersion = response.substring("Version:".length());
                    OrderMate.LOG.info("Got Master Version:" + masterVersion);
                    if (!masterVersion.equals(OrderMate.VERSION)) {
                        OrderMate.LOG.info("Does not match my version of :" + OrderMate.VERSION);
                        this.doTask((Task)new PullWebstartTask(this.setup.getMasterHost(), this.setup.getMasterPort()));
                        this.doTask((Task)new RelaunchServermateTask(this.setupFrame));
                    }
                }
                helper.closeOff();
            }
        }
        if (fail) {
            this.doCannotConnect();
        }
    }

    public boolean isConnectedToRealMaster() {
        return this.setup.getMasterHost().equals(this.currentServer);
    }

    private void doCannotConnect() {
        ObjectQuery query = Query.select(FailoverSetup.class).active(FailoverSetup.class).equals(FailoverSetup.Properties.SLAVE, (Object)"1").orderBy(FailoverSetup.Properties.SEQUENCE);
        List setups = PersistenceManager.getObjectList(FailoverSetup.class, (String)query.toString());
        boolean found = false;
        for (FailoverSetup nextSetup : setups) {
            if (this.setup.equals((Object)nextSetup)) continue;
            String ip = nextSetup.getTerminal().getIPAddress();
            SocketHelper helper = new SocketHelper(ip, nextSetup.getMasterPort());
            helper.reconnect();
            if (helper.isValid()) {
                found = true;
                this.currentServer = ip;
                helper.closeOff();
                break;
            }
            helper.closeOff();
        }
        if (!found) {
            this.showRequestRedundancy();
        }
    }

    private void showRequestRedundancy() {
        OrderMate.LOG.info("Cannot see Master, requesting redundancy.");
        this.pushText("Cannot see Master", true, Color.RED);
        this.setupFrame.askToFailover();
    }

    public synchronized void setupMaster() {
        if (this.acquireLock()) {
            ConfigureFailoverMaster config = new ConfigureFailoverMaster(this, this.setupFrame);
            config.configureMaster();
        }
    }

    public synchronized void setupSlave() {
        if (this.acquireLock()) {
            ConfigureFailoverSlave config = new ConfigureFailoverSlave(this, this.setupFrame);
            config.configureSlave();
        }
    }

    public synchronized boolean acquireLock() {
        if (this.talkingStick.tryAcquire()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (FailoverManager.this.setupFrame != null) {
                        FailoverManager.this.setupFrame.managerBusy(true);
                    }
                }
            });
            return true;
        }
        return false;
    }

    public void finished() {
        this.talkingStick.release();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (FailoverManager.this.setupFrame != null) {
                    FailoverManager.this.setupFrame.managerBusy(false);
                }
            }
        });
    }

    void hideSetupFrame() {
        if (this.setupFrame != null) {
            this.setupFrame.setVisible(false);
            this.setupFrame.dispose();
            this.setupFrame = null;
        }
    }

    private void showSetupFrame(boolean withSetup) {
        if (this.setupFrame == null) {
            this.setupFrame = new FailoverFrame(this);
            this.setupFrame.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    FailoverManager.this.hideSetupFrame();
                }
            });
        }
        this.setupFrame.updateTableModel(this.pokeMap);
        this.setupFrame.setVisible(true);
        if (1 == this.setupFrame.getState()) {
            this.setupFrame.setExtendedState(0);
        }
        this.setupFrame.toFront();
        this.setupFrame.pack();
    }

    public void setupFailover() {
        User user;
        if (!(this.setupFrame != null && this.setupFrame.isVisible() || (user = LoginDialog.getLogin((Frame)this.setupFrame, (List)User.getUsers(), (String)"This action requires login", (String)"Cancel")) == null)) {
            boolean canSetup = user.getPermissionGroup().hasPermission(AllPermissions.ACCESS_PERMISSIONS_SCREEN);
            OrderMate.LOG.info("User accessing failover setup, with setup option:" + canSetup);
            this.showSetupFrame(canSetup);
        }
    }

    public boolean staleSlave() {
        UpdateFailoverDate updater = new UpdateFailoverDate(this);
        return updater.doUpdate();
    }

    void doFailover() {
        this.stopCommunication();
        this.acquireLock();
        OrderMate.LOG.info("Failover Requested.");
        this.pushText("Doing Failover...", true, Color.RED);
        FailoverHandoverProcess process = new FailoverHandoverProcess(this);
        process.begin();
        this.finished();
        this.startCommunication();
        this.hideSetupFrame();
        this.pushText("Failover Completed: Acting as Master", true, Color.ORANGE);
    }

    public void doHandback() {
        if (this.setup.isSlave() && this.setup.isActingMaster()) {
            OrderMate.LOG.info("User has opted to handback to original master.");
            this.stopCommunication();
            this.acquireLock();
            FailoverHandback process = new FailoverHandback(this);
            process.begin();
            this.finished();
            this.startCommunication();
        } else {
            OrderMate.LOG.warn("Cannot handback if I am not a Slave Acting as a Master.");
        }
    }

    boolean containsSlave(Terminal terminal) {
        return this.pokeMap.containsKey(terminal);
    }

    void slavePokedYou(Terminal terminal) {
        this.pokeMap.put(terminal, new Date());
        if (this.setupFrame != null && this.setupFrame.isShowing()) {
            this.setupFrame.updateTableModel(this.pokeMap);
        }
    }

    public void pushText(String string, boolean shouldShow, Color colour) {
        if (shouldShow) {
            this.showSetupFrame(false);
        }
        if (this.setupFrame != null) {
            this.setupFrame.pushText(string, colour);
        }
    }

    public void pullWebstartFromMaster() {
        if (this.acquireLock()) {
            StringBuilder SB = new StringBuilder("<html>This will pull in the jars and jnlps from<br>").append("the Master to this Slave.<br>This may take some time depending on your<br>").append("network connection.<br>Do not stop either Master or Slave during this process.<br><br>").append("<b>Are you sure you wish to proceed?</b></html>");
            if (JOptionPane.showConfirmDialog(this.setupFrame, SB.toString()) == 0) {
                OrderMate.LOG.info("Requesting Webstart from Master");
                this.doTask((Task)new PullWebstartTask(this.setup.getMasterHost(), this.setup.getMasterPort()));
            }
            this.doTask((Task)new UpdateAddressTask());
            this.finished();
        }
    }

    public void doTask(final Task task) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                FailoverManager.this.showSetupFrame(true);
                ProgressDialog progress = new ProgressDialog((Frame)FailoverManager.this.setupFrame, true, task);
                progress.start();
            }
        });
    }

    void updateConfigs() {
        StringBuilder SB = new StringBuilder("app_server=");
        for (FailoverSetup nextSetup : PersistenceManager.getObjectList(FailoverSetup.class, (String)Query.select(FailoverSetup.class).active(FailoverSetup.class).orderBy(FailoverSetup.Properties.SLAVE).orderBy(FailoverSetup.Properties.SEQUENCE).toString())) {
            SB.append(nextSetup.getTerminal().getIPAddress()).append(",");
        }
        SB.replace(SB.length() - 1, SB.length(), "\r\n");
        UpdateConfigExecutable exec = new UpdateConfigExecutable(new Application[]{Application.Waitermate, Application.Officemate, Application.TouchPrepXPress}, "app_server=", SB.toString());
        exec.execute();
        try {
            InetAddress local = InetAddress.getLocalHost();
            String dbServer = "database_server=localhost\r\n";
            String appServer = "app_server=" + local.getHostAddress() + "\r\n";
            exec = new UpdateConfigExecutable(new Application[]{Application.Servermate}, "app_server=", appServer);
            exec.execute();
            exec = new UpdateConfigExecutable(new Application[]{Application.Servermate}, "database_server=", dbServer);
            exec.execute();
        }
        catch (UnknownHostException ex) {
            OrderMate.LOG.error("Cannot update the servermate config, unknown local ip", (Throwable)ex);
        }
    }

    void updateJnlpFiles() {
        try {
            InetAddress local = InetAddress.getLocalHost();
            String codeBase = "codebase=\"http://" + local.getHostAddress() + "/WebStart\"";
            UpdateJnlpExecutable exec = new UpdateJnlpExecutable(new Application[]{Application.Waitermate, Application.Servermate, Application.Officemate, Application.TouchPrepXPress}, "codebase=", codeBase);
            exec.execute();
        }
        catch (UnknownHostException ex) {
            OrderMate.LOG.error("Cannot update the jnlp, unknown host name.", (Throwable)ex);
        }
    }

    public void updateAllIpReferencesInWebStart() {
        this.updateConfigs();
        this.updateJnlpFiles();
    }
}

