/*
 * Decompiled with CFR 0.152.
 */
package servermate.failover;

import au.com.ordermate.util.Pair;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import servermate.failover.FailoverManager;

abstract class FailoverPanel
extends JPanel {
    Signal setupSlave = Signals.createSignal();
    private JPanel centrePanel;
    private JPanel buttonHolder;
    protected JButton setupSlaveButton;
    protected FailoverManager manager;

    FailoverPanel(FailoverManager yourManager) {
        super(new BorderLayout());
        this.manager = yourManager;
        this.connectSignals();
        this.setupComponents();
        this.setPreferredSize(new Dimension(400, 300));
    }

    protected void setupComponents() {
        this.centrePanel = new JPanel(new BorderLayout());
        this.add((Component)this.centrePanel, "Center");
        this.buttonHolder = new JPanel();
        this.buttonHolder.setLayout(new BoxLayout(this.buttonHolder, 1));
        this.setupButtons(this.buttonHolder);
        this.add((Component)this.buttonHolder, "South");
    }

    protected JPanel getCentrePanel() {
        return this.centrePanel;
    }

    protected JPanel getButtonHolder() {
        return this.buttonHolder;
    }

    protected void setupButtons(JPanel holder) {
        this.setupSlaveButton = this.makeButton("Setup Slave", this.setupSlave);
        holder.add(this.setupSlaveButton);
    }

    protected JButton makeButton(String name, Signal signal) {
        JButton button = new JButton(name);
        button.addActionListener(Signals.createActionListener((Signal)signal));
        return button;
    }

    void connectSignals() {
        this.setupSlave.connect((Object)this.manager, "setupSlave");
    }

    void disconnectSignals() {
        this.setupSlave.disconnect((Object)this.manager);
    }

    public void setButtonsEnabled(boolean b) {
        this.setupSlaveButton.setEnabled(b);
    }

    public abstract Pair<String, Color> getStatus();

    public abstract String getTitle();

    public abstract void askToFailover();

    public abstract boolean canConnect();
}

