/*
 * Decompiled with CFR 0.152.
 */
package servermate.failover;

import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Semaphore;
import servermate.failover.FailoverManager;

class FailoverWorker {
    private long DELAY = 5000L;
    private Timer timer;
    private Semaphore talkingStick = new Semaphore(1);

    FailoverWorker() {
    }

    void start() {
        this.stop();
        this.timer = new Timer();
        this.timer.schedule(this.createTask(), this.DELAY, this.DELAY);
    }

    void stop() {
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
    }

    private TimerTask createTask() {
        TimerTask task = new TimerTask(){

            @Override
            public void run() {
                FailoverWorker.this.pollServermate();
            }
        };
        return task;
    }

    private void pollServermate() {
        if (this.talkingStick.tryAcquire()) {
            FailoverManager.getInstance().pokeMaster();
            this.talkingStick.release();
        }
    }
}

