/*
 * Decompiled with CFR 0.152.
 */
package servermate.failover;

import au.com.ordermate.util.Pair;
import java.awt.Color;
import java.awt.Component;
import java.util.Date;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableModel;
import ordermate.database.hardware.Terminal;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import servermate.failover.FailoverManager;
import servermate.failover.FailoverPanel;

class MasterPanel
extends FailoverPanel {
    private static final String TITLE = "Servermate Master";
    Signal setupMaster;
    Signal updateConfigs;
    private JTable pokeTable;
    private DefaultTableModel pokeModel;
    private JButton setupMasterButton;
    private JButton updateConfigsButton;

    public MasterPanel(FailoverManager manager) {
        super(manager);
    }

    @Override
    protected void setupComponents() {
        super.setupComponents();
        this.setupTable();
    }

    @Override
    protected void setupButtons(JPanel holder) {
        super.setupButtons(holder);
        holder.add(new JSeparator());
        this.setupMasterButton = this.makeButton("Setup Master...", this.setupMaster);
        holder.add(this.setupMasterButton);
        this.updateConfigsButton = this.makeButton("Update Configs", this.updateConfigs);
        holder.add(this.updateConfigsButton);
    }

    @Override
    public void setButtonsEnabled(boolean b) {
        super.setButtonsEnabled(b);
        this.setupMasterButton.setEnabled(b);
        this.updateConfigsButton.setEnabled(b);
    }

    @Override
    void connectSignals() {
        super.connectSignals();
        this.setupMaster = Signals.createSignal();
        this.updateConfigs = Signals.createSignal();
        this.setupMaster.connect((Object)this.manager, "setupMaster");
        this.updateConfigs.connect((Object)this.manager, "updateAllIpReferencesInWebStart");
    }

    @Override
    void disconnectSignals() {
        super.disconnectSignals();
        this.setupMaster.disconnect((Object)this.manager);
        this.updateConfigs.disconnect((Object)this.manager);
    }

    private void setupTable() {
        this.pokeModel = new DefaultTableModel(new String[]{"Terminal", "IP", "Date"}, 0){

            @Override
            public boolean isCellEditable(int row, int col) {
                return false;
            }
        };
        this.pokeTable = new JTable(this.pokeModel);
        this.getCentrePanel().add((Component)new JScrollPane(this.pokeTable), "Center");
    }

    void updateTableModel(Map<Terminal, Date> update) {
        if (this.pokeModel == null) {
            return;
        }
        this.pokeModel.setRowCount(0);
        for (Terminal terminal : update.keySet()) {
            this.pokeModel.addRow(new Object[]{terminal.getID(), terminal.getName(), update.get(terminal)});
        }
        final JPanel panel = this.getCentrePanel();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MasterPanel.this.pokeModel.fireTableDataChanged();
                MasterPanel.this.pokeTable.invalidate();
                panel.validate();
                panel.repaint();
            }
        });
    }

    @Override
    public Pair<String, Color> getStatus() {
        return new Pair((Object)"OrderMate Master", (Object)Color.GREEN);
    }

    @Override
    public String getTitle() {
        return TITLE;
    }

    @Override
    public void askToFailover() {
    }

    @Override
    public boolean canConnect() {
        return false;
    }
}

