/*
 * Decompiled with CFR 0.152.
 */
package servermate.failover.configure;

import java.io.File;
import java.sql.SQLException;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import ordermate.OrderMate;
import ordermate.database.failover.FailoverSetup;
import ordermate.dbconnection.DatabaseControl;
import servermate.failover.FailoverManager;
import servermate.failover.configure.ConfigureHelper;

public class ConfigureFailoverMaster {
    private FailoverManager parent;
    private JFrame frame;
    private ConfigureHelper helper;

    public ConfigureFailoverMaster(FailoverManager yourParent, JFrame owningFrame) {
        this.parent = yourParent;
        this.helper = new ConfigureHelper(owningFrame);
    }

    public void configureMaster() {
        if (!this.showWarning()) {
            this.finish();
            return;
        }
        FailoverSetup setup = this.parent.getSetup();
        setup.endFailover();
        setup.setSlave(false);
        setup.setActingMaster(true);
        setup.save();
        this.resetMaster();
        final File myIni = this.helper.getMyIniFile();
        if (myIni == null || !myIni.exists()) {
            this.finish();
            return;
        }
        new Thread(new Runnable(){

            @Override
            public void run() {
                ConfigureFailoverMaster.this.doChangeover(myIni);
                ConfigureFailoverMaster.this.finish();
            }
        }).start();
    }

    private boolean showWarning() {
        StringBuilder SB = new StringBuilder("<html>");
        SB.append("<h1 color='red'> WARNING </h1>").append("You are about to set this machine's database as a Master database.<br>").append("This should only be performed on the primary ServerMate,<br>").append("and only by a trained OrderMate technician.<br>").append("You will need to restart MySQL for this change to take effect.<br><br>").append("If you are unsure, contact OrderMate.<br><br>").append("<b>Are you sure you wish to proceed?</b></html>");
        return JOptionPane.showConfirmDialog(this.frame, SB.toString(), "Confirm Configure Master", 0) == 0;
    }

    private void resetMaster() {
        DatabaseControl dc = new DatabaseControl(true);
        try {
            dc.execute("RESET MASTER");
        }
        catch (SQLException ex) {
            OrderMate.LOG.error("Cannot stop the master!", (Throwable)ex);
        }
        dc.closeConnection();
    }

    private void doChangeover(File iniFile) {
        String text = this.helper.readInFile(iniFile);
        if (text == null || text.trim().isEmpty()) {
            this.helper.showMessage("Problem modifying the my.ini file, see logs.");
            return;
        }
        text = this.modifyText(text);
        this.helper.writeOutFile(text, iniFile);
    }

    protected String modifyText(String iniFileText) {
        String[] splits = iniFileText.split("\\[mysqld\\]");
        if (splits.length != 2) {
            OrderMate.LOG.error("My ini file has no [mysqld] section, or multiple.");
            return null;
        }
        String firstSplit = splits[0];
        String secondSplit = splits[1];
        if (!secondSplit.contains("server-id")) {
            secondSplit = "\r\nserver-id=1" + secondSplit;
        }
        if (!secondSplit.contains("binlog_do_db")) {
            secondSplit = "\r\nbinlog_do_db=ordermate_prod" + secondSplit;
        }
        if (!secondSplit.contains("log-bin")) {
            secondSplit = "\r\nlog-bin=mysql-bin" + secondSplit;
        }
        return firstSplit + "[mysqld]" + secondSplit;
    }

    private void finish() {
        this.parent.finished();
    }
}

