/*
 * Decompiled with CFR 0.152.
 */
package servermate.failover.configure;

import au.com.ordermate.configuration.Config;
import au.com.ordermate.guicore.task.AbstractTask;
import au.com.ordermate.guicore.task.Task;
import java.awt.Frame;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import ordermate.OrderMate;
import ordermate.database.failover.FailoverSetup;
import ordermate.dbconnection.DatabaseControl;
import ordermate.gui.dialogs.ProgressDialog;
import servermate.failover.FailoverManager;
import servermate.failover.SocketHelper;
import servermate.failover.configure.ConfigureHelper;
import servermate.failover.configure.MasterLocationDetails;
import servermate.failover.pushpull.RelaunchServermateTask;

public class ConfigureFailoverSlave {
    static final String MASTER_SQL_FILE = "c:\\temp\\master_data.sql";
    public static final String MASTER_LOG = "LOG_FILE=";
    public static final String MASTER_POS = "LOG_POS=";
    public static final String MASTER_USER = "DB_USER=";
    public static final String MASTER_PW = "DB_PWD=";
    public static final String CLEAR_TO_SEND = "CTS";
    private FailoverManager manager;
    private JFrame frame;
    private ConfigureHelper helper;

    public ConfigureFailoverSlave(FailoverManager theManager, JFrame theFrame) {
        this.manager = theManager;
        this.frame = theFrame;
        this.helper = new ConfigureHelper(theFrame);
    }

    private void finish(boolean showRestart) {
        if (showRestart && JOptionPane.showConfirmDialog(this.frame, "<html><h1>Restart Servermate Recommended</h1><h2>Restart Now?</h2></html>", "Do restart?", 0) == 0) {
            try {
                new RelaunchServermateTask(this.frame).runLocal();
            }
            catch (Exception e) {
                OrderMate.LOG.error("Cannot relaunch servermate");
            }
        }
        this.manager.finished();
    }

    public void configureSlave() {
        if (!this.showWarning()) {
            this.finish(false);
            return;
        }
        FailoverSetup setup = this.manager.getSetup();
        setup.setSlave(true);
        setup.setActingMaster(false);
        setup.endFailover();
        setup.save();
        final File myIni = this.helper.getMyIniFile();
        if (myIni == null || !myIni.exists()) {
            this.finish(false);
            return;
        }
        new Thread(new Runnable(){

            @Override
            public void run() {
                ConfigureFailoverSlave.this.doChangeover(myIni);
                ConfigureFailoverSlave.this.finish(true);
            }
        }).start();
    }

    public void updateSlave() {
        FailoverSetup setup = this.manager.getSetup();
        MasterLocationDetails details = new MasterLocationDetails(setup.getMasterHost(), setup.getMasterPort());
        if (this.getDetailsFromMaster(details, "Update Master Details:")) {
            this.updateMasterPassword(details);
        }
    }

    private boolean showWarning() {
        StringBuilder SB = new StringBuilder("<html>");
        SB.append("<h1 color='red'> WARNING </h1>").append("You are about to set this machine's database as a Slave database.<br>").append("This should only be performed on a <b>secondary</b> ServerMate,<br>").append("and only by a trained OrderMate technician.<br><br>").append("If you are unsure, contact OrderMate.<br><br>").append("<b>Are you sure you wish to proceed?</b></html>");
        return JOptionPane.showConfirmDialog(this.frame, SB.toString(), "Confirm Configure Slave", 0) == 0;
    }

    private boolean doChangeover(File iniFile) {
        if (!this.modifyIniFile(iniFile)) {
            String error = "Couldn't modify the my.ini file.";
            OrderMate.LOG.warn(error);
            JOptionPane.showMessageDialog(this.frame, error);
            return false;
        }
        if (!this.stopSlave()) {
            String error = "Couldn't instruct MySQL to stop the slave";
            OrderMate.LOG.warn(error);
            JOptionPane.showMessageDialog(this.frame, error);
            return false;
        }
        this.resetSlave();
        MasterLocationDetails details = this.getDetails();
        if (!details.valid) {
            String error = "Failover Master Details are invalid";
            OrderMate.LOG.warn(error);
            JOptionPane.showMessageDialog(this.frame, error);
            return false;
        }
        if (!this.getMasterData(details)) {
            String error = "Failover Master Data could not be obtained.";
            OrderMate.LOG.warn(error);
            JOptionPane.showMessageDialog(this.frame, error);
            return false;
        }
        StringBuilder SB = new StringBuilder("<html><h1 color='GREEN'>IMPORTANT</h1>").append("Go to the Master machine and keep the Failover Setup<br>").append("Dialog <b>OPEN</b></html>");
        JOptionPane.showMessageDialog(this.frame, SB.toString());
        if (!this.configureMasterLocation(details)) {
            String error = "Failover Master Location could not be configured.";
            OrderMate.LOG.warn(error);
            JOptionPane.showMessageDialog(this.frame, error);
            return false;
        }
        if (!this.startSlave()) {
            String error = "Slave was not able to start. Check logs.";
            OrderMate.LOG.warn(error);
            JOptionPane.showMessageDialog(this.frame, error);
            return false;
        }
        return true;
    }

    private MasterLocationDetails getDetails() {
        String ip = this.helper.getInput("What is the IP of the Master?", this.manager.getSetup().getMasterHost());
        String portString = this.helper.getInput("What is the failover port of the ip (255 > port < 64556)?", Integer.toString(this.manager.getSetup().getMasterPort()));
        int port = 0;
        try {
            port = Integer.parseInt(portString);
        }
        catch (NumberFormatException ex) {
            OrderMate.LOG.warn("Cannot parse int for port:" + portString);
        }
        return new MasterLocationDetails(ip, port);
    }

    private boolean getMasterData(MasterLocationDetails details) {
        StringBuilder SB;
        if (this.getDetailsFromMaster(details, "Request Master Details:") && JOptionPane.showConfirmDialog(this.frame, (SB = new StringBuilder("<html><h1 color='Orange'>Important</h1>").append("Go to the Master Machine and wait until it reports that it has<br>").append("finished exporting its database.<br>").append("<br>Then come back here and press OK.</html>")).toString()) == 0 && this.getDataFromMaster(details)) {
            OrderMate.LOG.info("Inserting data from Master");
            this.fillDataIntoDB();
            return true;
        }
        return false;
    }

    private boolean configureMasterLocation(MasterLocationDetails details) {
        StringBuilder SB = new StringBuilder("CHANGE MASTER TO MASTER_HOST='").append(details.ipAddress).append("',\nMASTER_USER='").append(details.dbUser).append("',\n").append("MASTER_PASSWORD='").append(details.dbPassword).append("',\n").append("MASTER_PORT=3307,\n").append("MASTER_LOG_FILE='").append(details.logFile).append("',\nMASTER_LOG_POS=").append(details.logPos).append(";");
        return this.sendDBCommand(SB.toString());
    }

    private boolean updateMasterPassword(MasterLocationDetails details) {
        OrderMate.LOG.info("Got connection to failover master, updating slave");
        boolean result = true;
        StringBuilder SB = new StringBuilder("CHANGE MASTER TO ").append("MASTER_USER='").append(details.dbUser).append("',\n").append("MASTER_PASSWORD='").append(details.dbPassword).append("';");
        result = result && this.stopSlave();
        result = result && this.sendDBCommand(SB.toString());
        result = result && this.startSlave();
        return result;
    }

    private boolean modifyIniFile(File iniFile) {
        String text = this.helper.readInFile(iniFile);
        if (text == null || text.trim().isEmpty()) {
            this.helper.showMessage("Problem modifying the my.ini file, see logs.");
            return false;
        }
        int serverIndex = this.getServerIndex();
        if (serverIndex <= 0) {
            return false;
        }
        text = this.modifyText(text, serverIndex);
        this.helper.writeOutFile(text, iniFile);
        return true;
    }

    private int getServerIndex() {
        List<Integer> ints = Arrays.asList(2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16);
        StringBuilder SB = new StringBuilder("<html>").append("Please select the id of this server.<br>").append("<b>This is unique to this machine</b></html>");
        Integer option = this.helper.getOption("Server ID", SB.toString(), ints);
        return option == null ? -1 : option;
    }

    protected String modifyText(String iniFileText, int serverId) {
        String[] splits = iniFileText.split("\\[mysqld\\]");
        if (splits.length != 2) {
            OrderMate.LOG.error("My ini file has no [mysqld] section, or multiple.");
            return null;
        }
        String firstSplit = splits[0];
        String secondSplit = splits[1];
        if (!secondSplit.contains("replicate_do_db")) {
            secondSplit = "\r\nreplicate_do_db=ordermate_prod" + secondSplit;
        }
        if (!secondSplit.contains("slave_skip_errors")) {
            secondSplit = "\r\nslave_skip_errors=1062" + secondSplit;
        }
        if (!secondSplit.contains("slave_exec_mode")) {
            secondSplit = "\r\nslave_exec_mode=IDEMPOTENT" + secondSplit;
        }
        if (!secondSplit.contains("server-id")) {
            secondSplit = "\r\nserver-id=" + serverId + secondSplit;
        }
        return firstSplit + "[mysqld]" + secondSplit;
    }

    private boolean getDetailsFromMaster(MasterLocationDetails details, String request) {
        OrderMate.LOG.info("Retrieving master logfile details.");
        SocketHelper socketHelper = new SocketHelper(details.ipAddress, details.port);
        if (socketHelper.reconnect()) {
            socketHelper.sendMessage(request);
            String masterDetails = socketHelper.receiveMessage();
            socketHelper.closeOff();
            return this.interpretMasterDetails(masterDetails, details);
        }
        OrderMate.LOG.warn("Cannot retrieve data from master, socket will not connect.");
        socketHelper.closeOff();
        return false;
    }

    boolean interpretMasterDetails(String message, MasterLocationDetails details) {
        OrderMate.LOG.info("Interpreting master logfile details:" + message);
        if (message != null && !message.isEmpty()) {
            String[] splits = message.split(":");
            if (splits.length == 4) {
                details.logFile = splits[0].replace(MASTER_LOG, "");
                details.logPos = splits[1].replace(MASTER_POS, "");
                details.dbUser = splits[2].replace(MASTER_USER, "");
                details.dbPassword = splits[3].replace(MASTER_PW, "");
                return true;
            }
            OrderMate.LOG.warn("Master Details do not match, expected four components:" + message);
        } else {
            OrderMate.LOG.warn("Master Details are sketchy:" + message);
        }
        return false;
    }

    private boolean getDataFromMaster(MasterLocationDetails details) {
        OrderMate.LOG.info("Getting data from the Master");
        File output = new File(MASTER_SQL_FILE);
        SocketHelper socketHelper = new SocketHelper(details.ipAddress, details.port);
        if (socketHelper.reconnect()) {
            socketHelper.sendMessage("Request Master Data:");
            socketHelper.readLinesToFile(output);
            socketHelper.closeOff();
            return true;
        }
        OrderMate.LOG.warn("Cannot bring in master data.");
        socketHelper.closeOff();
        return false;
    }

    private void fillDataIntoDB() {
        File mySqlDir = new File("C:\\mysql\\5.5\\bin");
        if (!mySqlDir.exists()) {
            mySqlDir = new File("D:\\mysql\\5.5\\bin");
        }
        if (!mySqlDir.exists()) {
            mySqlDir = new File("E:\\mysql\\5.5\\bin");
        }
        if (!mySqlDir.exists()) {
            OrderMate.LOG.error("Cannot find c/d/e:\\mysql\\5.5.\bin directory");
            return;
        }
        final File theFile = mySqlDir;
        final String username = Config.getDecryptedStringValue((String)"database_username");
        final String password = Config.getDecryptedStringValue((String)"database_password");
        AbstractTask task = new AbstractTask(){

            public String getName() {
                return "Importing DB - Very Important";
            }

            protected void performTask() throws Exception {
                try {
                    Process process = Runtime.getRuntime().exec(new String[]{"cmd.exe", "/C", "mysql -u" + username + " -p" + password + " ordermate_prod < " + ConfigureFailoverSlave.MASTER_SQL_FILE}, null, theFile);
                    try {
                        this.emitProgress();
                        process.waitFor();
                        this.emitProgress();
                    }
                    catch (InterruptedException ex1) {
                        OrderMate.LOG.error("Interrupted while waiting for the data to pushed into db.", (Throwable)ex1);
                    }
                }
                catch (IOException ex2) {
                    OrderMate.LOG.error("Cannot start process to suck in mysql data", (Throwable)ex2);
                }
            }

            protected int getTotalSubTasks() {
                return 2;
            }
        };
        ProgressDialog progress = new ProgressDialog((Frame)this.frame, true, (Task)task);
        progress.start();
    }

    private boolean stopSlave() {
        return this.sendDBCommand("STOP SLAVE;");
    }

    private boolean resetSlave() {
        return this.sendDBCommand("RESET SLAVE;");
    }

    private boolean startSlave() {
        return this.sendDBCommand("START SLAVE;");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean sendDBCommand(String value) {
        DatabaseControl dc = new DatabaseControl(true);
        try {
            dc.execute(value, new Object[0]);
        }
        catch (SQLException ex) {
            OrderMate.LOG.error("Could Execute command:" + value, (Throwable)ex);
            boolean bl = false;
            return bl;
        }
        finally {
            dc.closeConnection();
        }
        return true;
    }
}

