/*
 * Decompiled with CFR 0.152.
 */
package servermate.failover.configure;

import au.com.ordermate.util.StringUtils;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import ordermate.OrderMate;

class ConfigureHelper {
    private JFrame owningFrame;

    ConfigureHelper(JFrame theFrame) {
        this.owningFrame = theFrame;
    }

    void showMessage(String message) {
        JOptionPane.showMessageDialog(this.owningFrame, message);
    }

    File getMyIniFile() {
        JFileChooser chooser = new JFileChooser();
        chooser.setSelectedFile(new File("C:\\mysql\\5.5\\my.ini"));
        chooser.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f != null && f.exists() && "my.ini".equals(f.getName());
            }

            @Override
            public String getDescription() {
                return "The MySQL ini file";
            }
        });
        if (chooser.showOpenDialog(this.owningFrame) == 0) {
            return chooser.getSelectedFile();
        }
        return null;
    }

    public String readInFile(File iniFile) {
        if (iniFile == null || !iniFile.exists()) {
            this.showMessage("No file found for this location:" + iniFile);
            return null;
        }
        String text = null;
        try {
            text = StringUtils.readInTextFile((File)iniFile);
        }
        catch (IOException ex) {
            OrderMate.LOG.error("Bad " + iniFile.getName() + " file, couldn't read!", (Throwable)ex);
            this.showMessage("Could not read in the my.ini file.");
            return null;
        }
        return text;
    }

    public void writeOutFile(String text, File file) {
        try {
            StringUtils.writeTextToFile((File)file, (String)text);
            this.showMessage("<html>The Database ini file has been configured.<br><br><b>Please restart MySQL now.</b></html>");
        }
        catch (IOException ex) {
            OrderMate.LOG.error("Bad my.ini file, could not be written to", (Throwable)ex);
            this.showMessage("Cannot write to my.ini file!");
        }
    }

    public <T> T getOption(String title, String message, List<T> options) {
        int selection = JOptionPane.showOptionDialog(this.owningFrame, message, title, 2, 3, null, options.toArray(), options.get(0));
        if (selection >= 0 && selection < options.size()) {
            return options.get(selection);
        }
        return null;
    }

    public String getInput(String message, String defaultValue) {
        return JOptionPane.showInputDialog(this.owningFrame, message, defaultValue);
    }
}

