/*
 * Decompiled with CFR 0.152.
 */
package servermate.failover.handback;

import java.awt.Color;
import javax.swing.JOptionPane;
import ordermate.OrderMate;
import ordermate.database.failover.FailoverSetup;
import servermate.ServermatePersistenceSharer;
import servermate.failover.FailoverManager;
import servermate.failover.SocketHelper;
import servermate.failover.handback.HandbackTransmitter;

public class FailoverHandback {
    static String BEGIN_MERGE = "BEGIN MERGE";
    static String OK = "OK";
    static String DONE = "DONE";
    private FailoverManager manager;

    public FailoverHandback(FailoverManager theManager) {
        this.manager = theManager;
    }

    public void begin() {
        block5: {
            if (!this.confirmHandback()) {
                return;
            }
            try {
                if (!this.mergeDataWithMaster()) {
                    StringBuilder SB = new StringBuilder("<html><h1 color='Orange'>No Connection</h1>").append("A connection to the master could not be established.<br>").append("Please ensure the Master machine is running<br>").append("and hooked onto the network.</html>");
                    JOptionPane.showMessageDialog(null, SB.toString());
                    return;
                }
            }
            catch (Exception ex) {
                if (this.handleBadness(ex)) break block5;
                return;
            }
        }
        if (this.confirmAllGood()) {
            this.stopSharing();
            this.displayFinished();
            this.manager.pushText("Handback Completed. Please Reset to Slave.", true, Color.GREEN);
        }
    }

    private boolean confirmHandback() {
        StringBuilder SB = new StringBuilder("<html><h1 color='Green'>Caution</h1>").append("This will attempt to merge data back to the Master machine.<br>").append("Please ensure that the master machine is turned on and Servermate is running.<br>").append("<br><b>Once started, this process will continue until data has been merged.</b><br>").append("<br>If unsure, please contact OrderMate Technical Support on 1300 667 002<br></html>");
        return JOptionPane.showConfirmDialog(null, SB.toString()) == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean mergeDataWithMaster() throws Exception {
        FailoverSetup setup = this.manager.getSetup();
        OrderMate.LOG.info("Merging my data with the Master, host:" + setup.getMasterHost() + " port:" + setup.getMasterPort());
        SocketHelper helper = new SocketHelper(setup.getMasterHost(), setup.getMasterPort());
        boolean fine = false;
        try {
            if (helper.reconnect()) {
                OrderMate.LOG.info("Connected, sending data");
                helper.sendMessage(BEGIN_MERGE);
                String value = helper.receiveMessage();
                OrderMate.LOG.info("Got Response:" + value);
                if (value != null && value.equals(OK)) {
                    OrderMate.LOG.info("Response valid, sending rows.");
                    HandbackTransmitter sender = new HandbackTransmitter(helper);
                    sender.sendRows();
                    fine = true;
                }
            }
        }
        finally {
            helper.closeOff();
        }
        return fine;
    }

    private void stopSharing() {
        ServermatePersistenceSharer.getInstance().stopSharing();
    }

    private boolean handleBadness(Exception ex) {
        OrderMate.LOG.info("Error with merge:", (Throwable)ex);
        StringBuilder SB = new StringBuilder("<html><h1 color='Red'>Error</h1>").append("An error occurred while synchronising data with the Master.<br>").append("This has been logged.<br>").append("The error is like:<br>").append(ex.getLocalizedMessage().substring(0, 255)).append("<br><br>Do you wish to continue anyway?</html>");
        return JOptionPane.showConfirmDialog(null, SB.toString()) == 0;
    }

    private boolean confirmAllGood() {
        StringBuilder SB = new StringBuilder("<html><h1 color='Green'>Handback Finished</h1>").append("The data on this slave has been transmitted to the Master.<br>").append("Please use the Master machine to confirm the merge.<br>").append("<br><b>If the merge is complete on the Master machine<br>").append("Press OK. This will stop this Slave acting as a Master.<br>");
        return JOptionPane.showConfirmDialog(null, SB.toString()) == 0;
    }

    private void displayFinished() {
        StringBuilder SB = new StringBuilder("<html><h1 color='Green'>Finished</h1>").append("The handover process is finished for this Slave.<br>").append("Please go to the Master and follow any further instructions.<br>").append("<br><b>This Slave will need to be resynchronised with the Master<br>").append("once all handbacks have been completed.</b></html>");
        JOptionPane.showMessageDialog(null, SB.toString());
    }
}

