/*
 * Decompiled with CFR 0.152.
 */
package servermate.failover.handback;

import au.com.ordermate.oquery.Query;
import au.com.ordermate.oquery.SQLDateType;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.synchronisation.AbstractPersistentObjectCreator;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JOptionPane;
import ordermate.OrderMate;
import ordermate.database.finance.Shift;
import ordermate.database.finance.debtors.transactions.DebtorPayment;
import ordermate.database.finance.debtors.transactions.DebtorSale;
import ordermate.database.misc.ConfigShift;
import ordermate.database.misc.EventLogRecord;
import ordermate.database.misc.TradingDay;
import ordermate.database.sales.Account;
import servermate.failover.SocketHelper;
import servermate.failover.handback.FailoverHandback;
import servermate.failover.handback.merger.AccountHandbackMerger;
import servermate.failover.handback.merger.DebtorPaymentMerger;
import servermate.failover.handback.merger.DebtorSaleMerger;
import servermate.failover.handback.merger.EventLogMerger;
import servermate.failover.handback.merger.HandbackMerger;

public class HandbackReceiver {
    private SocketHelper helper;
    private Map<String, Long> lastIdMap;
    private Map<Class, List> objectsMap;
    private Map<Class, HandbackMerger> mergers = new LinkedHashMap<Class, HandbackMerger>();

    public HandbackReceiver(SocketHelper socketHelper) {
        this.lastIdMap = new HashMap<String, Long>();
        this.objectsMap = new HashMap<Class, List>();
        this.helper = socketHelper;
        this.mergers.put(Account.class, new AccountHandbackMerger());
        this.mergers.put(DebtorSale.class, new DebtorSaleMerger());
        this.mergers.put(DebtorPayment.class, new DebtorPaymentMerger());
        this.mergers.put(EventLogRecord.class, new EventLogMerger());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doMerge() {
        this.helper.sendMessage(FailoverHandback.OK);
        try {
            this.readInLastIds();
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Cannot read in last row data from the slave.", (Throwable)ex);
            JOptionPane.showMessageDialog(null, "Error reading in Failover Row Data. Nothing Merged.");
            return;
        }
        ObjectInputStream input = null;
        try {
            input = new ObjectInputStream(this.helper.getInputStream());
            TradingDay day = this.readInTradingDay(input);
            while (day != null) {
                day = this.localiseDay(day);
                JOptionPane.showMessageDialog(null, "Handing back data for Trading Day:" + day);
                for (Class clazz : this.mergers.keySet()) {
                    HandbackMerger merger = this.mergers.get(clazz);
                    merger.setTradingDay(day);
                    merger.doMerge(this.objectsMap.get(clazz));
                }
                day = this.readInTradingDay(input);
            }
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Couldn't read in data from slave", (Throwable)ex);
            JOptionPane.showMessageDialog(null, "Error reading in Handover Data. Not Merged.");
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException ex) {
                    OrderMate.LOG.error("Cannot close off the socket input after/during merge", (Throwable)ex);
                }
            }
        }
        JOptionPane.showMessageDialog(null, "Handover process is complete.");
    }

    private TradingDay localiseDay(TradingDay day) {
        TradingDay equivDay = (TradingDay)PersistenceManager.getByID((long)day.getID(), TradingDay.class);
        if (equivDay != null && equivDay.getOpenDateTime().equals(day.getOpenDateTime())) {
            return equivDay;
        }
        equivDay = (TradingDay)PersistenceManager.getObject(TradingDay.class, (String)Query.select(TradingDay.class).equals(TradingDay.Properties.DATE, day.getDate(), SQLDateType.DATE).toString(), null);
        if (equivDay == null) {
            equivDay = day;
            PersistenceManager.setID((PersistentObject)equivDay, null);
            equivDay.save();
            String shiftName = Shift.getShiftNames()[0];
            Shift shift = Shift.getShift((TradingDay)equivDay, (String)shiftName);
            if (shift == null) {
                Shift.createShift((TradingDay)equivDay, (ConfigShift)ConfigShift.getConfigShiftWithName((String)shiftName));
            }
        }
        return equivDay;
    }

    private void readInLastIds() {
        OrderMate.LOG.info("Reading in the failover data rows");
        String lastRowsString = this.helper.receiveMessage();
        String[] splits = lastRowsString.split(";");
        this.lastIdMap = new HashMap<String, Long>();
        for (String nextSplit : splits) {
            String[] parts = nextSplit.split("=");
            if (parts.length <= 0) {
                throw new IllegalArgumentException("Nothing was brought in from the Last Row ID Message");
            }
            this.lastIdMap.put(parts[0], Long.parseLong(parts[1]));
        }
    }

    TradingDay readInTradingDay(ObjectInputStream in) throws IOException, ClassCastException, ClassNotFoundException {
        OrderMate.LOG.info("Reading in trading day");
        TradingDay day = null;
        if (in.readBoolean()) {
            day = (TradingDay)in.readObject();
            this.objectsMap = new HashMap<Class, List>();
            for (int i = 0; i < this.mergers.size(); ++i) {
                this.readInMap(in);
            }
        } else {
            this.objectsMap = null;
        }
        return day;
    }

    private void readInMap(ObjectInputStream in) throws IOException, ClassCastException, ClassNotFoundException {
        String clazz = (String)in.readObject();
        int length = in.readInt();
        ArrayList<Object> list = new ArrayList<Object>(length);
        for (int i = 0; i < length; ++i) {
            list.add(in.readObject());
        }
        this.objectsMap.put(Class.forName(clazz), list);
        OrderMate.LOG.info("Handback received " + list.size() + " of type " + clazz);
    }

    Map<Class, List> getObjectsMap() {
        return this.objectsMap;
    }

    static class NoEffortObjectCreator
    extends AbstractPersistentObjectCreator {
        NoEffortObjectCreator() {
        }

        protected <T extends PersistentObject> T findObject(Class<T> clazz, long id) {
            return null;
        }
    }
}

