/*
 * Decompiled with CFR 0.152.
 */
package servermate.failover.handback.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import org.jdesktop.swingx.autocomplete.ComboBoxCellEditor;
import servermate.failover.handback.gui.HandbackTableModel;
import servermate.failover.handback.merger.HandbackMerger;
import servermate.failover.handback.strategy.HandbackStrategy;

class HandbackMergerPanel
extends JPanel
implements ActionListener {
    private JButton defaultBut;
    private JButton setAllIgnoreBut;
    private JButton setAllAddBut;
    private JButton setAllOverrideBut;
    private JButton showInfoBut;
    private JTable table;
    private HandbackTableModel tableModel;
    private HandbackMerger merger;

    HandbackMergerPanel(HandbackMerger yourMerger) {
        super(new BorderLayout());
        this.merger = yourMerger;
        this.setupComponents();
    }

    private void setupComponents() {
        this.setPreferredSize(new Dimension(800, 600));
        this.tableModel = new HandbackTableModel(this.merger);
        this.table = new JTable(this.tableModel);
        this.add((Component)new JScrollPane(this.table), "Center");
        JComboBox<HandbackStrategy> combo = new JComboBox<HandbackStrategy>(HandbackStrategy.values());
        ComboBoxCellEditor strategyEditor = new ComboBoxCellEditor(combo);
        this.table.setDefaultEditor(HandbackStrategy.class, (TableCellEditor)strategyEditor);
        JPanel buttons = new JPanel(new FlowLayout(0));
        this.defaultBut = this.makeButton("Default Merge", buttons);
        this.setAllAddBut = this.makeButton("All Add", buttons);
        this.setAllOverrideBut = this.makeButton("All Override", buttons);
        this.setAllIgnoreBut = this.makeButton("All Ignore", buttons);
        this.add((Component)buttons, "North");
    }

    private JButton makeButton(String name, JPanel holder) {
        JButton button = new JButton(name);
        button.setName(name);
        button.addActionListener(this);
        holder.add(button);
        return button;
    }

    private void setAll(HandbackStrategy strategy) {
        StringBuilder SB = new StringBuilder("<html>Are you sure you wish to set all handbacks <br>to ");
        if (strategy == null) {
            SB.append("their default");
        } else {
            SB.append(strategy.toString());
        }
        SB.append(" merge strategy?</html>");
        if (JOptionPane.showConfirmDialog(this.getParent(), SB.toString()) == 0) {
            this.tableModel.setAllStrategies(strategy);
            this.table.validate();
            this.table.repaint();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.defaultBut) {
            this.setAll(null);
        } else if (source == this.setAllIgnoreBut) {
            this.setAll(HandbackStrategy.Ignore);
        } else if (source == this.setAllOverrideBut) {
            this.setAll(HandbackStrategy.Override);
        } else if (source == this.setAllAddBut) {
            this.setAll(HandbackStrategy.Add);
        }
    }
}

