/*
 * Decompiled with CFR 0.152.
 */
package servermate.failover.handback.gui;

import au.com.ordermate.persistence.PersistentObject;
import javax.swing.table.AbstractTableModel;
import servermate.failover.handback.Handback;
import servermate.failover.handback.merger.HandbackMerger;
import servermate.failover.handback.strategy.HandbackStrategy;

public class HandbackTableModel<T extends PersistentObject>
extends AbstractTableModel {
    private String[] columns = new String[]{"ID", "Type", "Incoming", "Time", "Existing", "Time", "Strategy"};
    private HandbackMerger merger;

    public HandbackTableModel(HandbackMerger yourMerger) {
        this.merger = yourMerger;
    }

    @Override
    public int getRowCount() {
        return this.merger.getSize();
    }

    @Override
    public int getColumnCount() {
        return this.columns.length;
    }

    @Override
    public String getColumnName(int index) {
        return this.columns[index];
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return col == this.columns.length - 1;
    }

    @Override
    public Class<?> getColumnClass(int index) {
        if (index == this.columns.length - 1) {
            return HandbackStrategy.class;
        }
        return super.getColumnClass(index);
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        if (col == this.columns.length - 1) {
            this.merger.get(row).setStrategy((HandbackStrategy)((Object)value));
        } else {
            super.setValueAt(value, row, col);
        }
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Handback handback = this.merger.get(rowIndex);
        if (columnIndex == 0) {
            return handback.getIncoming().getID();
        }
        if (columnIndex == 1) {
            return this.merger.getIncomingType(handback);
        }
        if (columnIndex == 2) {
            return this.merger.getIncomingTotal(handback);
        }
        if (columnIndex == 3) {
            return this.merger.getIncomingDate(handback);
        }
        if (columnIndex == 4) {
            return this.merger.getExistingTotal(handback);
        }
        if (columnIndex == 5) {
            return this.merger.getExistingDate(handback);
        }
        if (columnIndex == 6) {
            return handback.getStrategy();
        }
        return null;
    }

    public void setAllStrategies(HandbackStrategy strategy) {
        if (strategy == null) {
            this.merger.setAllToDefaultStrategy();
        } else {
            this.merger.setAllToStrategy(strategy);
        }
        this.fireTableDataChanged();
    }
}

