/*
 * Decompiled with CFR 0.152.
 */
package servermate.failover.handback.merger;

import au.com.ordermate.oquery.Query;
import au.com.ordermate.oquery.SQLDateType;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.util.Price;
import java.util.Date;
import java.util.List;
import ordermate.database.finance.debtors.transactions.DebtorPayment;
import servermate.failover.handback.Handback;
import servermate.failover.handback.merger.DebtorPaymentIdClarifier;
import servermate.failover.handback.merger.HandbackMerger;
import servermate.failover.handback.strategy.HandbackStrategy;

public class DebtorPaymentMerger
extends HandbackMerger<DebtorPayment, Date> {
    private DebtorPaymentIdClarifier clarifier;
    private static final String TYPE = "Debtor Payment";

    @Override
    protected void setToDefault(Handback<DebtorPayment> toSet) {
        if (toSet.getExisting() != null) {
            DebtorPayment existing = toSet.getExisting();
            if (existing.getAmount().equals((Object)toSet.getIncoming().getAmount()) && existing.getDate().equals(toSet.getIncoming().getDate())) {
                toSet.setStrategy(HandbackStrategy.Ignore);
            } else {
                toSet.setStrategy(HandbackStrategy.Add);
            }
        } else {
            toSet.setStrategy(HandbackStrategy.Add);
        }
    }

    @Override
    protected boolean canOverride(DebtorPayment incoming, DebtorPayment existing) {
        return false;
    }

    @Override
    public String getMergingType() {
        return TYPE;
    }

    @Override
    public String getIncomingType(Handback<DebtorPayment> handback) {
        return TYPE;
    }

    @Override
    public Price getIncomingTotal(Handback<DebtorPayment> handback) {
        return handback.getIncoming().getAmount();
    }

    @Override
    public Date getIncomingDate(Handback<DebtorPayment> handback) {
        return handback.getIncoming().getDate();
    }

    @Override
    public Price getExistingTotal(Handback<DebtorPayment> handback) {
        if (handback.getExisting() != null) {
            return handback.getExisting().getAmount();
        }
        return null;
    }

    @Override
    public Date getExistingDate(Handback<DebtorPayment> handback) {
        if (handback.getExisting() != null) {
            return handback.getExisting().getDate();
        }
        return null;
    }

    @Override
    public void localise(DebtorPayment incoming, DebtorPayment existing) {
    }

    @Override
    public void destroy(DebtorPayment objectToDestroy) {
        objectToDestroy.deleteChild();
    }

    @Override
    public void save(DebtorPayment objectToSave) {
        objectToSave.saveChild();
    }

    @Override
    public void clearIds(DebtorPayment objectToClear) {
        if (this.clarifier == null) {
            this.clarifier = new DebtorPaymentIdClarifier();
        }
        this.clarifier.clearIds(objectToClear);
    }

    @Override
    protected Date getEquivalentParentObject(List<DebtorPayment> incoming) {
        if (incoming.size() > 0) {
            return incoming.get(0).getDate();
        }
        return null;
    }

    @Override
    protected List<DebtorPayment> getExisting(Date parentObject) {
        return PersistenceManager.getObjectList(DebtorPayment.class, (String)Query.select(DebtorPayment.class).equals(DebtorPayment.Properties.DATE, parentObject, SQLDateType.DATE).toString());
    }
}

