/*
 * Decompiled with CFR 0.152.
 */
package servermate.failover.handback.merger;

import au.com.ordermate.oquery.Query;
import au.com.ordermate.oquery.SQLDateType;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.util.Price;
import java.util.Date;
import java.util.List;
import ordermate.database.finance.debtors.transactions.DebtorSale;
import servermate.failover.handback.Handback;
import servermate.failover.handback.merger.HandbackMerger;
import servermate.failover.handback.merger.IdClarifier;
import servermate.failover.handback.strategy.HandbackStrategy;

public class DebtorSaleMerger
extends HandbackMerger<DebtorSale, Date> {
    private static final String TYPE = "Debtor Sale";
    private DebtorSaleClarifier clarifier = new DebtorSaleClarifier();

    @Override
    protected Date getEquivalentParentObject(List<DebtorSale> incoming) {
        if (incoming.size() > 0) {
            return incoming.get(0).getSaleDate();
        }
        return null;
    }

    @Override
    protected List<DebtorSale> getExisting(Date parentObject) {
        return PersistenceManager.getObjectList(DebtorSale.class, (String)Query.select(DebtorSale.class).equals(DebtorSale.Properties.SALE_DATE, parentObject, SQLDateType.DATE).toString());
    }

    @Override
    protected void setToDefault(Handback<DebtorSale> toSet) {
        if (toSet.getExisting() != null) {
            DebtorSale existing = toSet.getExisting();
            if (existing.getAmount().equals((Object)toSet.getIncoming().getAmount()) && existing.getSaleDate().equals(toSet.getIncoming().getSaleDate())) {
                toSet.setStrategy(HandbackStrategy.Ignore);
            } else {
                toSet.setStrategy(HandbackStrategy.Add);
            }
        } else {
            toSet.setStrategy(HandbackStrategy.Add);
        }
    }

    @Override
    protected boolean canOverride(DebtorSale incoming, DebtorSale existing) {
        return false;
    }

    @Override
    public String getIncomingType(Handback<DebtorSale> handback) {
        return TYPE;
    }

    @Override
    public Price getIncomingTotal(Handback<DebtorSale> handback) {
        return handback.getIncoming().getAmount();
    }

    @Override
    public void localise(DebtorSale incoming, DebtorSale existing) {
    }

    @Override
    public void destroy(DebtorSale objectToDestroy) {
        objectToDestroy.deleteChild();
    }

    @Override
    public void save(DebtorSale objectToSave) {
        objectToSave.saveChild();
    }

    @Override
    public void clearIds(DebtorSale objectToClear) {
        this.clarifier.clearIds(objectToClear);
    }

    @Override
    public String getMergingType() {
        return TYPE;
    }

    @Override
    public Date getIncomingDate(Handback<DebtorSale> handback) {
        return handback.getIncoming().getSaleDate();
    }

    @Override
    public Price getExistingTotal(Handback<DebtorSale> handback) {
        if (handback.getExisting() != null) {
            return handback.getExisting().getAmount();
        }
        return null;
    }

    @Override
    public Date getExistingDate(Handback<DebtorSale> handback) {
        if (handback.getExisting() != null) {
            return handback.getExisting().getSaleDate();
        }
        return null;
    }

    static class DebtorSaleClarifier
    extends IdClarifier<DebtorSale> {
        DebtorSaleClarifier() {
        }

        @Override
        protected void clearChildrenIds(DebtorSale parent) {
            this.clearId((PersistentObject)parent);
        }
    }
}

