/*
 * Decompiled with CFR 0.152.
 */
package servermate.gui;

import au.com.ordermate.OrderMateLog;
import au.com.ordermate.util.image.IconLoader;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import ordermate.OrderMate;
import ordermate.database.users.AllPermissions;
import ordermate.database.users.User;
import ordermate.gui.dialogs.LoginDialog;
import ordermate.gui.modify.security.PosUserSecurityManager;
import ordermate.security.impl.SecurityDetails;
import ordermate.signals.Signal;
import servermate.ServerMate;
import servermate.client.ServerMateClient;
import servermate.client.security.RMISecurityDetails;
import servermate.gui.RestartConfirmDialog;
import servermate.gui.license.ServermateLicenseDialog;
import servermate.gui.redback.RedbackIdDialog;

public class ServerMateFrame
extends JFrame {
    private static final Dimension SCREEN_SIZE = Toolkit.getDefaultToolkit().getScreenSize();
    private static ServerMateFrame instance;
    private static JDialog passwordDialog;
    public static final ImageIcon ORDERMATE_ICON;

    public ServerMateFrame() {
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        JLabel backgroundImage = new JLabel();
        this.setTitle("OrderMate - Server " + OrderMate.VERSION);
        this.setDefaultCloseOperation(1);
        backgroundImage.setIcon(new ImageIcon("/ordermate/images/splash.png"));
        JPanel loginBackground = new JPanel();
        loginBackground.add(backgroundImage);
        loginBackground.setBackground(Color.white);
        this.getContentPane().add(loginBackground);
        ArrayList<Image> icons = new ArrayList<Image>();
        icons.add(IconLoader.get((String)"/ordermate/images/servermate_icon_16.png").getImage());
        icons.add(IconLoader.get((String)"/ordermate/images/servermate_icon_24.png").getImage());
        icons.add(IconLoader.get((String)"/ordermate/images/servermate_icon_32.png").getImage());
        icons.add(IconLoader.get((String)"/ordermate/images/servermate_icon_48.png").getImage());
        icons.add(IconLoader.get((String)"/ordermate/images/servermate_icon_256.png").getImage());
        this.setIconImages(icons);
        this.pack();
        this.setLocation(ServerMateFrame.SCREEN_SIZE.width / 2 - this.getWidth() / 2, ServerMateFrame.SCREEN_SIZE.height / 2 - this.getHeight() / 2);
        this.toFront();
        instance = this;
    }

    public void safeRestart() {
        List users = new PosUserSecurityManager().getUsers();
        User user = LoginDialog.getLogin((Frame)this, (List)users, (String)"This action requires login", (String)"Cancel");
        if (user != null) {
            while (user != null && !user.hasPermission(AllPermissions.EXIT) && !user.hasPermission(AllPermissions.CASHDRAWER)) {
                String s = "User " + user.getName() + " does not have permission to restart terminals!";
                JOptionPane.showMessageDialog(null, s, "Permission invalid", 2);
                user = LoginDialog.getLogin((Frame)this, (List)users, (String)"This action requires login", (String)"Cancel");
            }
            if (user != null && user.hasPermission(AllPermissions.EXIT) && user.hasPermission(AllPermissions.CASHDRAWER)) {
                RestartConfirmDialog dialog = new RestartConfirmDialog(user);
                dialog.setVisible(true);
            }
        }
    }

    public static void softwareLicense(Window parent) {
        ServerMateFrame.softwareLicense(parent, null);
    }

    private static char[] showPasswordDialog(Window parent, String message) {
        if (passwordDialog != null) {
            OrderMate.LOG.warn("Cannot request a new license dialog, already asking for password");
            return null;
        }
        final JPasswordField jpf = new JPasswordField();
        jpf.setName("passwordField");
        JOptionPane jop = new JOptionPane(jpf, 3, 2);
        passwordDialog = jop.createDialog(parent, message);
        passwordDialog.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                jpf.requestFocusInWindow();
            }
        });
        passwordDialog.setVisible(true);
        Integer result = (Integer)jop.getValue();
        passwordDialog.dispose();
        passwordDialog = null;
        char[] password = null;
        if (result != null && result == 0) {
            password = jpf.getPassword();
        }
        return password;
    }

    public static void setStoreId(Window parent) {
        char[] password = ServerMateFrame.showPasswordDialog(parent, "Enter password");
        if (password == null) {
            return;
        }
        if (!ServerMateFrame.isPasswordValid(password)) {
            JOptionPane.showMessageDialog(parent, "Password is incorrect");
            return;
        }
        RedbackIdDialog rbDialog = new RedbackIdDialog(parent);
        rbDialog.setVisible(true);
    }

    private static boolean isPasswordValid(char[] password) {
        boolean isCorrect = false;
        char[] correctPassword = new char[]{'o', 'm', 'v', 'e', 'n', 'd', 'o', 'r'};
        if (password == null) {
            return false;
        }
        if (password.length == correctPassword.length && Arrays.equals(password, correctPassword)) {
            isCorrect = true;
        }
        Arrays.fill(correctPassword, '0');
        Arrays.fill(password, '0');
        return isCorrect;
    }

    public static void softwareLicense(Window parent, Signal ringWhenPwdEntered) {
        char[] password = ServerMateFrame.showPasswordDialog(parent, "License Password:");
        if (password != null) {
            boolean isCorrect = false;
            isCorrect = ServerMateFrame.isPasswordValid(password);
            ServerMateClient.LOG.info("Password valid is " + isCorrect);
            if (!isCorrect) {
                JOptionPane.showMessageDialog(null, "License access password was incorrect.");
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                }
                ServerMateFrame.softwareLicense(ServerMateFrame.getFrame(), ringWhenPwdEntered);
            } else {
                ServerMateClient.LOG.info("Password is correct ");
                if (ringWhenPwdEntered != null) {
                    ringWhenPwdEntered.emit();
                }
                ServermateLicenseDialog.doLicenseDialog(ServerMateFrame.getSecurityDetails());
            }
        }
    }

    private static SecurityDetails getSecurityDetails() {
        ServerMateClient.LOG.info("Invoking getSecurity Details ");
        return new RMISecurityDetails();
    }

    protected void exit() {
        if (JOptionPane.showConfirmDialog(this, "Are you sure you wish to exit ServerMate?", "Nothing works without ServerMate.", 0, 2) == 0) {
            OrderMate.LOG.warn("ServerMate has been exited via 'Exit ServerMate' in system tray");
            ServerMate.exit(0);
        }
    }

    @Override
    protected void processWindowEvent(WindowEvent e) {
        if (e.getID() == 201) {
            OrderMateLog.LOG.info("Application window dismissed");
        }
        super.processWindowEvent(e);
    }

    public static JFrame getFrame() {
        return instance;
    }

    static {
        ORDERMATE_ICON = IconLoader.get((String)"/ordermate/images/servermate_icon_16.png");
    }
}

