/*
 * Decompiled with CFR 0.152.
 */
package servermate.gui;

import au.com.ordermate.configuration.Config;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.util.ProcessUtil;
import au.com.ordermate.util.image.IconLoader;
import java.awt.AWTException;
import java.awt.Frame;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.SystemTray;
import java.awt.TrayIcon;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import ordermate.OrderMate;
import ordermate.database.failover.FailoverSetup;
import ordermate.database.misc.SystemProperty;
import ordermate.deployer.OrderMateLauncherDeployer;
import ordermate.remotemonitor.RemoteMonitor;
import servermate.ServerMate;
import servermate.client.ServerMateClient;
import servermate.client.rmi.ServerMateEndPointRef;
import servermate.failover.FailoverManager;
import servermate.gui.ServerMateFrame;
import servermate.gui.ServerMateInfoDialog;
import servermate.gui.synchronisation.SynchronisationDialog;

public class ServerMateSystemTray
extends MouseAdapter
implements ActionListener {
    private ServerMateFrame serverMateFrame;
    private MenuItem checkDatabase;
    private MenuItem optimizeDatabase;
    private MenuItem showIPAddress;
    private MenuItem safeShutdown;
    private MenuItem softwareLicense;
    private MenuItem exitServerMate;
    private MenuItem startServermate;
    private MenuItem restartServerMate;
    private MenuItem clearDocketCache;
    private MenuItem pingDevmate;
    private MenuItem orderMateInfo;
    private MenuItem chainsawLogAnalyzer;
    private MenuItem synchroniseHo;
    private MenuItem setStoreId;
    private MenuItem failoverFrame;
    private MenuItem deployLauncher;
    private MenuItem exitServerMateClient;
    private TrayIcon trayIcon;
    private Window popupWindow;
    private PopupMenu popupMenu;
    private ServerMateInfoDialog infoDialog;

    public ServerMateSystemTray(ServerMateFrame frame) {
        this.serverMateFrame = frame;
        if (SystemTray.isSupported()) {
            SystemTray tray = SystemTray.getSystemTray();
            ImageIcon ordermateIcon = ServerMateFrame.ORDERMATE_ICON;
            this.popupMenu = this.initPopupMenu();
            this.trayIcon = new TrayIcon(ordermateIcon.getImage(), "Server Mate SystemTray", this.popupMenu);
            this.trayIcon.addMouseListener(this);
            this.trayIcon.addActionListener(this);
            try {
                tray.add(this.trayIcon);
            }
            catch (AWTException e) {
                OrderMate.LOG.error(e.toString());
                this.displayFrameGui();
            }
        } else {
            this.displayFrameGui();
        }
    }

    public void updateForFailover() {
        if (FailoverManager.getInstanceSetup().isSlave()) {
            this.setupAsSlave(FailoverManager.getInstanceSetup().isActingMaster());
        } else {
            List slaves = PersistenceManager.getObjectList(FailoverSetup.class, (String)Query.select(FailoverSetup.class).active(FailoverSetup.class).equals(FailoverSetup.Properties.SLAVE, (Object)"1").toString());
            if (!slaves.isEmpty()) {
                this.trayIcon.setToolTip("ServerMate Master of " + slaves.size() + " slaves");
            }
        }
    }

    private void setupAsSlave(boolean actingMaster) {
        this.popupMenu.remove(this.checkDatabase);
        this.popupMenu.remove(this.optimizeDatabase);
        this.popupMenu.remove(this.softwareLicense);
        this.popupMenu.remove(this.pingDevmate);
        this.popupMenu.remove(this.synchroniseHo);
        if (actingMaster) {
            this.trayIcon.setImage(IconLoader.getImage((String)"/ordermate/images/acting_master.png"));
            this.trayIcon.setToolTip("ServerMate Acting Master since:" + FailoverManager.getInstanceSetup().getActualFailoverDate());
        } else {
            this.trayIcon.setImage(IconLoader.getImage((String)"/ordermate/images/slave.png"));
            this.trayIcon.setToolTip("ServerMate Slave");
        }
    }

    private Window getPopupWindow() {
        if (this.popupWindow != null && this.popupWindow.isValid()) {
            return this.popupWindow;
        }
        Frame dummyFrame = new Frame();
        this.popupWindow = new Window(dummyFrame);
        this.popupWindow.setBounds(-1, -1, 0, 0);
        this.popupWindow.setVisible(true);
        this.popupWindow.toFront();
        this.popupWindow.addWindowFocusListener(new WindowAdapter(){

            @Override
            public void windowLostFocus(WindowEvent ev) {
                ((Window)ev.getSource()).dispose();
            }
        });
        return this.popupWindow;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.checkDatabase) {
            this.doCheckDatabase();
        } else if (e.getSource() == this.showIPAddress) {
            this.doShowIPAddressExternal();
        } else if (e.getSource() == this.optimizeDatabase) {
            this.doOptimizeDatabase();
        } else if (e.getSource() == this.safeShutdown) {
            this.doSafeShutdown();
        } else if (e.getSource() == this.softwareLicense) {
            this.doSoftwareLicense();
        } else if (e.getSource() == this.exitServerMate) {
            this.shutdownServerMate();
        } else if (e.getSource() == this.startServermate) {
            this.startServermate();
        } else if (e.getSource() == this.restartServerMate) {
            this.restartServermate();
        } else if (e.getSource() == this.clearDocketCache) {
            this.doClearDocketCache();
        } else if (e.getSource() == this.pingDevmate) {
            this.doPingDevmate();
        } else if (e.getSource() == this.orderMateInfo) {
            this.doOrderMateInfo();
        } else if (e.getSource() == this.chainsawLogAnalyzer) {
            this.launchChainsaw();
        } else if (e.getSource() == this.synchroniseHo) {
            this.launchSynchroniseHo();
        } else if (e.getSource() == this.setStoreId) {
            this.showSetStoreIdScreen();
        } else if (e.getSource() == this.failoverFrame) {
            this.launchFailOver();
        } else if (e.getSource() == this.deployLauncher) {
            OrderMateLauncherDeployer.getInstance().showDeployDialog();
        } else if (e.getSource() == this.exitServerMateClient) {
            this.shutdownServermateClient();
        }
    }

    private void createServermateStartService() {
        InputStream is = this.getClass().getResourceAsStream("/startServermateService.bat");
        ServerMateClient.LOG.info("Inputstream :: " + is);
        if (is != null) {
            ServerMateClient.LOG.info("startServermateService is found in jar");
            try {
                FileOutputStream fout = new FileOutputStream("c:\\temp\\startServermateService.bat");
                int input = 0;
                while ((input = is.read()) != -1) {
                    System.out.print("" + (char)input);
                    fout.write(input);
                }
                fout.flush();
                fout.close();
            }
            catch (IOException e) {
                ServerMateClient.LOG.info(e.getMessage(), (Throwable)e);
            }
        } else {
            ServerMateClient.LOG.info("StartServermateService is not found in jar");
        }
    }

    public PopupMenu getPopupMenu() {
        return this.popupMenu;
    }

    private void startServermate() {
        File ss = new File(System.getProperty("user.dir"));
        String fileLocation = "c:\\temp\\startServermateService.bat";
        System.out.println("User dir abs path " + ss.getAbsolutePath());
        try {
            File f = new File(fileLocation);
            if (!f.exists()) {
                this.createServermateStartService();
            }
            ProcessUtil.runCmd((String)fileLocation);
            ServerMateClient.LOG.info("Servermate Service startup initiated");
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this.serverMateFrame, "Problem starting ServerMateService : " + e.getMessage(), "Error", 0);
            ServerMateClient.LOG.error("Problem starting ServerMateService : " + e.getMessage(), (Throwable)e);
        }
    }

    private void restartServermate() {
        try {
            ProcessUtil.restartService((String)"ServerMateService");
            ServerMateClient.LOG.info("Servermate Service startup initiated");
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this.serverMateFrame, "Problem restarting ServerMateService : " + e.getMessage(), "Error", 0);
            ServerMateClient.LOG.error("Problem starting ServerMateService : " + e.getMessage(), (Throwable)e);
        }
    }

    private void shutdownServermateClient() {
        ServerMateClient.LOG.info("Shutting down Servermate Client ");
        System.exit(0);
    }

    private void shutdownServerMate() {
        ServerMateEndPointRef.shutdownServerMate();
    }

    private void showSetStoreIdScreen() {
        ServerMateFrame.setStoreId(ServerMateFrame.getFrame());
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getSource() == this.trayIcon && (e.getModifiers() & 0x10) == 16) {
            Window parent = this.getPopupWindow();
            parent.add(this.trayIcon.getPopupMenu());
            this.trayIcon.getPopupMenu().show(this.getPopupWindow(), e.getPoint().x, e.getPoint().y);
        }
    }

    private PopupMenu initPopupMenu() {
        PopupMenu popup = new PopupMenu();
        this.initMenuItem(popup, "Hide this menu");
        this.orderMateInfo = this.initMenuItem(popup, "Show ServerMate Info");
        this.showIPAddress = this.initMenuItem(popup, "Show IP Address");
        this.pingDevmate = this.initMenuItem(popup, "Ping remote monitoring");
        this.clearDocketCache = this.initMenuItem(popup, "Clear Server Caches");
        this.chainsawLogAnalyzer = this.initMenuItem(popup, "Log analyzer");
        popup.addSeparator();
        this.failoverFrame = this.initMenuItem(popup, "Failover");
        this.deployLauncher = this.initMenuItem(popup, "OrderMate Launcher Deploy...");
        this.checkDatabase = this.initMenuItem(popup, "Check and repair database");
        this.optimizeDatabase = this.initMenuItem(popup, "Optimize database");
        this.safeShutdown = this.initMenuItem(popup, "Safe Restart");
        if (!Config.getBooleanValue((String)"disable_sync")) {
            this.synchroniseHo = this.initMenuItem(popup, "Synchronise HO");
        }
        this.setStoreId = this.initMenuItem(popup, "Set Store Id");
        this.softwareLicense = this.initMenuItem(popup, "License Options");
        this.exitServerMateClient = this.initMenuItem(popup, "Exit ServermateClient");
        popup.addSeparator();
        this.exitServerMate = this.initMenuItem(popup, "Shutdown Servermate");
        this.startServermate = this.initMenuItem(popup, "Start Servermate");
        this.restartServerMate = this.initMenuItem(popup, "Restart Servermate");
        return popup;
    }

    private MenuItem initMenuItem(PopupMenu popup, String displayName) {
        MenuItem menuItem = new MenuItem(displayName);
        menuItem.setName(displayName);
        menuItem.addActionListener(this);
        popup.add(menuItem);
        return menuItem;
    }

    private void doCheckDatabase() {
        if (0 == JOptionPane.showConfirmDialog(null, "This may take a few minutes.\n Are you sure you want to check the database for errors? ", "Check database?", 0)) {
            ServerMate.LOG.info("Check database requested by user.");
            if (ServerMateEndPointRef.checkDatabase()) {
                this.trayIcon.displayMessage("Database is OK", "No problems have been detected", TrayIcon.MessageType.INFO);
            } else {
                this.trayIcon.displayMessage("Database problems detected", "Problems have been detected with the database.  Servermate will now attempt to repair", TrayIcon.MessageType.WARNING);
                ServerMateEndPointRef.repair();
                if (ServerMateEndPointRef.checkDatabase()) {
                    this.trayIcon.displayMessage("Database OK", "Database was successfully repaired.", TrayIcon.MessageType.INFO);
                } else {
                    this.trayIcon.displayMessage("Unable to repair", "ServerMate could not repair database", TrayIcon.MessageType.ERROR);
                }
            }
        }
    }

    private void doOptimizeDatabase() {
        if (0 == JOptionPane.showConfirmDialog(null, "This may take a long time.\n Check and repair database is much quicker\n\nAre you sure you want to optimize the database? ", "Optimize database?", 0)) {
            ServerMate.LOG.info("OPTIMIZE database requested by user.");
            if (ServerMateEndPointRef.checkDatabase()) {
                this.trayIcon.displayMessage("Database is OK", "No problems have been detected.  ServerMate will now optimize the database.", TrayIcon.MessageType.INFO);
            } else {
                this.trayIcon.displayMessage("Database problems detected", "Problems have been detected with the database.  Servermate will now attempt to repair", TrayIcon.MessageType.WARNING);
                ServerMateEndPointRef.repair();
                if (ServerMateEndPointRef.checkDatabase()) {
                    this.trayIcon.displayMessage("Database OK", "Database was successfully repaired.", TrayIcon.MessageType.INFO);
                }
            }
            ServerMateEndPointRef.optimize();
            this.trayIcon.displayMessage("Database Optimized", "The database is now optimized.", TrayIcon.MessageType.INFO);
        }
    }

    private void doShowIPAddressExternal() {
        String IPAddress = ServerMateEndPointRef.getIPAddress();
        if (IPAddress.equalsIgnoreCase("")) {
            this.trayIcon.displayMessage("IP Address not found", "Servermate could not determine your IP Address", TrayIcon.MessageType.WARNING);
        } else {
            this.trayIcon.displayMessage("IP Address", "Your IP Address is " + IPAddress, TrayIcon.MessageType.INFO);
        }
    }

    private void doSafeShutdown() {
        this.serverMateFrame.safeRestart();
    }

    private void doSoftwareLicense() {
        ServerMateFrame.softwareLicense(this.serverMateFrame);
    }

    private void doClearDocketCache() {
        ServerMateEndPointRef.doClearDocketCache();
        this.trayIcon.displayMessage("Docket Cache Cleared", "Successfully cleared the docket cache", TrayIcon.MessageType.INFO);
    }

    private void doPingDevmate() {
        RemoteMonitor monitor = new RemoteMonitor(SystemProperty.getInstance().getRemoteMonitorUrl());
        if (monitor.sendMessage(RemoteMonitor.constructMessage((int)0))) {
            this.trayIcon.displayMessage("Ping OK", "Successfully connected to remote monitoring", TrayIcon.MessageType.INFO);
        } else {
            this.trayIcon.displayMessage("Ping FAILED", "Could not connect to remote monitoring", TrayIcon.MessageType.WARNING);
        }
    }

    private void doOrderMateInfo() {
        if (this.infoDialog == null) {
            this.infoDialog = new ServerMateInfoDialog(this.serverMateFrame);
        }
        this.infoDialog.showInfo();
    }

    private void displayFrameGui() {
        this.serverMateFrame.setVisible(true);
        this.serverMateFrame.setExtendedState(1);
    }

    private void launchChainsaw() {
        String app_server = Config.getStringValue((String)"app_server");
        String chainsawJNLP = "http://" + app_server + "/webstart/chainsaw.jnlp";
        String msg = "Launch chainsaw log analyzer with jnlp:  " + chainsawJNLP;
        try {
            ServerMate.LOG.info(msg);
            Runtime.getRuntime().exec("javaws " + chainsawJNLP);
        }
        catch (Exception ex) {
            ServerMate.LOG.warn("Could not " + msg, (Throwable)ex);
        }
    }

    private void launchSynchroniseHo() {
        SynchronisationDialog.start(this.serverMateFrame);
    }

    private void launchFailOver() {
        FailoverManager.getInstanceSetup();
        FailoverManager.getInstance().setupFailover();
        this.updateForFailover();
    }
}

