/*
 * Decompiled with CFR 0.152.
 */
package servermate.gui;

import java.awt.Toolkit;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.ProgressMonitor;
import javax.swing.SwingWorker;
import servermate.ServerMate;

public class TimedCancelDialog
implements PropertyChangeListener {
    private ProgressMonitor progressMonitor;
    private Task task;
    private final int seconds;
    private final String message;

    public TimedCancelDialog(int delay, String message) {
        this.seconds = delay;
        this.message = message;
    }

    public boolean start() {
        this.progressMonitor = new ProgressMonitor(null, this.message, "You can cancel the task", 0, this.seconds);
        this.progressMonitor.setProgress(0);
        this.progressMonitor.setMillisToPopup(0);
        this.task = new Task();
        this.task.addPropertyChangeListener(this);
        this.task.execute();
        try {
            this.task.get();
        }
        catch (Exception ignore) {
            ServerMate.LOG.debug((Object)ignore);
        }
        return !this.progressMonitor.isCanceled();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("progress".equals(evt.getPropertyName())) {
            Integer progress = (Integer)evt.getNewValue();
            this.progressMonitor.setProgress(progress);
            String note = this.seconds - progress + " seconds remaining.\n";
            this.progressMonitor.setNote(note);
            if (this.progressMonitor.isCanceled()) {
                this.task.cancel(true);
            }
        }
    }

    private class Task
    extends SwingWorker {
        private Task() {
        }

        public Object doInBackground() {
            int progress = 0;
            this.setProgress(0);
            try {
                Thread.sleep(1000L);
                while (progress < TimedCancelDialog.this.seconds && !this.isCancelled()) {
                    Thread.sleep(1000L);
                    this.setProgress(++progress);
                }
            }
            catch (InterruptedException ignore) {
                ServerMate.LOG.debug((Object)ignore);
            }
            return null;
        }

        @Override
        public void done() {
            Toolkit.getDefaultToolkit().beep();
        }
    }
}

