/*
 * Decompiled with CFR 0.152.
 */
package servermate.gui.license;

import java.util.Date;
import java.util.HashMap;
import ordermate.OrderMate;
import ordermate.security.impl.SecurityDetails;
import ordermate.security.impl.db.DBSecurityDetails;

class SecurityDetailsService {
    private static final String MAC = "MAC Address";
    private static final String EXP = "Expiry Date";
    private static final String LAST = "Last Date Run";
    private static final String USER = "Database Username";
    private static final String WM = "WaiterMate Licenses";
    private static final String LIC_HASH = "Licence Hash";
    private SecurityDetails securityDetailsFromGUI;

    SecurityDetailsService() {
    }

    public SecurityDetailsService(SecurityDetails securityDetailsFromGUI) {
        this.securityDetailsFromGUI = securityDetailsFromGUI;
    }

    private SecurityDetails getSecurityDetails() {
        if (this.securityDetailsFromGUI == null) {
            return new DBSecurityDetails();
        }
        return this.securityDetailsFromGUI;
    }

    boolean importDetails(String value) {
        String[] splits = value.split(":");
        HashMap<String, String> pairs = new HashMap<String, String>();
        for (String line : splits) {
            String[] split = line.split(",");
            if (split.length != 2) continue;
            pairs.put(split[0].trim(), split[1]);
        }
        SecurityDetails details = this.getSecurityDetails();
        try {
            String mac = (String)pairs.get(MAC);
            Date exp = new Date(Long.parseLong((String)pairs.get(EXP)));
            Date last = new Date(Long.parseLong((String)pairs.get(LAST)));
            String user = (String)pairs.get(USER);
            int wm = Integer.parseInt((String)pairs.get(WM));
            details.setRecordedMacAddress(mac);
            details.setExpiryDate(exp);
            details.setLastRunDate(last);
            details.setDBUsername(user);
            details.setNumWaitermateTerminals(wm);
            if (pairs.containsKey(LIC_HASH)) {
                details.setLicenseHash((String)pairs.get(LIC_HASH));
            }
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Cannot read in licence details.", (Throwable)ex);
            return false;
        }
        return true;
    }
}

